/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.offer.widgets;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.ui.admin.AdminHandler;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.offer.OfferListColumnFactory;
import com.jurismarches.vradi.ui.offer.models.OfferListTableModel;
import com.jurismarches.vradi.ui.offer.widgets.*;
import com.jurismarches.vradi.ui.search.PaginationUI;
import com.jurismarches.vradi.ui.search.SearchHandler;
import com.jurismarches.vradi.ui.search.SearchUI;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class SelectFormUI extends javax.swing.JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_FORM_ID = "formId";
    public static final String PROPERTY_OFFER_LIST_COLUMN_FACTORY = "offerListColumnFactory";
    public static final String PROPERTY_RESULT_TABLE_MODEL = "resultTableModel";
    public static final String PROPERTY_SELECTED = "selected";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JBUTTON1_ENABLED = "$JButton1.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.offer.widgets.SelectFormUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.lang.String formId;
    protected com.jurismarches.vradi.ui.offer.OfferListColumnFactory offerListColumnFactory;
    protected com.jurismarches.vradi.ui.search.PaginationUI paginationUI;
    protected com.jurismarches.vradi.ui.offer.OfferTable resultTable;
    protected com.jurismarches.vradi.ui.offer.models.OfferListTableModel resultTableModel;
    protected javax.swing.JPanel searchPanel;
    protected SelectFormUI selectFormUI = this;
    protected java.lang.Boolean selected;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private javax.swing.JPanel $JPanel0;
    private javax.swing.JScrollPane $JScrollPane0;
    private jaxx.runtime.swing.Table $Table0;
    private javax.swing.JButton $JButton0;
    private javax.swing.JButton $JButton1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected AdminHandler getHandler() {
        return getContextValue(AdminHandler.class);
    }
    
    public SearchHandler getSearchHandler() {
        return UIHelper.getHandler(this, SearchHandler.class);
    }
    
    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }
    
    public SearchUI getSearchUI() {
        return (SearchUI) searchPanel.getComponent(0);
    }
    
    void $afterCompleteSetup() {
        OfferListTableModel.OfferListTableModelBinding djb = new OfferListTableModel.OfferListTableModelBinding(this,
                "resultTableModel", resultTableModel) {
    
            @Override
            public void processDataBinding() {
                if (resultTableModel != null) {
                    SearchUI searchUI = getSearchUI();
                    getSearchHandler().executeQuery(searchUI);
                }
            }
        };
    
        // Add listener select
        resultTable.getSelectionModel().addListSelectionListener(new ListSelectionListener() {
    
            @Override
            public void valueChanged(ListSelectionEvent e) {
                ListSelectionModel selectionModel = (ListSelectionModel)e.getSource();
                int selectionIndex = selectionModel.getLeadSelectionIndex();
                setSelected(selectionIndex != -1);
            }
        });
    
        registerDataBinding(djb);
        djb.applyDataBinding();
    
        validate();
        this.pack();
    
        // Register for save disposition
        UIHelper.registerComponentToSaveDispositionConfig(this);
    }
    
    protected void selectAndClose() {
        int selectedRow = resultTable.getSelectedRow();
        setFormId(resultTableModel.getFormIdAt(selectedRow));
        close();
    }
    
    protected void close() {
       setVisible(false);
       dispose();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SelectFormUI() {
        $initialize();
    }

    public SelectFormUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        close();
    }

    public void doActionPerformed__on__$JButton1(java.awt.event.ActionEvent event) {
        selectAndClose();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public java.lang.String getFormId() {
        return formId;
    }

    public com.jurismarches.vradi.ui.offer.OfferListColumnFactory getOfferListColumnFactory() {
        return offerListColumnFactory;
    }

    public com.jurismarches.vradi.ui.search.PaginationUI getPaginationUI() {
        return paginationUI;
    }

    public com.jurismarches.vradi.ui.offer.OfferTable getResultTable() {
        return resultTable;
    }

    public com.jurismarches.vradi.ui.offer.models.OfferListTableModel getResultTableModel() {
        return resultTableModel;
    }

    public javax.swing.JPanel getSearchPanel() {
        return searchPanel;
    }

    public java.lang.Boolean getSelected() {
        return selected;
    }

    public java.lang.Boolean isSelected() {
        return selected !=null && selected;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setFormId(java.lang.String newValue) {
        java.lang.String oldValue = this.formId;
        this.formId = newValue;
        firePropertyChange(PROPERTY_FORM_ID, oldValue, newValue);
    }

    public void setOfferListColumnFactory(com.jurismarches.vradi.ui.offer.OfferListColumnFactory newValue) {
        com.jurismarches.vradi.ui.offer.OfferListColumnFactory oldValue = this.offerListColumnFactory;
        this.offerListColumnFactory = newValue;
        firePropertyChange(PROPERTY_OFFER_LIST_COLUMN_FACTORY, oldValue, newValue);
    }

    public void setResultTableModel(com.jurismarches.vradi.ui.offer.models.OfferListTableModel newValue) {
        com.jurismarches.vradi.ui.offer.models.OfferListTableModel oldValue = this.resultTableModel;
        this.resultTableModel = newValue;
        firePropertyChange(PROPERTY_RESULT_TABLE_MODEL, oldValue, newValue);
    }

    public void setSelected(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.selected;
        this.selected = newValue;
        firePropertyChange(PROPERTY_SELECTED, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected jaxx.runtime.swing.Table get$Table0() {
        return $Table0;
    }

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    protected javax.swing.JButton get$JButton1() {
        return $JButton1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToSelectFormUI() {
        if (!allComponentsCreated) {
            return;
        }
        add(searchPanel, BorderLayout.NORTH);
        add($JPanel0, BorderLayout.CENTER);
        add($Table0, BorderLayout.SOUTH);
    }

    protected void createFormId() {
        $objectMap.put("formId", formId = null);
    }

    protected void createOfferListColumnFactory() {
        $objectMap.put("offerListColumnFactory", offerListColumnFactory = getContextValue(OfferListColumnFactory.class));
    }

    protected void createPaginationUI() {
        $objectMap.put("paginationUI", paginationUI = new com.jurismarches.vradi.ui.search.PaginationUI(this));
        
        paginationUI.setName("paginationUI");
    }

    protected void createResultTable() {
        $objectMap.put("resultTable", resultTable = new com.jurismarches.vradi.ui.offer.OfferTable());
        
        resultTable.setName("resultTable");
    }

    protected void createResultTableModel() {
        $objectMap.put("resultTableModel", resultTableModel = getContextValue(OfferListTableModel.class));
    }

    protected void createSearchPanel() {
        $objectMap.put("searchPanel", searchPanel = new javax.swing.JPanel());
        
        searchPanel.setName("searchPanel");
        searchPanel.setLayout(new BorderLayout());
    }

    protected void createSelected() {
        $objectMap.put("selected", selected = false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToSelectFormUI();
        // inline complete setup of $JPanel0
        $JPanel0.add($JScrollPane0, BorderLayout.CENTER);
        $JPanel0.add(paginationUI, BorderLayout.SOUTH);
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(resultTable);
        // inline complete setup of $Table0
        $Table0.add($JButton0, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add($JButton1, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        
        // apply 1 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 15 property setters
        resultTableModel.setNbFormsPerPage(10);
        resultTableModel.setPageToShow(1);
        resultTable.setAutoResizeMode(2);
        resultTable.setColumnControlVisible(true);
        resultTable.setColumnFactory(offerListColumnFactory);
        resultTable.setGridColor(Color.GRAY);
        resultTable.setHorizontalScrollEnabled(true);
        resultTable.setModel(resultTableModel);
        resultTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        resultTable.setShowGrid(true);
        $JButton0.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("close"));
        $JButton1.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("accept"));
        // late initializer
        selectFormUI.pack();
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("selectFormUI", this);
        createFormId();
        createSelected();
        createOfferListColumnFactory();
        createResultTableModel();
        createSearchPanel();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new javax.swing.JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createResultTable();
        createPaginationUI();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new jaxx.runtime.swing.Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("vradi.common.close"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new javax.swing.JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setText(_("vradi.action.select"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        // inline creation of selectFormUI
        setName("selectFormUI");
        selectFormUI.getContentPane().setLayout(new BorderLayout());
        setModal(true);
        setTitle(_("vradi.selectForm.title"));
        
        // registers 1 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 1 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON1_ENABLED, true ,"selected") {
        
            @Override
            public void processDataBinding() {
                $JButton1.setEnabled(isSelected());
            }
        });
    }

}