/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: EntityModel.java 1808 2010-11-25 14:27:29Z sletellier $
 * $HeadURL: svn+ssh://sletellier@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.5.1/vradi-swing/src/main/java/com/jurismarches/vradi/ui/models/EntityModel.java $
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.models;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiEntitiesListener;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.entities.BusinessEntity;

/**
 * @author letellier
 */
public class EntityModel<E extends BusinessEntity> extends AbstractListModel implements ComboBoxModel, VradiEntitiesListener<E> {

    /**
     * Logger
     */
    private static final Log log = LogFactory.getLog(EntityModel.class);

    protected Map<String, E> datas;
    protected E selected;
    protected boolean firstNull = true;

    public EntityModel(Class<E> clazz, List<E> datas){
        this(clazz, datas, true);
    }

    public EntityModel(Class<E> clazz, List<E> datas, boolean firstNull){
        this.firstNull = firstNull;
        this.datas = new HashMap<String, E>();
        fillDatas(datas);
        VradiContext.get().getVradiNotifier().addVradiListener(clazz, this);
    }

    protected void fillDatas(List<E> datas) {
        if (datas == null) {
            return;
        }
        for (E data : datas) {
            if (data != null) {
                this.datas.put(data.getWikittyId(), data);
            }
        }
    }

    @Override
    public int getSize() {
        if (firstNull){
            return datas.size() + 1;
        }
        return datas.size();
    }

    @Override
    public Object getElementAt(int index) {
        if (firstNull){
            if (index == 0){
                return null;
            }

            List<String> keys = new ArrayList<String>(datas.keySet());
            return datas.get(keys.get(index - 1));
        }
        List<String> keys = new ArrayList<String>(datas.keySet());
        return datas.get(keys.get(index));
    }

    @SuppressWarnings({"unchecked"})
    @Override
    public void setSelectedItem(Object anItem) {
        selected = (E) anItem;
    }

    @Override
    public Object getSelectedItem() {
        return selected;
    }

    protected void updateDatas(List<E> datas){
        fillDatas(datas);
        fireContentsChanged(this, 0, datas.size() - 1);
    }

    @Override
    public void entitiesAdded(Set<E> added) {
        for (E entity : added) {
            datas.put(entity.getWikittyId(), entity);
        }
        fireContentsChanged(this, 0, datas.size() - 1);
    }

    @Override
    public void entitiesRemoved(Set<String> removed) {
        for (String wikittyId : removed) {
            datas.remove(wikittyId);
        }
        fireContentsChanged(this, 0, datas.size() - 1);
    }
}
