/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: ThesaurusQueryChangesHandler.java 1774 2010-11-15 12:29:52Z sletellier $
 * $HeadURL: svn+ssh://sletellier@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.5.1/vradi-swing/src/main/java/com/jurismarches/vradi/ui/admin/popups/ThesaurusQueryChangesHandler.java $
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.admin.popups;

import java.util.List;
import java.util.Map;

import javax.swing.DefaultCellEditor;
import javax.swing.table.TableColumn;

import com.jurismarches.vradi.entities.Group;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXInitialContext;

import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.jdesktop.swingx.treetable.TreeTableModel;

import com.jurismarches.vradi.beans.QueryBean;
import com.jurismarches.vradi.ui.admin.query.QueryCellEditor;
import com.jurismarches.vradi.ui.admin.query.QueryCheckCellRenderer;
import com.jurismarches.vradi.ui.admin.query.ThesaurusChangesTreeTableModel;

/**
 * ThesaurusQueryChangesHandler.
 *
 * @author schorlet
 * @version $Revision: 1774 $ $Date: 2010-11-15 13:29:52 +0100 (lun., 15 nov. 2010) $
 * @since 25 mars 2010 15:05:55
 */
public class ThesaurusQueryChangesHandler {

    public static final String QUERY = "query";
    public static final String ROOT_BEFORE_MODIF = "rootBeforeModif";
    public static final String THESAURUS_BEFORE_MODIF = "thesaurusBeforeModif";
    public static final String ROOT_AFTER_MODIF = "rootAfterModif";
    public static final String THESAURUS_AFTER_MODIF = "thesaurusAfterModif";

    public ThesaurusQueryChangesUI initUI(JAXXContext rootContext, Map<Group, List<QueryBean>> queries,
            String rootThesaurusBefore, String rootThesaurusAfter,
            String thesaurusBefore, String thesaurusAfter) {
        JAXXInitialContext context = new JAXXInitialContext().add(rootContext).add(this);
        context.add(QUERY, queries);
        context.add(ROOT_BEFORE_MODIF, rootThesaurusBefore);
        context.add(ROOT_AFTER_MODIF, rootThesaurusAfter);

        if (thesaurusAfter != null) {
            context.add(THESAURUS_AFTER_MODIF, thesaurusAfter);
            context.add(THESAURUS_BEFORE_MODIF, thesaurusBefore);
        }

        ThesaurusQueryChangesUI thesaurusChangesUI = new ThesaurusQueryChangesUI(context);
        final JXTreeTable resultTreeTable = thesaurusChangesUI.getResultTreeTable();
        resultTreeTable.expandAll();
        
        // editor column
        TableColumn column = resultTreeTable.getColumnModel().getColumn(3);
        column.setCellEditor(new QueryCellEditor(rootContext));
        
        // checkbox column
        column = resultTreeTable.getColumnModel().getColumn(4);
        QueryCheckCellRenderer checkBox = new QueryCheckCellRenderer();
        column.setCellRenderer(checkBox);
        column.setCellEditor(new DefaultCellEditor(checkBox));
        column.setMaxWidth((int)checkBox.getPreferredSize().getWidth());
        
        final Highlighter highlighter = HighlighterFactory.createAlternateStriping(
        HighlighterFactory.NOTEPAD, HighlighterFactory.GENERIC_GRAY);
        resultTreeTable.addHighlighter(highlighter);
        
        return thesaurusChangesUI;
    }

    void close(ThesaurusQueryChangesUI context) {
        context.setVisible(false);
        context.dispose();
    }
     
    public TreeTableModel getResultTreeTableModel(ThesaurusQueryChangesUI context) {
        ThesaurusChangesTreeTableModel treeTableModel = context.getContextValue(ThesaurusChangesTreeTableModel.class);
        if (treeTableModel == null) {
            Map<Group, List<QueryBean>> queries = context.getContextValue(Map.class, QUERY);
            String rootThesaurusBefore = context.getContextValue(String.class, ROOT_BEFORE_MODIF);
            String rootThesaurusAfter = context.getContextValue(String.class, ROOT_AFTER_MODIF);
            String thesaurusBefore = context.getContextValue(String.class, THESAURUS_BEFORE_MODIF);
            String thesaurusAfter = context.getContextValue(String.class, THESAURUS_AFTER_MODIF);

            treeTableModel = new ThesaurusChangesTreeTableModel(queries,rootThesaurusBefore, rootThesaurusAfter , thesaurusBefore, thesaurusAfter);
            context.setContextValue(treeTableModel);
        }
        return treeTableModel;
    }
}
