/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.admin.popups;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.ui.admin.AdminHandler;
import com.jurismarches.vradi.ui.admin.popups.*;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.offer.OfferListColumnFactory;
import com.jurismarches.vradi.ui.offer.models.OfferListTableModel;
import com.jurismarches.vradi.ui.search.PaginationUI;
import com.jurismarches.vradi.ui.search.SearchHandler;
import com.jurismarches.vradi.ui.search.SearchUI;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class AdminRequestUI extends javax.swing.JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_CAN_SAVE = "canSave";
    public static final String PROPERTY_OFFER_LIST_COLUMN_FACTORY = "offerListColumnFactory";
    public static final String PROPERTY_REQUEST = "request";
    public static final String PROPERTY_RESULT_TABLE_MODEL = "resultTableModel";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_VALID_BUTTON_VISIBLE = "validButton.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.admin.popups.AdminRequestUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected AdminRequestUI adminRequestUI = this;
    protected java.lang.Boolean canSave;
    protected javax.swing.JButton closeButton;
    protected com.jurismarches.vradi.ui.offer.OfferListColumnFactory offerListColumnFactory;
    protected com.jurismarches.vradi.ui.search.PaginationUI paginationUI;
    protected java.lang.String request;
    protected com.jurismarches.vradi.ui.offer.OfferTable resultTable;
    protected com.jurismarches.vradi.ui.offer.models.OfferListTableModel resultTableModel;
    protected javax.swing.JPanel searchPanel;
    protected javax.swing.JButton validButton;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private javax.swing.JPanel $JPanel0;
    private javax.swing.JScrollPane $JScrollPane0;
    private jaxx.runtime.swing.Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected AdminHandler getHandler() {
        return getContextValue(AdminHandler.class);
    }
    
    public SearchHandler getSearchHandler() {
        return UIHelper.getHandler(this, SearchHandler.class);
    }
    
    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }
    
    public SearchUI getSearchUI() {
        return (SearchUI) searchPanel.getComponent(0);
    }
    
    void $afterCompleteSetup() {
        OfferListTableModel.OfferListTableModelBinding djb = new OfferListTableModel.OfferListTableModelBinding(this,
                "resultTableModel", resultTableModel) {
            @Override
            public void processDataBinding() {
                if (resultTableModel != null) {
                    SearchUI searchUI = getSearchUI();
                    getSearchHandler().executeQuery(searchUI);
                }
            }
        };
    
        registerDataBinding(djb);
        djb.applyDataBinding();
        
        validate();
    
        this.pack();
        
        // Register for save disposition
        UIHelper.registerComponentToSaveDispositionConfig(this);
    }
    
    protected void saveAndClose() {
        setRequest(getSearchUI().getRequest());
        close();
    }
    
    protected void close() {
        UIHelper.saveComponentDispositionConfig();
        setVisible(false);
        dispose();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AdminRequestUI() {
        $initialize();
    }

    public AdminRequestUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__closeButton(java.awt.event.ActionEvent event) {
        close();
    }

    public void doActionPerformed__on__validButton(java.awt.event.ActionEvent event) {
        saveAndClose();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public java.lang.Boolean getCanSave() {
        return canSave;
    }

    public javax.swing.JButton getCloseButton() {
        return closeButton;
    }

    public com.jurismarches.vradi.ui.offer.OfferListColumnFactory getOfferListColumnFactory() {
        return offerListColumnFactory;
    }

    public com.jurismarches.vradi.ui.search.PaginationUI getPaginationUI() {
        return paginationUI;
    }

    public java.lang.String getRequest() {
        return request;
    }

    public com.jurismarches.vradi.ui.offer.OfferTable getResultTable() {
        return resultTable;
    }

    public com.jurismarches.vradi.ui.offer.models.OfferListTableModel getResultTableModel() {
        return resultTableModel;
    }

    public javax.swing.JPanel getSearchPanel() {
        return searchPanel;
    }

    public javax.swing.JButton getValidButton() {
        return validButton;
    }

    public java.lang.Boolean isCanSave() {
        return canSave !=null && canSave;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setCanSave(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.canSave;
        this.canSave = newValue;
        firePropertyChange(PROPERTY_CAN_SAVE, oldValue, newValue);
    }

    public void setOfferListColumnFactory(com.jurismarches.vradi.ui.offer.OfferListColumnFactory newValue) {
        com.jurismarches.vradi.ui.offer.OfferListColumnFactory oldValue = this.offerListColumnFactory;
        this.offerListColumnFactory = newValue;
        firePropertyChange(PROPERTY_OFFER_LIST_COLUMN_FACTORY, oldValue, newValue);
    }

    public void setRequest(java.lang.String newValue) {
        java.lang.String oldValue = this.request;
        this.request = newValue;
        firePropertyChange(PROPERTY_REQUEST, oldValue, newValue);
    }

    public void setResultTableModel(com.jurismarches.vradi.ui.offer.models.OfferListTableModel newValue) {
        com.jurismarches.vradi.ui.offer.models.OfferListTableModel oldValue = this.resultTableModel;
        this.resultTableModel = newValue;
        firePropertyChange(PROPERTY_RESULT_TABLE_MODEL, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected jaxx.runtime.swing.Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAdminRequestUI() {
        if (!allComponentsCreated) {
            return;
        }
        add(searchPanel, BorderLayout.NORTH);
        add($JPanel0, BorderLayout.CENTER);
        add($Table0, BorderLayout.SOUTH);
    }

    protected void createCanSave() {
        $objectMap.put("canSave", canSave = true);
    }

    protected void createCloseButton() {
        $objectMap.put("closeButton", closeButton = new javax.swing.JButton());
        
        closeButton.setName("closeButton");
        closeButton.setText(_("vradi.common.close"));
        closeButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__closeButton"));
    }

    protected void createOfferListColumnFactory() {
        $objectMap.put("offerListColumnFactory", offerListColumnFactory = getContextValue(OfferListColumnFactory.class));
    }

    protected void createPaginationUI() {
        $objectMap.put("paginationUI", paginationUI = new com.jurismarches.vradi.ui.search.PaginationUI(this));
        
        paginationUI.setName("paginationUI");
    }

    protected void createRequest() {
        $objectMap.put("request", request = null);
    }

    protected void createResultTable() {
        $objectMap.put("resultTable", resultTable = new com.jurismarches.vradi.ui.offer.OfferTable());
        
        resultTable.setName("resultTable");
    }

    protected void createResultTableModel() {
        $objectMap.put("resultTableModel", resultTableModel = getContextValue(OfferListTableModel.class));
    }

    protected void createSearchPanel() {
        $objectMap.put("searchPanel", searchPanel = new javax.swing.JPanel());
        
        searchPanel.setName("searchPanel");
        searchPanel.setLayout(new BorderLayout());
    }

    protected void createValidButton() {
        $objectMap.put("validButton", validButton = new javax.swing.JButton());
        
        validButton.setName("validButton");
        validButton.setText(_("vradi.adminRequest.valid"));
        validButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__validButton"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToAdminRequestUI();
        // inline complete setup of $JPanel0
        $JPanel0.add($JScrollPane0, BorderLayout.CENTER);
        $JPanel0.add(paginationUI, BorderLayout.SOUTH);
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(resultTable);
        // inline complete setup of $Table0
        $Table0.add(closeButton, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(validButton, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        
        // apply 1 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 14 property setters
        resultTableModel.setNbFormsPerPage(10);
        resultTableModel.setPageToShow(1);
        resultTable.setAutoResizeMode(2);
        resultTable.setColumnControlVisible(true);
        resultTable.setColumnFactory(offerListColumnFactory);
        resultTable.setGridColor(Color.GRAY);
        resultTable.setHorizontalScrollEnabled(true);
        resultTable.setModel(resultTableModel);
        resultTable.setShowGrid(true);
        closeButton.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("close"));
        validButton.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("accept"));
        // late initializer
        adminRequestUI.pack();
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("adminRequestUI", this);
        createRequest();
        createCanSave();
        createOfferListColumnFactory();
        createResultTableModel();
        createSearchPanel();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new javax.swing.JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createResultTable();
        createPaginationUI();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new jaxx.runtime.swing.Table());
        
        $Table0.setName("$Table0");
        createCloseButton();
        createValidButton();
        // inline creation of adminRequestUI
        setName("adminRequestUI");
        adminRequestUI.getContentPane().setLayout(new BorderLayout());
        setTitle(_("vradi.adminRequest.title"));
        
        // registers 1 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 1 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALID_BUTTON_VISIBLE, true ,"canSave") {
        
            @Override
            public void processDataBinding() {
                validButton.setVisible(isCanSave());
            }
        });
    }

}