/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.admin.content;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.entities.FieldTypeEnum;
import com.jurismarches.vradi.ui.admin.AdminHandler;
import com.jurismarches.vradi.ui.admin.content.*;
import com.jurismarches.vradi.ui.admin.models.FieldSelectModel;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.editor.*;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class FieldSelectUI extends jaxx.runtime.swing.Table implements JAXXObject, jaxx.runtime.JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_MODIFIED = "modified";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CLAZZ_COMBO_SELECTED_ITEM = "clazzCombo.selectedItem";
    public static final String BINDING_DESC_FIELD_TEXT = "descField.text";
    public static final String BINDING_NAME_FIELD_TEXT = "nameField.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.admin.content.FieldSelectUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected com.jurismarches.vradi.ui.admin.models.FieldSelectModel bean;
    protected javax.swing.JComboBox clazzCombo;
    protected javax.swing.JTextField descField;
    protected javax.swing.JButton down;
    protected java.lang.Boolean modified;
    protected javax.swing.JTextField nameField;
    protected javax.swing.JButton remove;
    protected FieldSelectUI requestSelectUI = this;
    protected javax.swing.JButton up;
    protected jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.ui.admin.models.FieldSelectModel > validator;
    protected java.util.List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private javax.swing.JLabel $JLabel0;
    private javax.swing.JLabel $JLabel1;
    private javax.swing.JLabel $JLabel2;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel contentPane;
    
    
    public void updateBean(FieldSelectModel model) {
        bean.update(model);
    }
    
    protected AdminHandler getHandler() {
        return getContextValue(AdminHandler.class);
    }
    
    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }
    
    public void setContentPane(JPanel contentPane){
        this.contentPane = contentPane;
    }
    
    void $afterCompleteSetup() {
        getContextValue(SwingValidatorMessageTableModel.class,"errorTable").registerValidator(validator);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public FieldSelectUI() {
        $initialize();
    }

    public FieldSelectUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidation implementation --------------------*/
    /*-----------------------------------------------------------------------*/

    public jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.ui.admin.models.FieldSelectModel > getValidator() {
        return validator;
    }

    @Override
    public jaxx.runtime.validator.swing.SwingValidator<?> getValidator(String validatorId) {
        return (jaxx.runtime.validator.swing.SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public java.util.List<String> getValidatorIds() {
        return validatorIds;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__clazzCombo(java.awt.event.ActionEvent event) {
        bean.setType((FieldTypeEnum) clazzCombo.getSelectedItem()); setModified(true);
    }

    public void doActionPerformed__on__down(java.awt.event.ActionEvent event) {
        bean.setUpOrDown(false); log.debug(bean.getNameValue() + " : " + bean.isUpOrDown()); setModified(null);
    }

    public void doActionPerformed__on__remove(java.awt.event.ActionEvent event) {
        bean.setUpOrDown(null); setModified(null);
    }

    public void doActionPerformed__on__up(java.awt.event.ActionEvent event) {
        bean.setUpOrDown(true); log.debug(bean.getNameValue() + " : " + bean.isUpOrDown()); setModified(null);
    }

    public void doKeyReleased__on__descField(java.awt.event.KeyEvent event) {
        bean.setDescValue(descField.getText()); setModified(true);
    }

    public void doKeyReleased__on__nameField(java.awt.event.KeyEvent event) {
        bean.setNameValue(nameField.getText().trim()); setModified(true);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public com.jurismarches.vradi.ui.admin.models.FieldSelectModel getBean() {
        return bean;
    }

    public javax.swing.JComboBox getClazzCombo() {
        return clazzCombo;
    }

    public javax.swing.JTextField getDescField() {
        return descField;
    }

    public javax.swing.JButton getDown() {
        return down;
    }

    public java.lang.Boolean getModified() {
        return modified;
    }

    public javax.swing.JTextField getNameField() {
        return nameField;
    }

    public javax.swing.JButton getRemove() {
        return remove;
    }

    public javax.swing.JButton getUp() {
        return up;
    }

    public java.lang.Boolean isModified() {
        return modified !=null && modified;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setModified(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.modified;
        this.modified = newValue;
        firePropertyChange(PROPERTY_MODIFIED, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerValidatorFields() {
        validator.setFieldRepresentation("descValue", descField);
        validator.setFieldRepresentation("nameValue", nameField);
        validator.setFieldRepresentation("type", clazzCombo);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected javax.swing.JLabel get$JLabel2() {
        return $JLabel2;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToRequestSelectUI() {
        if (!allComponentsCreated) {
            return;
        }
        add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(SwingUtil.boxComponentWithJxLayer(nameField), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JLabel1, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(SwingUtil.boxComponentWithJxLayer(descField), new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JLabel2, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(SwingUtil.boxComponentWithJxLayer(clazzCombo), new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(up, new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(down, new GridBagConstraints(7, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(remove, new GridBagConstraints(8, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(jaxx.runtime.validator.swing.ui.ImageValidationUI.class);
        validator.setBean(bean);
    }

    protected void createBean() {
        $objectMap.put("bean", bean = new com.jurismarches.vradi.ui.admin.models.FieldSelectModel());
    }

    protected void createClazzCombo() {
        $objectMap.put("clazzCombo", clazzCombo = new javax.swing.JComboBox());
        
        clazzCombo.setName("clazzCombo");
        clazzCombo.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__clazzCombo"));
    }

    protected void createDescField() {
        $objectMap.put("descField", descField = new javax.swing.JTextField());
        
        descField.setName("descField");
        descField.setColumns(15);
        descField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__descField"));
    }

    protected void createDown() {
        $objectMap.put("down", down = new javax.swing.JButton());
        
        down.setName("down");
        down.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__down"));
    }

    protected void createModified() {
        $objectMap.put("modified", modified = false);
    }

    protected void createNameField() {
        $objectMap.put("nameField", nameField = new javax.swing.JTextField());
        
        nameField.setName("nameField");
        nameField.setColumns(15);
        nameField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__nameField"));
    }

    protected void createRemove() {
        $objectMap.put("remove", remove = new javax.swing.JButton());
        
        remove.setName("remove");
        remove.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__remove"));
    }

    protected void createUp() {
        $objectMap.put("up", up = new javax.swing.JButton());
        
        up.setName("up");
        up.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__up"));
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = new jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.ui.admin.models.FieldSelectModel >(com.jurismarches.vradi.ui.admin.models.FieldSelectModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToRequestSelectUI();
        addChildrenToValidator();
        
        // apply 3 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 5 property setters
        clazzCombo.setModel(getHandler().getTypesModel());
        clazzCombo.setRenderer(UIHelper.getTranslationListCellRenderer());
        up.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("arrowUp"));
        down.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("arrowDown"));
        remove.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("delete"));
        // late initializer
        // register 1 validator(s)
        registerValidatorFields();validatorIds.add("validator");
        getValidator("validator").installUIs();
        getValidator("validator").reloadBean();
        validatorIds = java.util.Collections.unmodifiableList(validatorIds);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("requestSelectUI", this);
        createBean();
        createModified();
        createValidator();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.adminField.name"));
        createNameField();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("vradi.adminField.desc"));
        createDescField();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new javax.swing.JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("vradi.adminField.type"));
        createClazzCombo();
        createUp();
        createDown();
        createRemove();
        // inline creation of requestSelectUI
        setName("requestSelectUI");
        
        // registers 3 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 3 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_NAME_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (bean != null) {
                    bean.addPropertyChangeListener("nameValue", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (bean != null) {
                    jaxx.runtime.SwingUtil.setText(nameField, bean.getNameValue());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (bean != null) {
                    bean.removePropertyChangeListener("nameValue", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DESC_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (bean != null) {
                    bean.addPropertyChangeListener("descValue", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (bean != null) {
                    jaxx.runtime.SwingUtil.setText(descField, bean.getDescValue());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (bean != null) {
                    bean.removePropertyChangeListener("descValue", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CLAZZ_COMBO_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (bean != null) {
                    bean.addPropertyChangeListener("type", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (bean != null) {
                    clazzCombo.setSelectedItem(bean.getType());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (bean != null) {
                    bean.removePropertyChangeListener("type", this);
                }
            }
        });
    }

}