/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: ChangeLogHandler.java 1819 2010-12-07 17:30:42Z bpoussin $
 * $HeadURL: svn+ssh://sletellier@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.5.1/vradi-swing/src/main/java/com/jurismarches/vradi/ui/ChangeLogHandler.java $
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

import com.jurismarches.vradi.VradiConfig;
import com.jurismarches.vradi.VradiConfigHelper;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;

public class ChangeLogHandler {

    private static Log log = LogFactory.getLog(ChangeLogHandler.class);

    public static final String CHANGELOG_FILE = "/changelog.txt";

    public static final String CHANGELOG_VERSION_SEPARATOR = "---- ";

    public String getLatestChangeLog() {
        String content = loadSource();
        String[] versionChangeLogs = content.split(CHANGELOG_VERSION_SEPARATOR);
        String lastVersion = "";
        if (versionChangeLogs.length > 0 ) {
            lastVersion = versionChangeLogs[0];
            if (log.isDebugEnabled()) {
                log.debug(lastVersion);
            }
            lastVersion = lastVersion.replace(CHANGELOG_VERSION_SEPARATOR.substring(1), "");
            String[] lastVersionArray = lastVersion.split("\\s");
            if (lastVersionArray.length > 0) {
                lastVersion = lastVersionArray[0].trim();
            } else {
                lastVersion = "";
            }
        }
        log.debug(lastVersion);
        return versionChangeLogs[0];
    }

    public String getChangeLog() {
        StringBuffer result = new StringBuffer();
        String content = loadSource();
        if (content != null) {
            String[] versionChangeLogs = content.split(CHANGELOG_VERSION_SEPARATOR);

            versionChangeLogs = removeFirstEmptyLines(versionChangeLogs);

            String lastVersion = versionChangeLogs[0]
                    .replace(CHANGELOG_VERSION_SEPARATOR.substring(1), "")
                    .split("\\s")[0].trim();
            if (VradiHelper.isVersionNewer(lastVersion)) {
                result.append(versionChangeLogs[0]);
                for (int i = 1; i < versionChangeLogs.length; i++) {
                    log.debug(versionChangeLogs[i]);
                    String version = versionChangeLogs[i].split("\\s")[0].trim();
                    if (VradiHelper.isVersionNewer(version)) {
                        result.append(CHANGELOG_VERSION_SEPARATOR)
                                .append(versionChangeLogs[i]);
                    } else {
                        break;
                    }
                }
            }
            VradiConfig config = VradiContext.get().getVradiConfig();
            VradiConfigHelper.setLastVersion(config, lastVersion);
            config.saveForUser();
        }

        return result.toString();
    }

    protected String[] removeFirstEmptyLines(String[] versionChangeLogs) {
        for (String versionChangeLog : Arrays.asList(versionChangeLogs)) {
            if (StringUtils.isBlank(versionChangeLog)) {
                versionChangeLogs = Arrays.copyOfRange(versionChangeLogs, 1, versionChangeLogs.length);
            }
        }
        return versionChangeLogs;
    }

    public String loadSource() {
        try {
            InputStream changelogFile = getClass().getResourceAsStream(CHANGELOG_FILE);
            String result = IOUtils.toString(changelogFile);
            return result;
        } catch (IOException ex) {
            log.error("could not load file " + CHANGELOG_FILE, ex);
            return null;
        }
    }
}
