/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: OfferTable.java 1443 2010-09-20 08:50:49Z chatellier $
 * $HeadURL: svn+ssh://sletellier@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.3.1/vradi-swing/src/main/java/com/jurismarches/vradi/ui/offer/OfferTable.java $
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.offer;

import java.awt.event.MouseEvent;

import org.jdesktop.swingx.JXTable;
import org.nuiton.widget.tooltip.FocusableTip;

/**
 * Offer table.
 * 
 * Extends default JXTable with:
 * <ul>
 *  <li>Persistent tooltip support
 * </ul>
 * 
 * @author chatellier
 * @version $Revision: 1443 $
 * 
 * Last update : $Date: 2010-09-20 10:50:49 +0200 (lun., 20 sept. 2010) $
 * By : $Author: chatellier $
 */
public class OfferTable extends JXTable {

    /** serialVersionUID. */
    private static final long serialVersionUID = 4554858117023580350L;

    /** Single tooltip instance. */
    protected FocusableTip focusableTip;

    /*
     * @see javax.swing.JComponent#getToolTipText()
     */
    @Override
    public String getToolTipText(MouseEvent e) {

        // get original text
        String text = super.getToolTipText(e);

        // display it into persistant tooltip
        if (focusableTip == null) {
            focusableTip = new FocusableTip(this, null);
            focusableTip.setSize(600, 400);
        }
        focusableTip.toolTipRequested(e, text);

        return null;
    }
}
