/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: EntityModel.java 1715 2010-10-27 19:21:28Z tchemit $
 * $HeadURL: svn+ssh://sletellier@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.3.1/vradi-swing/src/main/java/com/jurismarches/vradi/ui/models/EntityModel.java $
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.models;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;

import com.jurismarches.vradi.services.VradiService;
import javax.swing.SwingUtilities;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.BusinessEntity;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyServiceEvent;
import org.nuiton.wikitty.WikittyServiceListener;

/**
 * @author letellier
 */
public class EntityModel<E extends BusinessEntity> extends AbstractListModel implements ComboBoxModel, WikittyServiceListener {

    /**
     * Logger
     */
    private static final Log log = LogFactory.getLog(EntityModel.class);

    protected Map<String, E> datas;
    protected E selected;
    protected boolean firstNull = true;
    protected String ext;
    protected Class<E> clazz;


    public EntityModel(Class<E> clazz, String ext, List<E> datas){
        this(clazz, ext, datas, true);
    }
    
    public EntityModel(Class<E> clazz, String ext, List<E> datas, boolean firstNull){
        this.firstNull = firstNull;
        this.datas = new HashMap<String, E>();
        fillDatas(datas);
        this.ext = ext;
        this.clazz = clazz;
        
        // register each tree on wikitty service
        VradiService.getWikittyService().addWikittyServiceListener(this, WikittyService.ServiceListenerType.ALL);
    }

    protected void fillDatas(List<E> datas) {
        if (datas == null) {
            return;
        }
        for (E data : datas) {
            if (data != null) {
                this.datas.put(data.getWikittyId(), data);
            }
        }
    }

    @Override
    public int getSize() {
        if (firstNull){
            return datas.size() + 1;
        }
        return datas.size();
    }

    @Override
    public Object getElementAt(int index) {
        if (firstNull){
            if (index == 0){
                return null;
            }

            List<String> keys = new ArrayList<String>(datas.keySet());
            return datas.get(keys.get(index - 1));
        }
        List<String> keys = new ArrayList<String>(datas.keySet());
        return datas.get(keys.get(index));
    }

    @SuppressWarnings({"unchecked"})
    @Override
    public void setSelectedItem(Object anItem) {
        selected = (E) anItem;
    }

    @Override
    public Object getSelectedItem() {
        return selected;
    }

    protected void updateDatas(List<E> datas){
        fillDatas(datas);
        fireContentsChanged(this, 0, datas.size() - 1);
    }

    @Override
    public void putWikitty(WikittyServiceEvent event) {
        if (log.isDebugEnabled()) {
            log.debug("Receive wikitty service put event : " + event);
        }

        // map between id and extensions "name" (not extension ids)
        Map<String, Set<String>> idAndExtensions = event.getIdExtensions();
        if (idAndExtensions != null) {
            for (final String wikittyId : event.getIds()) {
                Set<String> wikittyExtensions = idAndExtensions.get(wikittyId);
                if (wikittyExtensions.contains(ext)) {

                    SwingUtilities.invokeLater(new Thread(){
                        @Override
                        public void run() {
                            E entity = VradiService.getWikittyProxy().restore(clazz, wikittyId);
                            if (entity != null) {
                                datas.put(entity.getWikittyId(), entity);
                            }
                            fireContentsChanged(this, 0, datas.size() - 1);
                        }
                    });
                }
            }
        }
    }

    @Override
    public void removeWikitty(WikittyServiceEvent event) {
        if (log.isDebugEnabled()) {
            log.debug("Receive wikitty service remove event : " + event);
        }

        // map between id and extensions "name" (not extension ids)
        Map<String, Set<String>> idAndExtensions = event.getIdExtensions();
        if (idAndExtensions != null) {
            for (final String wikittyId : event.getIds()) {
                Set<String> wikittyExtensions = idAndExtensions.get(wikittyId);
                if (wikittyExtensions.contains(ext)) {

                    SwingUtilities.invokeLater(new Thread(){
                        @Override
                        public void run() {
                            datas.remove(wikittyId);
                            fireContentsChanged(this, 0, datas.size() - 1);
                        }
                    });
                }
            }
        }
    }

    @Override
    public void clearWikitty(WikittyServiceEvent event) {
    }

    @Override
    public void putExtension(WikittyServiceEvent event) {
    }

    @Override
    public void removeExtension(WikittyServiceEvent event) {
    }

    @Override
    public void clearExtension(WikittyServiceEvent event) {
    }
}
