/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: AdminListSelectorHandler.java 1715 2010-10-27 19:21:28Z tchemit $
 * $HeadURL: svn+ssh://sletellier@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.3.1/vradi-swing/src/main/java/com/jurismarches/vradi/ui/admin/widget/AdminListSelectorHandler.java $
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.admin.widget;

import com.jurismarches.vradi.services.VradiService;
import jaxx.runtime.swing.ListSelectorHandler;
import jaxx.runtime.swing.ListSelectorUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.BusinessEntity;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyServiceEvent;
import org.nuiton.wikitty.WikittyServiceListener;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AdminListSelectorHandler<B extends BusinessEntity> extends ListSelectorHandler<B> implements WikittyServiceListener {

    /** Logger. */
    static private final Log log = LogFactory.getLog(AdminListSelectorHandler.class);

    protected List<String> idsInCombo = new ArrayList<String>();
    protected List<String> idsInList = new ArrayList<String>();

    protected AdminListSelectorHandler(ListSelectorUI<B> listSelector) {
        super(listSelector);
    }

    /**
     * Initialize the component.
     *
     * @param toCombo datas to set in combo
     * @param toList  datas to set in list
     */
    @Override
    public void init(java.util.List<B> toCombo, java.util.List<B> toList) {

        idsInCombo = extractId(toCombo);
        idsInList = extractId(toList);

        // register this handler on wikitty service
        VradiService.getWikittyService().addWikittyServiceListener(this, WikittyService.ServiceListenerType.ALL);
        
        super.init(toCombo, toList);
    }

    protected List<String> extractId(List<B> beans) {

        List<String> ids = new ArrayList<String>();
        if (beans != null) {
            for (BusinessEntity bean : beans) {
                ids.add(bean.getWikittyId());
            }
        }
        return ids;
    }

    @Override
    public void putWikitty(WikittyServiceEvent event) {

        if (log.isDebugEnabled()) {
            log.debug("Receive wikitty service put event : " + event);
        }

        // map between id and extensions "name" (not extension ids)
        Map<String, Set<String>> idAndExtensions = event.getIdExtensions();
        for (String wikittyId : event.getIds()) {
            Set<String> wikittyExtensions = idAndExtensions.get(wikittyId);
            if (log.isDebugEnabled()) {
                log.debug("Receive wikitty service put event : " + wikittyId);
            }
            putWikitty(wikittyId, wikittyExtensions);
        }

    }

    protected abstract void putWikitty(String wikittyId, Set<String> wikittyExtensions);

    @Override
    public void removeWikitty(WikittyServiceEvent event) {
        if (log.isDebugEnabled()) {
            log.debug("Receive wikitty service remove event : " + event);
        }

        for (String wikittyId : event.getIds()) {

            // If wikitty id it's not loaded, the event dont concerne this tree
            if (isLoadedId(wikittyId)) {
                removeWikitty(wikittyId);
            }
        }
    }

    public abstract void removeWikitty(String wikittyId);

    protected boolean isLoadedId(String wikittyId) {
        return idsInCombo.contains(wikittyId) || idsInList.contains(wikittyId);
    }

    @Override
    public void clearWikitty(WikittyServiceEvent wikittyServiceEvent) {
        // Never append
    }

    @Override
    public void putExtension(WikittyServiceEvent wikittyServiceEvent) {
    }

    @Override
    public void removeExtension(WikittyServiceEvent wikittyServiceEvent) {
    }

    @Override
    public void clearExtension(WikittyServiceEvent wikittyServiceEvent) {
    }
}
