/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: ThesaurusTreeTableModel.java 1715 2010-10-27 19:21:28Z tchemit $
 * $HeadURL: svn+ssh://sletellier@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.3.1/vradi-swing/src/main/java/com/jurismarches/vradi/ui/admin/models/ThesaurusTreeTableModel.java $
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.admin.models;

import com.jurismarches.vradi.entities.RootThesaurus;
import com.jurismarches.vradi.entities.Thesaurus;
import com.jurismarches.vradi.ui.admin.helpers.ThesaurusTreeTableHelper;
import com.jurismarches.vradi.ui.helpers.ThesaurusDataHelper;
import com.jurismarches.vradi.ui.tree.VradiTreeTableNode;
import jaxx.runtime.swing.nav.treetable.NavTreeTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import static org.nuiton.i18n.I18n._;

/**
 * @author sletellier
 */
public class ThesaurusTreeTableModel extends NavTreeTableModel.MyDefaultTreeTableModel {

    private static final Log log = LogFactory.getLog(ThesaurusTreeTableModel.class);

    @Override
    public Object getValueAt(Object value, int column) {
        Object result;
        VradiTreeTableNode node = (VradiTreeTableNode)value;

        RootThesaurus rootThesaurus = ThesaurusTreeTableHelper.getRootThesaurus(node);
        if (rootThesaurus != null) {
            result = getValueForRootThesaurus(rootThesaurus, column);
        } else {
            Thesaurus thesaurus = ThesaurusTreeTableHelper.getThesaurus(node);
            result = getValueForThesaurus(thesaurus, column);
        }

        return result;
    }


    @Override
    public String[] getColumnsNames() {
        return new String[]{_("vradi.thesaurus.colomns.name"),
            _("vradi.thesaurus.colomns.nbForm"),
            _("vradi.thesaurus.colomns.tags")};
    }

    @Override
    public boolean isCellEditable(Object node, int column) {
        return false;
    }

    protected Object getValueForRootThesaurus(RootThesaurus rootThesaurus, int column) {
        if (rootThesaurus == null) {
            return "not found";
        }

        if (column == 0) {
             return rootThesaurus;
        }
        return "";
    }

    protected Object getValueForThesaurus(Thesaurus thesaurus, int column) {
        if (thesaurus == null) {
            return "not found";
        }

        Object result = null;
        switch (column) {
            case 0:
            result = thesaurus;
            break;
        case 1:
            result = String.valueOf(ThesaurusDataHelper.getNbFormsForThesaurus(thesaurus));
            break;
        case 2:
            result = ThesaurusDataHelper.getTagsAsString(thesaurus);
            break;
        }
        return result;
    }
}
