/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: StreamNodeLoadors.java 1715 2010-10-27 19:21:28Z tchemit $
 * $HeadURL: svn+ssh://sletellier@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.3.1/vradi-swing/src/main/java/com/jurismarches/vradi/ui/admin/loadors/StreamNodeLoadors.java $
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.admin.loadors;

import java.util.Collections;
import java.util.List;

import jaxx.runtime.swing.nav.NavDataProvider;

import com.jurismarches.vradi.entities.XmlStream;
import com.jurismarches.vradi.services.VradiDataService;
import com.jurismarches.vradi.ui.helpers.VradiComparators;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;
import com.jurismarches.vradi.ui.tree.loadors.AbstractVradiNodeLoadors;

/**
 * @author letellier
 */
public class StreamNodeLoadors extends AbstractVradiNodeLoadors<XmlStream> {

    /** serialVersionUID. */
    private static final long serialVersionUID = -7828183287422107044L;

    public StreamNodeLoadors() {
        super(XmlStream.class);
    }

    @Override
    public List<String> getData(Class<?> parentClass, String parentId, NavDataProvider dataProvider) throws Exception {
        
        // ne recupere pas seulement les id pour les mettre en cache
        VradiDataService dataService = getDataService(dataProvider);
        
        List<XmlStream> streamList = dataService.findAllXmlStreams();
        Collections.sort(streamList, VradiComparators.XML_STREAM_COMPARATOR);

        return extractIds(streamList);
    }

    @Override
    public VradiTreeNode createNode(String id, NavDataProvider dataProvider) {
        return createVradiNode(id);
    }
}