package org.sharengo.wikitty.search;

// Start of user code for import

import java.io.Serializable;
import java.util.List;

// End of user code  for import

/**
 * <!-- Start of user code for And -->
 * 
 * <p>
 * And operator is used to build conjunctive restriction for request on content.
 * It take at least 2 args. <br>
 * <br>
 * For example, use:
 * <ul>
 * <li>RestrictionHelper.and( restriction1, restriction2 )</li>
 * <li>RestrictionHelper.and( restriction1, restriction2, restriction3 )</li>
 * <li>RestrictionHelper.and(
 * my_JavaUtilList_Of_Restriction_Witch_Size_Is_Upper_Than2 )</li>
 * </ul>
 * </p>
 * 
 * <!-- End of user code for And -->
 */
public class And extends Restriction implements Serializable {

	// serialVersionUID is used for serialization.
	private static final long serialVersionUID = 1L;

	protected List<Restriction> restrictions;

	/**
	 * Default constructor
	 */
	public And() {
		super();
	}

	/**
	 * Constructor with all parameters initialized
	 * 
	 * @param restrictions
	 */
	public And(List<Restriction> restrictions) {
		this.restrictions = restrictions;
	}

	/**
	 * Return restrictions
	 * 
	 * @return
	 */
	public List<Restriction> getRestrictions() {
		return restrictions;
	}

	/**
	 * Set a value to parameter restrictions.
	 * 
	 * @param restrictions
	 */
	public void setRestrictions(List<Restriction> restrictions) {
		this.restrictions = restrictions;
	}

	/**
	 * Equality test based attributes values
	 * 
	 * @param value
	 *            Value to compare
	 */
	public boolean equals(Object other) {
		if (this == other) {
			return true;
		}
		if (!(other instanceof And)) {
			return false;
		}

		final And and = (And) other;

		if ((restrictions == null && and.getRestrictions() != null)
				|| (restrictions != null && !restrictions.equals(and
						.getRestrictions())))
			return false;

		return true;
	}

}