/* *##%
 * Copyright (c) 2009 poussin. All rights reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *##%*/

package org.sharengo.wikitty;

import java.util.Collection;
import java.util.List;

/**
 *
 * @author poussin
 * @version $Revision$
 *
 * Last update: $Date$
 * by : $Author$
 */
public interface WikittyExtensionStorage {

    /**
     * Prepare command's List needed to update the storage
     * @param allExtensions
     * @param update
     * @return
     */
    public List<Command> prepare(WikittyTransaction transaction,
            Collection<WikittyExtension> allExtensions) throws WikittyException;

    /**
     * Commit all modification command passed in argument
     * @param extensionStorageCommandList
     * @return information usefull for client side update data
     */
    public UpdateResponse commit(WikittyTransaction transaction,
            List<Command> extensionStorageCommandList);

    /**
     * Return true if id exists in storage
     * @param id
     * @return
     */
    public boolean exists(String id);

    /**
     * Return all extension ids
     * @return
     */
    public List<String> getAllExtensionIds();

    /**
     * Return all extensions (ex: "extName[version])")
     * @param lastVersion if true, returns only the last version of each extension
     * @return
     */
    public List<WikittyExtension> getAllExtensions(boolean lastVersion);

    /**
     * return last version available for specified extension name
     * @param extName name of extension
     * @return last version availble for this version, or null if extension
     * doesn't exist
     */
    public String getLastVersion(String extName);

    /**
     * Restore one extension from storage, if not found an exception is throw
     * @param name extension name to restore
     * @param version extension version to restore
     * @return
     */
    WikittyExtension restore(String name, String version)
            throws WikittyException;

    /**
     * Command update
     */
    static public interface Command {}


}
