/* *##%
 * Copyright (c) 2009 Sharengo, Guillaume Dufrene, Benjamin POUSSIN.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *##%*/

package org.sharengo.wikitty;

import java.io.Serializable;
import java.util.Collection;

/**
 * Used as parent interface to all Business class
 *
 * @author poussin
 * @version $Revision$
 *
 * Last update: $Date$
 * by : $Author$
 */
public interface BusinessEntity extends Serializable, Cloneable {

    public String getWikittyId();
    public String getWikittyVersion();
    /**
     * Only framework can use this method
     * @param version
     */
    public void setWikittyVersion(String version);

    /**
     * Return list of all extensions for this object
     * @return
     */
    public void addExtension(WikittyExtension extension);

    /**
     * Return list of all extensions for this object
     * @return
     */
    public Collection<WikittyExtension> getExtensions();

    /**
     * Return list of all extension names for this object
     * @return
     */
    public Collection<String> getExtensionNames();

    /**
     * Return list of all field for this object
     * @param ext
     * @return
     */
    public Collection<String> getExtensionFields(String ext);

    /**
     * Return field value for the specifique extension and field
     * @param ext
     * @param fieldName
     * @return
     */
    public Object getField(String ext, String fieldName);

    /**
     * set field value for the specifique extension and field.
     * This method don't check the type of value for this field.
     * @param ext
     * @param fieldName
     * @param value 
     * @return
     */
    public void setField(String ext, String fieldName, Object value);

    /**
     * Return the field type
     * @param ext
     * @param fieldName
     * @return
     */
    public FieldType getFieldType(String ext, String fieldName);
}
