/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.wizard;

import java.awt.Component;
import java.beans.IndexedPropertyChangeEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Array;
import java.util.List;
import javax.swing.JTabbedPane;
import jaxx.runtime.swing.wizard.WizardModel;
import jaxx.runtime.swing.wizard.WizardOperationState;
import jaxx.runtime.swing.wizard.WizardStep;
import jaxx.runtime.swing.wizard.WizardStepUI;
import jaxx.runtime.swing.wizard.WizardUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class WizardUtil {
    private static Log log = LogFactory.getLog(WizardUI.class);

    protected WizardUtil() {
    }

    public static boolean acceptStates(WizardOperationState state, WizardOperationState ... accepted) {
        for (WizardOperationState s : accepted) {
            if (s != state) continue;
            return true;
        }
        return false;
    }

    public static boolean rejectStates(WizardOperationState state, WizardOperationState ... rejected) {
        for (WizardOperationState s : rejected) {
            if (s != state) continue;
            return false;
        }
        return true;
    }

    public static void addDebugLogListener(final Log log, WizardModel<?> model) {
        if (log.isDebugEnabled()) {
            model.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    log.debug((Object)(evt.getPropertyName() + " <" + evt.getOldValue() + " - " + evt.getNewValue() + ">"));
                }
            });
        }
    }

    public static void addTraceLogListener(final Log log, WizardModel<?> model) {
        if (log.isTraceEnabled()) {
            model.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    log.trace((Object)(evt.getPropertyName() + " <" + evt.getOldValue() + " - " + evt.getNewValue() + ">"));
                }
            });
        }
    }

    public static <E extends WizardStep, M extends WizardModel<E>> void installWizardUIListeners(final WizardUI<E, M> ui) {
        ((WizardModel)ui.getModel()).addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if ("wasStarted".equals(propertyName)) {
                    ui.onWasStarted();
                    return;
                }
                if ("steps".equals(propertyName)) {
                    List steps = (List)evt.getNewValue();
                    ui.onStepsChanged(steps.toArray((WizardStep[])Array.newInstance(((WizardModel)ui.getModel()).stepClass, steps.size())));
                    return;
                }
                if ("step".equals(propertyName)) {
                    ui.onStepChanged((WizardStep)evt.getNewValue());
                    return;
                }
                if ("modelState".equals(propertyName)) {
                    ui.onModelStateChanged((WizardOperationState)((Object)evt.getNewValue()));
                    return;
                }
                if ("operationState".equals(propertyName)) {
                    IndexedPropertyChangeEvent e = (IndexedPropertyChangeEvent)evt;
                    int stepIndex = e.getIndex();
                    WizardStep step = (WizardStep)((WizardModel)ui.getModel()).getSteps().get(stepIndex);
                    ui.onOperationStateChanged(step, (WizardOperationState)((Object)evt.getNewValue()));
                    return;
                }
            }
        });
    }

    public static <E extends WizardStep, M extends WizardModel<E>> void addTabsDisplayUntilStepListener(final WizardUI<E, M> ui) {
        ((WizardModel)ui.getModel()).addPropertyChangeListener("step", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                WizardModel model = (WizardModel)evt.getSource();
                WizardStep oldStep = (WizardStep)evt.getOldValue();
                WizardStep newStep = (WizardStep)evt.getNewValue();
                log.debug((Object)("step has changed <old:" + oldStep + ", new:" + newStep + ">"));
                int oldStepIndex = oldStep == null ? -1 : model.getStepIndex(oldStep);
                int newStepIndex = model.getStepIndex(newStep);
                JTabbedPane tabs = ui.getTabs();
                if (oldStepIndex + 1 == newStepIndex) {
                    WizardStepUI c = ui.getStepUI(newStep);
                    String title = I18n._((String)newStep.getLabel());
                    String tip = I18n._((String)newStep.getDescription());
                    tabs.addTab(title, null, (Component)((Object)c), tip);
                    int index = tabs.indexOfComponent((Component)((Object)c));
                    if (index > -1) {
                        tabs.setSelectedIndex(index);
                    }
                } else if (oldStepIndex > newStepIndex) {
                    int index = newStepIndex + 1;
                    while (tabs.getTabCount() > index) {
                        log.trace((Object)("remove tab : " + index));
                        tabs.remove(index);
                    }
                } else {
                    throw new IllegalStateException("can not go from " + oldStep + " to " + newStep);
                }
            }
        });
    }
}

