/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.renderer;

import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.nuiton.i18n.I18n;

public class I18nTableCellRenderer
implements TableCellRenderer {
    protected final String[] keys;
    protected final String[] tips;
    protected TableCellRenderer delegate;

    public I18nTableCellRenderer(TableCellRenderer delegate, String ... keysAndTips) {
        this.delegate = delegate;
        if (keysAndTips.length == 0) {
            throw new IllegalArgumentException("can not have empty keysAndTips parameters (means no column ?)");
        }
        if (keysAndTips.length % 2 == 1) {
            throw new IllegalArgumentException("must have some couple (text,tooltTipText), but had a even number of data in keysAndTips parameter");
        }
        int size = keysAndTips.length / 2;
        this.keys = new String[size];
        this.tips = new String[size];
        for (int i = 0; i < size; ++i) {
            this.keys[i] = keysAndTips[2 * i];
            this.tips[i] = keysAndTips[2 * i + 1];
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasfocus, int row, int column) {
        if (column > this.keys.length) {
            throw new IndexOutOfBoundsException("colum can not be greater than " + this.keys.length);
        }
        TableColumn col = table.getColumn(table.getColumnName(column));
        int index = col.getModelIndex();
        value = I18n._((String)this.keys[index]);
        JComponent rendererComponent = (JComponent)this.delegate.getTableCellRendererComponent(table, value, isSelected, hasfocus, row, column);
        rendererComponent.setToolTipText(I18n._((String)this.tips[index]));
        return rendererComponent;
    }

    public String[] getKeys() {
        return this.keys;
    }

    public String[] getTips() {
        return this.tips;
    }
}

