/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.context;

import java.io.Serializable;
import java.util.List;
import jaxx.runtime.JAXXContext;

public class JAXXContextEntryDef<O>
implements Serializable {
    protected String name;
    protected Class<O> klass;
    private static final long serialVersionUID = 1L;

    public String getName() {
        return this.name;
    }

    public Class<O> getKlass() {
        return this.klass;
    }

    public O getContextValue(JAXXContext context) {
        return context.getContextValue(this.klass, this.name);
    }

    public void removeContextValue(JAXXContext context) {
        context.removeContextValue(this.klass, this.name);
    }

    public void setContextValue(JAXXContext context, O value) {
        context.setContextValue(value, this.name);
    }

    public String toString() {
        return super.toString() + "<" + this.klass + ":" + this.name + ">";
    }

    public JAXXContextEntryDef(Class<O> klass) {
        this(null, klass);
    }

    public JAXXContextEntryDef(String name, Class<O> klass) {
        if (klass == null) {
            throw new IllegalArgumentException("class can not be null");
        }
        this.name = name;
        if (List.class.isAssignableFrom(klass)) {
            klass = List.class;
        }
        this.klass = klass;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JAXXContextEntryDef)) {
            return false;
        }
        JAXXContextEntryDef that = (JAXXContextEntryDef)o;
        return this.klass.equals(that.klass) && !(this.name == null ? that.name != null : !this.name.equals(that.name));
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        return 31 * result + this.klass.hashCode();
    }

    public boolean accept(Class<?> klass, String name) {
        if (klass == Object.class && this.klass != Object.class) {
            return this.name != null && name != null && this.name.equals(name);
        }
        return klass.isAssignableFrom(this.klass) && (this.name == null && name == null || this.name != null && name != null && this.name.equals(name));
    }

    public boolean accept2(Class<?> klass, String name) {
        return (klass != Object.class || this.klass == Object.class) && this.klass.isAssignableFrom(klass) && (this.name == null && name == null || this.name != null && name != null && this.name.equals(name));
    }
}

