/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.services.ServiceHelper;
import com.jurismarches.vradi.services.dto.VradiThesaurusDTO;
import com.jurismarches.vradi.ui.OfferEditHandler;
import com.jurismarches.vradi.ui.OfferEditUI;
import com.jurismarches.vradi.ui.OfferListHandler;
import com.jurismarches.vradi.ui.OfferListUI;
import com.jurismarches.vradi.ui.ThesaurusTreeHelper;
import com.jurismarches.vradi.ui.ThesaurusUI;
import com.jurismarches.vradi.ui.UIHelper;
import com.jurismarches.vradi.ui.search.SearchHandler;
import java.awt.Component;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.tree.TreePath;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.swing.navigation.NavigationTreeNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sharengo.exceptions.TechnicalException;
import org.sharengo.wikitty.TreeNode;

public class ThesaurusHandler {
    private static Log log = LogFactory.getLog(ThesaurusHandler.class);

    public ThesaurusUI initUI(JAXXContext rootContext, VradiThesaurusDTO rootThesaurus, Form bean) {
        return this.initUI(rootContext, rootThesaurus, bean, false);
    }

    public ThesaurusUI initUI(JAXXContext rootContext, VradiThesaurusDTO rootThesaurus, Form bean, boolean deletable) {
        JAXXInitialContext context = new JAXXInitialContext().add((Object)rootContext);
        context.add((Object)this);
        ThesaurusUI ui = new ThesaurusUI((JAXXContext)context, rootThesaurus);
        ui.setDeletable(deletable);
        ui.setBean(bean);
        return ui;
    }

    ThesaurusUI getUI(JAXXContext context) {
        if (context instanceof ThesaurusUI) {
            return (ThesaurusUI)context;
        }
        return null;
    }

    protected OfferEditUI getEditUI(JAXXContext context) {
        return UIHelper.getHandler(context, OfferEditHandler.class).getUI(context);
    }

    protected OfferListUI getListUI(JAXXContext context) {
        return UIHelper.getHandler(context, OfferListHandler.class).getUI(context);
    }

    public static VradiThesaurusDTO getRootThesaurus() {
        try {
            TreeNode rootTreeNode = ServiceHelper.getVradiStorageService().getRootThesaurus();
            VradiThesaurusDTO dto = new VradiThesaurusDTO();
            dto.fromWikitty(rootTreeNode);
            return dto;
        }
        catch (TechnicalException ex) {
            log.error((Object)("Cant get thesaurus caused by : " + (Object)((Object)ex)));
            ErrorDialogUI.showError((Exception)((Object)ex));
            return null;
        }
    }

    protected NavigationTreeNode getParentNode(ThesaurusTreeHelper helper, TreePath path) {
        if (path == null) {
            return helper.getRootNode();
        }
        return (NavigationTreeNode)path.getLastPathComponent();
    }

    public void addCriteria(JAXXContext context, ThesaurusTreeHelper helper, TreePath path) {
        OfferListUI ui = this.getListUI(context);
        NavigationTreeNode parentNode = this.getParentNode(helper, path);
        VradiThesaurusDTO thesaurus = (VradiThesaurusDTO)parentNode.getBean(context);
        UIHelper.getHandler(context, SearchHandler.class).addAndPersistCriteria(context, thesaurus.getBean());
        ui.validate();
    }

    public void addThesaurus(JAXXContext context, ThesaurusTreeHelper helper, TreePath path) {
        if (path != null) {
            NavigationTreeNode parentNode = (NavigationTreeNode)path.getLastPathComponent();
            helper.getBuilder().removeNodeFromParent(context, parentNode);
            VradiThesaurusDTO thesaurusParent = (VradiThesaurusDTO)parentNode.getBean(context);
            OfferEditUI ui = this.getEditUI(context);
            this.addThesaurus(context, thesaurusParent, true, true);
        }
    }

    public void refreshAllThesaurus(JAXXContext context) {
        List editUIs = (List)VradiContext.OFFERT_EDIT_UI_ENTRY_DEF.getContextValue((JAXXContext)VradiContext.get());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Refresh ui : " + (editUIs == null ? "is null" : Integer.valueOf(editUIs.size()))));
        }
        if (editUIs != null) {
            for (OfferEditUI editUI : editUIs) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Refresh ui : " + editUI.getData().getName()));
                }
                OfferEditHandler offerEditHandler = UIHelper.getHandler(context, OfferEditHandler.class);
                offerEditHandler.initThesaurus(context, editUI);
                editUI.validate();
            }
        }
    }

    public void addThesaurus(JAXXContext context, VradiThesaurusDTO root, boolean deletable, boolean save) {
        if (root != null) {
            ThesaurusUI thesaurusChildUI = new ThesaurusUI(context, root);
            thesaurusChildUI.setDeletable(deletable);
            this.getThesaurusContainer(context).add((Component)((Object)thesaurusChildUI));
            if (save) {
                VradiHelper.addVradiListThesaurus(root.getBean());
            }
            this.getUI(context).validate();
        }
    }

    public void addColumn(JAXXContext context, ThesaurusTreeHelper helper, TreePath path) {
        NavigationTreeNode node = this.getParentNode(helper, path);
        VradiThesaurusDTO thesaurus = (VradiThesaurusDTO)node.getBean(context);
        VradiHelper.addVradiListColumns(thesaurus.getBean());
        this.getListUI(context).updateTableModel();
    }

    public void closeThesaurus(ThesaurusUI thesaurus) {
        this.getThesaurusContainer((JAXXContext)thesaurus).remove((Component)((Object)thesaurus));
        VradiThesaurusDTO selected = (VradiThesaurusDTO)thesaurus.helper.getRootNode().getBean();
        VradiHelper.removeVradiListThesaurus(selected.getBean());
        this.refreshAllThesaurus((JAXXContext)thesaurus);
    }

    protected JPanel getThesaurusContainer(JAXXContext context) {
        return this.getUI(context).getParentContainer(OfferEditUI.class).getThesaurus();
    }

    public String selectPath(JAXXContext context, VradiThesaurusDTO bean) {
        return null;
    }
}

