/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import org.h2.message.Message;
import org.h2.message.TraceSystem;
import org.h2.util.FileUtils;
import org.h2.util.MathUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortedProperties
extends Properties {
    private static final long serialVersionUID = 5657650728102821923L;

    @Override
    public synchronized Enumeration<Object> keys() {
        Vector<Object> vector = new Vector<Object>(this.keySet());
        Collections.sort(vector, new Comparator<Object>(){

            @Override
            public int compare(Object object, Object object2) {
                return object.toString().compareTo(object2.toString());
            }
        });
        return vector.elements();
    }

    public static boolean getBooleanProperty(Properties properties, String string, boolean bl) {
        String string2 = properties.getProperty(string, "" + bl);
        try {
            return Boolean.valueOf(string2);
        }
        catch (Exception exception) {
            TraceSystem.traceThrowable(exception);
            return bl;
        }
    }

    public static int getIntProperty(Properties properties, String string, int n) {
        String string2 = properties.getProperty(string, "" + n);
        try {
            return MathUtils.decodeInt(string2);
        }
        catch (Exception exception) {
            TraceSystem.traceThrowable(exception);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized SortedProperties loadProperties(String string) throws IOException {
        SortedProperties sortedProperties = new SortedProperties();
        if (FileUtils.exists(string)) {
            InputStream inputStream = null;
            try {
                inputStream = FileUtils.openFileInputStream(string);
                sortedProperties.load(inputStream);
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        return sortedProperties;
    }

    public synchronized void store(String string) throws IOException {
        String string2;
        OutputStreamWriter outputStreamWriter;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.store(byteArrayOutputStream, null);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)byteArrayInputStream, "ISO8859-1");
        LineNumberReader lineNumberReader = new LineNumberReader(inputStreamReader);
        try {
            outputStreamWriter = new OutputStreamWriter(FileUtils.openFileOutputStream(string, false));
        }
        catch (SQLException sQLException) {
            throw Message.convertToIOException(sQLException);
        }
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(outputStreamWriter));
        while ((string2 = lineNumberReader.readLine()) != null) {
            if (string2.startsWith("#")) continue;
            printWriter.println(string2);
        }
        printWriter.close();
    }
}

