/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.services;

import com.jurismarches.vradi.entities.Client;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.FormImpl;
import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.entities.ModificationTag;
import com.jurismarches.vradi.entities.QueryMaker;
import com.jurismarches.vradi.entities.Sending;
import com.jurismarches.vradi.entities.SendingImpl;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.entities.VradiUser;
import com.jurismarches.vradi.entities.XmlFieldBinding;
import com.jurismarches.vradi.entities.XmlStream;
import com.jurismarches.vradi.services.VradiStorageService;
import com.jurismarches.vradi.services.dto.VradiFormPageDTO;
import com.jurismarches.vradi.services.dto.VradiSendingDTO;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.math.BigDecimal;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;
import org.nuiton.util.MD5;
import org.sharengo.exceptions.TechnicalException;
import org.sharengo.wikitty.BusinessEntity;
import org.sharengo.wikitty.Criteria;
import org.sharengo.wikitty.FieldType;
import org.sharengo.wikitty.PagedResult;
import org.sharengo.wikitty.TreeNode;
import org.sharengo.wikitty.TreeNodeImpl;
import org.sharengo.wikitty.UpdateResponse;
import org.sharengo.wikitty.WikittyExtension;
import org.sharengo.wikitty.WikittyProxy;
import org.sharengo.wikitty.WikittyService;
import org.sharengo.wikitty.WikittyUtil;
import org.sharengo.wikitty.jdbc.WikittyServiceJDBC;
import org.sharengo.wikitty.search.Element;
import org.sharengo.wikitty.search.Search;

public class VradiStorageServiceImpl
implements VradiStorageService {
    private static final Log log = LogFactory.getLog(VradiStorageServiceImpl.class);
    protected WikittyProxy proxy;
    protected static final String fieldPattern = "[\\p{Graph}\\p{Blank}\\p{L}\\p{Lu}&&[^\\(\\)(AND)(OR)]]+:";
    protected static final String valuePattern = "[\\p{Graph}\\p{Blank}\\p{L}\\p{Lu}&&[^\\(\\)]]+";
    protected static final String notPattern = "(NOT\\p{Blank})?";
    protected static final Pattern queryPattern = Pattern.compile("([\\p{Graph}\\p{Blank}\\p{L}\\p{Lu}&&[^\\(\\)(AND)(OR)]]+:)?(\\((NOT\\p{Blank})?[\\p{Graph}\\p{Blank}\\p{L}\\p{Lu}&&[^\\(\\)]]+(\\p{Blank}((AND)|(OR))\\p{Blank}(NOT\\p{Blank})?[\\p{Graph}\\p{Blank}\\p{L}\\p{Lu}&&[^\\(\\)]]+)*\\))(\\p{Blank}((AND)|(OR))\\p{Blank}([\\p{Graph}\\p{Blank}\\p{L}\\p{Lu}&&[^\\(\\)(AND)(OR)]]+:)?(\\((NOT\\p{Blank})?[\\p{Graph}\\p{Blank}\\p{L}\\p{Lu}&&[^\\(\\)]]+(\\p{Blank}((AND)|(OR))\\p{Blank}(NOT\\p{Blank})?[\\p{Graph}\\p{Blank}\\p{L}\\p{Lu}&&[^\\(\\)]]+)*\\)))*?");
    public static final String ROOT_THESAURUS_NAME = "Thesaurus";
    protected static final String channel = "channel";
    protected static final String entry = "entry";
    protected static final String feed = "feed";
    protected static final String item = "item";
    protected static final String rdf = "rdf";
    public static final SimpleDateFormat RSS_DATE_FORMAT = new SimpleDateFormat("E, d MMM yyyy HH:mm:ss Z", Locale.US);
    public static final int DEFAULT_SENDING_STATUS = 0;
    public static final String DEFAULT_SENDING_PARAGRAPH = "null";
    protected String vradiDataDirName;
    protected List<String> queriesInTheDB;
    protected Map<Class, Map> cacheMap;

    public VradiStorageServiceImpl() {
        block5: {
            this.vradiDataDirName = System.getProperty("user.home") + File.separator + ".vradi/vradi-0.0.3";
            this.queriesInTheDB = null;
            this.cacheMap = new HashMap<Class, Map>();
            this.proxy = new WikittyProxy();
            try {
                File vradiDataDir = new File(this.vradiDataDirName);
                vradiDataDir.mkdirs();
                File userSolrConfig = new File(this.vradiDataDirName, "solrconfig.xml");
                if (!userSolrConfig.exists()) {
                    InputStream solrConfig = this.getClass().getClassLoader().getResourceAsStream("solrconfig.xml");
                    FileWriter fw = new FileWriter(userSolrConfig);
                    SAXBuilder sxb = new SAXBuilder();
                    Document document = sxb.build(solrConfig);
                    org.jdom.Element racine = document.getRootElement();
                    racine.getChild("dataDir").setText("${solr.data.dir:" + this.vradiDataDirName + "/solr/data}");
                    XMLOutputter outputter = new XMLOutputter("    ", true);
                    outputter.output(document, (Writer)fw);
                    fw.close();
                }
            }
            catch (JDOMException eee) {
                if (log.isErrorEnabled()) {
                    log.error((Object)eee);
                }
            }
            catch (IOException eee) {
                if (!log.isErrorEnabled()) break block5;
                log.error((Object)eee);
            }
        }
        this.proxy.setWikittyService((WikittyService)new WikittyServiceJDBC(this.vradiDataDirName));
    }

    protected Class initCacheMap(Class clazz) throws TechnicalException {
        if (User.class.isAssignableFrom(clazz)) {
            this.getAllUsers();
            return User.class;
        }
        if (Client.class.isAssignableFrom(clazz)) {
            this.getAllClients();
            return Client.class;
        }
        if (Group.class.isAssignableFrom(clazz)) {
            this.getAllGroups();
            return Group.class;
        }
        if (XmlStream.class.isAssignableFrom(clazz)) {
            this.getAllXmlStreams();
            return XmlStream.class;
        }
        if (TreeNode.class.isAssignableFrom(clazz)) {
            this.getAllThesaurus();
            return TreeNode.class;
        }
        return null;
    }

    @Override
    public BusinessEntity getEntity(String id, Class clazz) throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getEntity");
        }
        this.initCacheMap(clazz);
        if (id != null) {
            return (BusinessEntity)this.cacheMap.get(clazz).get(id);
        }
        return null;
    }

    protected List<BusinessEntity> getAllEntities(Class clazz, String ext) {
        if (this.cacheMap.get(clazz) == null) {
            Criteria criteria = Search.query().eq(Element.ELT_EXTENSION, ext).criteria();
            List entities = this.proxy.findAllByCriteria(clazz, criteria).getAll();
            HashMap<String, BusinessEntity> entitiesMap = new HashMap<String, BusinessEntity>();
            for (BusinessEntity entity : entities) {
                log.debug((Object)(entity.getWikittyId() + " : " + entity.getExtensionNames()));
                entitiesMap.put(entity.getWikittyId(), entity);
            }
            this.cacheMap.put(clazz, entitiesMap);
            return new ArrayList<BusinessEntity>(entities);
        }
        log.debug((Object)(clazz + " loaded"));
        return new ArrayList<BusinessEntity>(this.cacheMap.get(clazz).values());
    }

    @Override
    public BusinessEntity updateEntity(BusinessEntity entity) throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"updateEntity");
        }
        if (entity != null) {
            Set queries;
            if (QueryMaker.class.isAssignableFrom(entity.getClass()) && this.queriesInTheDB != null && (queries = ((QueryMaker)entity).getQueries()) != null) {
                for (String query : queries) {
                    if (this.queriesInTheDB.contains(query)) continue;
                    this.queriesInTheDB.add(query);
                }
            }
            entity.setWikittyVersion(WikittyUtil.incrementMajorRevision((String)entity.getWikittyVersion()));
            BusinessEntity result = this.proxy.store(entity);
            Class clazz = this.initCacheMap(entity.getClass());
            log.debug((Object)("update entity : " + result.getWikittyId()));
            if (TreeNode.class.isAssignableFrom(entity.getClass())) {
                log.debug((Object)((TreeNode)entity).getChildren());
            }
            this.cacheMap.get(clazz).put(result.getWikittyId(), result);
            return result;
        }
        return null;
    }

    @Override
    public void deleteEntity(BusinessEntity entity) throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"deleteEntity");
        }
        if (entity != null) {
            this.proxy.delete(entity.getWikittyId());
            Class clazz = this.initCacheMap(entity.getClass());
            this.cacheMap.get(clazz).remove(entity);
        }
    }

    @Override
    public User getUser(String userId) throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getUser");
        }
        return (User)this.getEntity(userId, User.class);
    }

    @Override
    public Client getClient(String clientId) throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getClient");
        }
        return (Client)this.getEntity(clientId, Client.class);
    }

    @Override
    public Group getGroup(String groupId) throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getGroup");
        }
        return (Group)this.getEntity(groupId, Group.class);
    }

    @Override
    public List<User> getGroupUsers(String groupId) throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getGroupUsers");
        }
        ArrayList<User> result = new ArrayList<User>();
        Group group = this.getGroup(groupId);
        if (group != null) {
            for (String userId : group.getUser()) {
                User user = this.getUser(userId);
                result.add(user);
            }
        }
        return result;
    }

    @Override
    public List<User> getClientUsers(String clientId) throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getClientUsers");
        }
        ArrayList<User> result = new ArrayList<User>();
        Client client = this.getClient(clientId);
        if (client != null && client.getUser() != null) {
            for (String userId : client.getUser()) {
                User user = this.getUser(userId);
                result.add(user);
            }
        }
        return result;
    }

    @Override
    public List<Client> getGroupClients(String groupId) throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getGroupClients");
        }
        ArrayList<Client> result = new ArrayList<Client>();
        Group group = this.getGroup(groupId);
        if (group != null && group.getClient() != null) {
            for (String clientId : group.getClient()) {
                Client client = this.getClient(clientId);
                result.add(client);
            }
        }
        return result;
    }

    @Override
    public Client getClientByUserId(String userId) throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getClientByUserId");
        }
        User user = this.getUser(userId);
        String clientId = user.getClient();
        return this.getClient(clientId);
    }

    @Override
    public List<Group> getGroupsByUserId(String userId) throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getGroupsByUserId");
        }
        User user = this.getUser(userId);
        ArrayList groupIds = new ArrayList(user.getGroup());
        ArrayList<Group> result = new ArrayList<Group>();
        for (String groupId : groupIds) {
            result.add(this.getGroup(groupId));
        }
        return result;
    }

    @Override
    public List<Group> getGroupsByClientId(String clientId) throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getGroupsByClientId");
        }
        Client client = this.getClient(clientId);
        ArrayList groupIds = new ArrayList(client.getGroup());
        ArrayList<Group> result = new ArrayList<Group>();
        for (String groupId : groupIds) {
            result.add(this.getGroup(groupId));
        }
        return result;
    }

    @Override
    public List<Client> getAllClients() throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getAllClients");
        }
        ArrayList<Client> result = new ArrayList<Client>();
        List<BusinessEntity> entities = this.getAllEntities(Client.class, "Client");
        for (BusinessEntity entity : entities) {
            result.add((Client)entity);
        }
        return result;
    }

    @Override
    public List<User> getAllUsers() throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getAllUsers");
        }
        ArrayList<User> result = new ArrayList<User>();
        List<BusinessEntity> entities = this.getAllEntities(User.class, "User");
        for (BusinessEntity entity : entities) {
            result.add((User)entity);
        }
        return result;
    }

    @Override
    public List<Group> getAllGroups() throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getAllGroups");
        }
        ArrayList<Group> result = new ArrayList<Group>();
        List<BusinessEntity> entities = this.getAllEntities(Group.class, "Group");
        for (BusinessEntity entity : entities) {
            result.add((Group)entity);
        }
        return result;
    }

    @Override
    public Form updateForm(Form form) throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"updateForm");
        }
        if (form != null) {
            Set thesaurus;
            if (form.getDatePub() == null) {
                form.setDatePub(new Date());
            }
            if ((thesaurus = form.getThesaurus()) != null) {
                for (String thesaurusId : thesaurus) {
                    TreeNode node = this.getThesaurus(thesaurusId);
                    if (node.getChildren() != null && node.getChildren().contains(form.getWikittyId())) continue;
                    node.addChildren(form.getWikittyId());
                    this.updateEntity((BusinessEntity)node);
                }
            }
            form.setWikittyVersion(WikittyUtil.incrementMajorRevision((String)form.getWikittyVersion()));
            return (Form)this.proxy.store((BusinessEntity)form);
        }
        return null;
    }

    @Override
    public List<Form> updateForms(List<Form> forms) throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"updateForm");
        }
        ArrayList<TreeNode> thesaurusList = new ArrayList<TreeNode>();
        for (Form form : forms) {
            Set thesaurus;
            if (form == null) continue;
            if (form.getDatePub() == null) {
                form.setDatePub(new Date());
            }
            if ((thesaurus = form.getThesaurus()) != null) {
                for (String thesaurusId : thesaurus) {
                    TreeNode node = this.getThesaurus(thesaurusId);
                    if (node.getChildren() != null && node.getChildren().contains(form.getWikittyId())) continue;
                    node.addChildren(form.getWikittyId());
                    if (thesaurusList.contains(node)) continue;
                    thesaurusList.add(node);
                }
            }
            form.setWikittyVersion(WikittyUtil.incrementMajorRevision((String)form.getWikittyVersion()));
        }
        this.proxy.store(thesaurusList);
        List result = this.proxy.store(forms);
        return result;
    }

    @Override
    public void deleteForm(String formId) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"deleteForm");
        }
        if (formId != null) {
            this.proxy.delete(formId);
        }
    }

    @Override
    public void findForms(String query, VradiFormPageDTO formPageDTO) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"findForms");
        }
        this.findForms(query, null, null, null, null, null, formPageDTO);
    }

    @Override
    public void findForms(String query, WikittyExtension extension, String dateType, Date beginDate, Date endDate, List[] thesaurus, VradiFormPageDTO formPageDTO) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("findForms " + dateType + " " + beginDate + " - " + endDate + "  : " + extension));
        }
        Search search = Search.query();
        Map<String, String> caught = this.parseQuery(query);
        if (caught != null && caught.size() > 1) {
            this.createQuery(search, caught, "_search" + (caught.size() - 1) + "_", null);
        } else if (query != null) {
            String[] tokens = query.split("\\s");
            if (tokens.length > 0) {
                for (String token : tokens) {
                    if (!token.isEmpty()) {
                        Search subSearch = search.or();
                        subSearch.keyword(token);
                        subSearch.keyword(token + "*");
                        continue;
                    }
                    if (tokens.length != 1) continue;
                    search.keyword("*");
                }
            } else {
                search.keyword("*");
            }
        }
        if (extension != null) {
            search.eq(Element.ELT_EXTENSION, extension.getName());
        }
        if (dateType != null && beginDate != null && endDate != null) {
            log.info((Object)dateType);
            String bDateS = WikittyUtil.solrDateFormat.format(beginDate);
            String eDateS = WikittyUtil.solrDateFormat.format(endDate);
            if (!beginDate.equals(endDate)) {
                search.bw(dateType, bDateS, eDateS);
            }
        }
        if (thesaurus != null) {
            for (int i = 0; i < thesaurus.length; ++i) {
                if (thesaurus[i] == null) continue;
                Search subSearch = search.or();
                for (Object th : thesaurus[i]) {
                    subSearch.eq("Form.thesaurus", (String)th);
                }
            }
        }
        Criteria criteria = search.criteria();
        int firstIndex = (formPageDTO.getPageToShow() - 1) * formPageDTO.getNbFormsToShow();
        int lastIndex = formPageDTO.getPageToShow() * formPageDTO.getNbFormsToShow() - 1;
        if (firstIndex >= 0 && lastIndex > 0 && lastIndex > firstIndex) {
            criteria = criteria.setFirstIndex(firstIndex).setEndIndex(lastIndex);
        }
        if (formPageDTO.getFieldToSort() != null) {
            criteria = !formPageDTO.isAscending() ? criteria.addSortDescending(formPageDTO.getFieldToSort()) : criteria.addSortAscending(formPageDTO.getFieldToSort());
        }
        criteria = criteria.addSortAscending("name");
        PagedResult queryResult = this.proxy.findAllByCriteria(Form.class, criteria);
        ArrayList<Form> result = new ArrayList<Form>(queryResult.getAll());
        for (Form form : result) {
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("found: " + form.toString()));
        }
        formPageDTO.setFormsToShow(result);
        formPageDTO.setTotalFoundFormNb(queryResult.getNumFound());
    }

    @Override
    public List<String> getQueriesReturningForm(Form form) throws TechnicalException {
        ArrayList<String> result = new ArrayList<String>();
        if (this.queriesInTheDB == null) {
            ArrayList<Object> queryMakers = new ArrayList<Object>();
            queryMakers.addAll(this.getAllClients());
            queryMakers.addAll(this.getAllGroups());
            queryMakers.addAll(this.getAllUsers());
            this.queriesInTheDB = new ArrayList<String>();
            for (QueryMaker queryMaker : queryMakers) {
                if (queryMaker.getQueries() == null) continue;
                for (String query : queryMaker.getQueries()) {
                    if (this.queriesInTheDB.contains(query)) continue;
                    this.queriesInTheDB.add(query);
                }
            }
        }
        for (String query : this.queriesInTheDB) {
            Map<String, String> map = this.parseQuery(query);
            if (map == null) continue;
            for (Map.Entry<String, String> stringStringEntry : map.entrySet()) {
                log.info((Object)(stringStringEntry.getKey() + " : " + stringStringEntry.getValue()));
            }
            Boolean formFound = this.isQueryReturningForm(map, "_search" + (map.size() - 1) + "_", null, form);
            if (formFound == null || !formFound.booleanValue()) continue;
            result.add(query);
        }
        return result;
    }

    protected Map<String, String> parseQuery(String query) {
        if (query != null && !query.isEmpty()) {
            String s = query;
            boolean hasMatched = true;
            int k = 0;
            HashMap<String, String> caught = new HashMap<String, String>();
            while (hasMatched) {
                hasMatched = false;
                Matcher m = queryPattern.matcher(s);
                while (m.find()) {
                    hasMatched = true;
                    caught.put("_search" + k + "_", m.group(0).trim());
                    s = s.replace(m.group(0).trim(), "_search" + k++ + "_");
                }
            }
            caught.put("_search" + k + "_", "(" + s + ")");
            return caught;
        }
        return null;
    }

    @Override
    public List<WikittyExtension> getAllFormTypes() {
        Map map;
        if (log.isDebugEnabled()) {
            log.debug((Object)"getAllFormTypes");
        }
        if ((map = this.cacheMap.get(WikittyExtension.class)) == null) {
            ArrayList result = new ArrayList();
            WikittyService wikittyService = this.proxy.getWikittyService();
            result.addAll(wikittyService.getAllExtensions(true));
            ArrayList<WikittyExtension> formTypes = new ArrayList<WikittyExtension>();
            HashMap<String, WikittyExtension> extensionMap = new HashMap<String, WikittyExtension>();
            for (WikittyExtension extension : result) {
                if (extension == null || !"Form".equals(extension.getRequires())) continue;
                formTypes.add(extension);
                extensionMap.put(extension.getName(), extension);
            }
            this.cacheMap.put(WikittyExtension.class, extensionMap);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Number of FormType found : " + result.size()));
            }
            return formTypes;
        }
        return new ArrayList<WikittyExtension>(map.values());
    }

    @Override
    public WikittyExtension getFormType(String name) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getFormType");
        }
        if (this.cacheMap.get(WikittyExtension.class) == null) {
            this.getAllFormTypes();
        }
        return name == null ? null : (WikittyExtension)this.cacheMap.get(WikittyExtension.class).get(name);
    }

    @Override
    public Map<String, FieldType> getFormTypeFields(String name) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getFormTypeFields");
        }
        WikittyExtension ext = this.getFormType(name);
        HashMap<String, FieldType> result = new HashMap<String, FieldType>();
        for (String fieldName : ext.getFieldNames()) {
            result.put(fieldName, ext.getFieldType(fieldName));
        }
        return result;
    }

    @Override
    public WikittyExtension updateFormType(String name, Map<String, FieldType> fields, String requires, Map<String, String> tagValues) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"updateFormType");
        }
        if (name != null) {
            WikittyExtension result = null;
            WikittyExtension lastVersion = this.getFormType(name);
            if (log.isDebugEnabled()) {
                log.debug((Object)("lastVersion : " + lastVersion));
            }
            result = lastVersion != null ? new WikittyExtension(name, WikittyUtil.incrementMajorRevision((String)lastVersion.getVersion()), requires, (LinkedHashMap)fields) : new WikittyExtension(name, "0.0", requires, (LinkedHashMap)fields);
            for (Map.Entry<String, String> entry : tagValues.entrySet()) {
                result.addTagValue(entry.getKey(), entry.getValue());
            }
            List<WikittyExtension> extensions = Arrays.asList(result);
            this.proxy.getWikittyService().storeExtension(extensions);
            if (log.isDebugEnabled()) {
                log.debug((Object)("formType : " + result.getId()));
            }
            this.cacheMap.get(WikittyExtension.class).put(name, result);
            return result;
        }
        return null;
    }

    @Override
    public WikittyExtension updateFormType(WikittyExtension extension) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"updateFormType");
        }
        LinkedHashMap<String, FieldType> fields = new LinkedHashMap<String, FieldType>();
        for (String fieldName : extension.getFieldNames()) {
            FieldType fieldType = extension.getFieldType(fieldName);
            log.debug((Object)(fieldName + " : " + fieldType.getTagValue("description")));
            fields.put(fieldName, fieldType);
        }
        return this.updateFormType(extension.getName(), fields, extension.getRequires(), extension.getTagValues());
    }

    @Override
    public Form getForm(String formId) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getForm");
        }
        Form result = null;
        if (formId != null) {
            result = (Form)this.proxy.restore(Form.class, formId);
        }
        return result;
    }

    @Override
    public List<Form> getForms(List<String> formIds) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getForm");
        }
        List result = null;
        if (formIds != null) {
            result = this.proxy.restore(Form.class, formIds);
        }
        return result;
    }

    @Override
    public List<Form> getAllForms() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getAllForms");
        }
        Criteria criteria = Search.query().eq(Element.ELT_EXTENSION, "Form").criteria();
        return new ArrayList<Form>(this.proxy.findAllByCriteria(Form.class, criteria).getAll());
    }

    protected void createQuery(Search search, Map<String, String> caught, String sss, String field) {
        String expression;
        String si;
        if (log.isDebugEnabled()) {
            log.debug((Object)"createQuery");
        }
        if ((si = caught.get(sss)).startsWith("(")) {
            expression = si.substring(1, si.length() - 1);
        } else {
            field = si.substring(0, si.indexOf(":"));
            expression = si.substring(si.indexOf("(") + 1, si.length() - 1);
        }
        String[] orSplitted = expression.split(" OR ");
        if (orSplitted.length > 1) {
            this.addTokens(search.or(), orSplitted, field, caught);
        } else {
            String[] andSplitted = expression.split(" AND ");
            if (andSplitted.length > 1) {
                this.addTokens(search.and(), andSplitted, field, caught);
            } else {
                this.addTokens(search, new String[]{expression}, field, caught);
            }
        }
    }

    protected void addTokens(Search search, String[] tokens, String field, Map<String, String> caught) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"equalsFieldValue");
        }
        for (String token : tokens) {
            Search subSearch;
            block23: {
                block22: {
                    block21: {
                        if (token.trim().startsWith("NOT ")) {
                            block20: {
                                block19: {
                                    block18: {
                                        if (field == null) {
                                            search.not().keyword(token.trim());
                                            continue;
                                        }
                                        subSearch = search.and();
                                        subSearch.neq(Criteria.ALL_EXTENSIONS + Criteria.SEPARATOR + field + Criteria.SEPARATOR + Element.ElementType.TEXT, token.trim().substring(4));
                                        subSearch.neq(Criteria.ALL_EXTENSIONS + Criteria.SEPARATOR + field + Criteria.SEPARATOR + Element.ElementType.TEXT, token.trim().substring(4) + "*");
                                        try {
                                            subSearch.neq(Criteria.ALL_EXTENSIONS + Criteria.SEPARATOR + field + Criteria.SEPARATOR + Element.ElementType.DATE, WikittyUtil.solrDateFormat.format(DateFormat.getInstance().parse(token.trim().substring(4))));
                                        }
                                        catch (ParseException eee) {
                                            if (!log.isDebugEnabled()) break block18;
                                            log.debug((Object)(token + " cannot be a date."));
                                        }
                                    }
                                    try {
                                        Boolean.parseBoolean(token.trim().substring(4));
                                        subSearch.neq(Criteria.ALL_EXTENSIONS + Criteria.SEPARATOR + field + Criteria.SEPARATOR + Element.ElementType.BOOLEAN, token.trim().substring(4).toLowerCase());
                                    }
                                    catch (Exception eee) {
                                        if (!log.isDebugEnabled()) break block19;
                                        log.debug((Object)(token + " cannot be a boolean."));
                                    }
                                }
                                try {
                                    Double.valueOf(token.trim().substring(4));
                                    subSearch.neq(Criteria.ALL_EXTENSIONS + Criteria.SEPARATOR + field + Criteria.SEPARATOR + Element.ElementType.NUMERIC, token.trim().substring(4));
                                }
                                catch (NumberFormatException eee) {
                                    if (!log.isDebugEnabled()) break block20;
                                    log.debug((Object)(token + " cannot be a number."));
                                }
                            }
                            subSearch.neq(Criteria.ALL_EXTENSIONS + Criteria.SEPARATOR + field + Criteria.SEPARATOR + Element.ElementType.WIKITTY, token.trim().substring(4));
                            continue;
                        }
                        if (caught.containsKey(token.trim())) {
                            this.createQuery(search, caught, token.trim(), field);
                            continue;
                        }
                        if (field == null) {
                            search.keyword(token.trim());
                            continue;
                        }
                        subSearch = search.or();
                        subSearch.eq(Criteria.ALL_EXTENSIONS + Criteria.SEPARATOR + field + Criteria.SEPARATOR + Element.ElementType.TEXT, token.trim());
                        subSearch.eq(Criteria.ALL_EXTENSIONS + Criteria.SEPARATOR + field + Criteria.SEPARATOR + Element.ElementType.TEXT, token.trim() + "*");
                        try {
                            GregorianCalendar calendar = new GregorianCalendar();
                            calendar.setTime(DateFormat.getDateInstance(3, Locale.FRANCE).parse(token.trim()));
                            GregorianCalendar beginCal = new GregorianCalendar();
                            beginCal.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
                            GregorianCalendar endCal = new GregorianCalendar();
                            endCal.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
                            ((Calendar)endCal).add(5, 1);
                            log.info((Object)(beginCal.getTime() + " - " + endCal.getTime()));
                            subSearch.bw(Criteria.ALL_EXTENSIONS + Criteria.SEPARATOR + field + Criteria.SEPARATOR + Element.ElementType.DATE, WikittyUtil.solrDateFormat.format(beginCal.getTime()), WikittyUtil.solrDateFormat.format(endCal.getTime()));
                        }
                        catch (ParseException eee) {
                            if (!log.isDebugEnabled()) break block21;
                            log.debug((Object)(token + " cannot be a date."));
                        }
                    }
                    try {
                        Boolean.parseBoolean(token.trim());
                        subSearch.eq(Criteria.ALL_EXTENSIONS + Criteria.SEPARATOR + field + Criteria.SEPARATOR + Element.ElementType.BOOLEAN, token.trim());
                    }
                    catch (Exception eee) {
                        if (!log.isDebugEnabled()) break block22;
                        log.debug((Object)(token.toLowerCase() + " cannot be a boolean."));
                    }
                }
                try {
                    Double.valueOf(token.trim());
                    subSearch.eq(Criteria.ALL_EXTENSIONS + Criteria.SEPARATOR + field + Criteria.SEPARATOR + Element.ElementType.NUMERIC, token.trim());
                }
                catch (NumberFormatException eee) {
                    if (!log.isDebugEnabled()) break block23;
                    log.debug((Object)(token + " cannot be a number."));
                }
            }
            subSearch.eq(Criteria.ALL_EXTENSIONS + Criteria.SEPARATOR + field + Criteria.SEPARATOR + Element.ElementType.WIKITTY, token.trim());
        }
    }

    protected Boolean isQueryReturningForm(Map<String, String> caught, String sss, String field, Form form) {
        String[] andSplitted;
        String expression;
        String si;
        if (log.isDebugEnabled()) {
            log.debug((Object)"createQuery");
        }
        if ((si = caught.get(sss)).startsWith("(")) {
            expression = si.substring(1, si.length() - 1);
        } else {
            field = si.substring(0, si.indexOf(":"));
            expression = si.substring(si.indexOf("(") + 1, si.length() - 1);
        }
        String[] orSplitted = expression.split(" OR ");
        Boolean result = orSplitted.length > 1 ? this.equalsFieldValue(orSplitted, field, caught, form, false) : ((andSplitted = expression.split(" AND ")).length > 1 ? this.equalsFieldValue(andSplitted, field, caught, form, true) : this.equalsFieldValue(new String[]{expression}, field, caught, form, true));
        return result;
    }

    protected Boolean equalsFieldValue(String[] tokens, String field, Map<String, String> caught, Form form, Boolean and) {
        Boolean result;
        block47: {
            if (log.isDebugEnabled()) {
                log.debug((Object)"equalsFieldValue");
            }
            result = null;
            if (form == null) break block47;
            if (field != null) {
                HashMap<String, FieldType> extensions = new HashMap<String, FieldType>();
                for (WikittyExtension ext : form.getExtensions()) {
                    if (ext.getFieldType(field) == null) continue;
                    extensions.put(ext.getName(), ext.getFieldType(field));
                }
                for (String token : tokens) {
                    Boolean tokenResult = null;
                    if (token.trim().startsWith("NOT ")) {
                        block35: for (String extensionName : extensions.keySet()) {
                            switch (((FieldType)extensions.get(extensionName)).getType()) {
                                case DATE: {
                                    Date formDate = (Date)form.getField(extensionName, field);
                                    try {
                                        Date queryDate = DateFormat.getInstance().parse(token.trim().substring(4));
                                        tokenResult = !formDate.equals(queryDate);
                                    }
                                    catch (ParseException eee) {
                                        if (!log.isDebugEnabled()) continue block35;
                                        log.debug((Object)(token + " cannot be a date."));
                                    }
                                    break;
                                }
                                case BOOLEAN: {
                                    Boolean formBoolean = (Boolean)form.getField(extensionName, field);
                                    try {
                                        Boolean queryBoolean = Boolean.parseBoolean(token.trim().substring(4));
                                        tokenResult = !formBoolean.equals(queryBoolean);
                                    }
                                    catch (Exception eee) {
                                        if (!log.isDebugEnabled()) continue block35;
                                        log.debug((Object)(token + " cannot be a boolean."));
                                    }
                                    break;
                                }
                                case NUMERIC: {
                                    BigDecimal formNumber = (BigDecimal)form.getField(extensionName, field);
                                    try {
                                        BigDecimal queryNumber = BigDecimal.valueOf(Double.valueOf(token.trim().substring(4)));
                                        tokenResult = !formNumber.equals(queryNumber);
                                    }
                                    catch (NumberFormatException eee) {
                                        if (!log.isDebugEnabled()) continue block35;
                                        log.debug((Object)(token + " cannot be a number."));
                                    }
                                    break;
                                }
                                default: {
                                    String formString = (String)form.getField(extensionName, field);
                                    String queryString = token.trim().substring(4);
                                    tokenResult = !formString.equals(queryString);
                                }
                            }
                        }
                    } else if (caught.containsKey(token.trim())) {
                        tokenResult = this.isQueryReturningForm(caught, token.trim(), field, form);
                    } else {
                        block36: for (String extensionName : extensions.keySet()) {
                            FieldType type = (FieldType)extensions.get(extensionName);
                            switch (type.getType()) {
                                case DATE: {
                                    Date formDate = (Date)form.getField(extensionName, field);
                                    try {
                                        Date queryDate = DateFormat.getInstance().parse(token.trim());
                                        tokenResult = formDate.equals(queryDate);
                                    }
                                    catch (ParseException eee) {
                                        if (!log.isDebugEnabled()) continue block36;
                                        log.debug((Object)(token + " cannot be a date."));
                                    }
                                    break;
                                }
                                case BOOLEAN: {
                                    Boolean formBoolean = (Boolean)form.getField(extensionName, field);
                                    try {
                                        Boolean queryBoolean = Boolean.parseBoolean(token.trim());
                                        tokenResult = formBoolean.equals(queryBoolean);
                                    }
                                    catch (Exception eee) {
                                        if (!log.isDebugEnabled()) continue block36;
                                        log.debug((Object)(token + " cannot be" + " a boolean."));
                                    }
                                    break;
                                }
                                case NUMERIC: {
                                    BigDecimal formNumber = (BigDecimal)form.getField(extensionName, field);
                                    try {
                                        BigDecimal queryNumber = BigDecimal.valueOf(Double.valueOf(token.trim()));
                                        tokenResult = formNumber.equals(queryNumber);
                                    }
                                    catch (NumberFormatException eee) {
                                        if (!log.isDebugEnabled()) continue block36;
                                        log.debug((Object)(token + " cannot be a number."));
                                    }
                                    break;
                                }
                                default: {
                                    String formString = (String)form.getField(extensionName, field);
                                    String queryString = token.trim();
                                    tokenResult = formString.equals(queryString);
                                }
                            }
                        }
                    }
                    result = result == null ? tokenResult : (and != false ? Boolean.valueOf(result != false && tokenResult != false) : Boolean.valueOf(result != false || tokenResult != false));
                }
            } else {
                String tokenValue = tokens[0];
                Boolean fieldResult = null;
                for (WikittyExtension ext : form.getExtensions()) {
                    String extensionName = ext.getName();
                    for (String fieldName : ext.getFieldNames()) {
                        switch (ext.getFieldType(fieldName).getType()) {
                            case DATE: {
                                Date formDate = (Date)form.getField(extensionName, fieldName);
                                try {
                                    Date queryDate = DateFormat.getInstance().parse(tokenValue.trim());
                                    fieldResult = formDate != null ? formDate.equals(queryDate) : false;
                                }
                                catch (ParseException eee) {
                                    if (!log.isDebugEnabled()) break;
                                    log.debug((Object)(tokenValue + " cannot be a date."));
                                }
                                break;
                            }
                            case BOOLEAN: {
                                Boolean formBoolean = (Boolean)form.getField(extensionName, fieldName);
                                try {
                                    Boolean queryBoolean = Boolean.parseBoolean(tokenValue.trim());
                                    fieldResult = formBoolean != null ? formBoolean.equals(queryBoolean) : false;
                                }
                                catch (Exception eee) {
                                    if (!log.isDebugEnabled()) break;
                                    log.debug((Object)(tokenValue + " cannot be a boolean."));
                                }
                                break;
                            }
                            case NUMERIC: {
                                BigDecimal formNumber = (BigDecimal)form.getField(extensionName, fieldName);
                                try {
                                    BigDecimal queryNumber = BigDecimal.valueOf(Double.valueOf(tokenValue.trim()));
                                    fieldResult = formNumber != null ? formNumber.equals(queryNumber) : false;
                                }
                                catch (NumberFormatException eee) {
                                    if (!log.isDebugEnabled()) break;
                                    log.debug((Object)(tokenValue + " cannot be a number."));
                                }
                                break;
                            }
                            default: {
                                String formString = (String)form.getField(extensionName, fieldName);
                                String queryString = tokenValue.trim();
                                fieldResult = formString != null ? formString.contains(queryString) : false;
                            }
                        }
                        if (result == null) {
                            result = fieldResult;
                            continue;
                        }
                        if (fieldResult == null) continue;
                        result = result != false || fieldResult != false;
                    }
                }
            }
        }
        return result;
    }

    @Override
    public List<XmlStream> getAllXmlStreams() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getAllXmlStreams");
        }
        ArrayList<XmlStream> result = new ArrayList<XmlStream>();
        for (BusinessEntity entity : this.getAllEntities(XmlStream.class, "XmlStream")) {
            result.add((XmlStream)entity);
        }
        return result;
    }

    @Override
    public List<XmlFieldBinding> updateXmlFieldBindings(List<XmlFieldBinding> bindings) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"updateXmlFieldBindings");
        }
        if (bindings != null) {
            List<XmlFieldBinding> result = new ArrayList();
            for (XmlFieldBinding binding : bindings) {
                if (binding == null) continue;
                result.add(binding);
            }
            result = this.proxy.store(result);
            return new ArrayList<XmlFieldBinding>(result);
        }
        return null;
    }

    @Override
    public TreeNode getRootThesaurus() throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getRootThesaurus");
        }
        Criteria criteria = Search.query().eq(Element.ELT_EXTENSION, "TreeNode").eq("TreeNode.name", ROOT_THESAURUS_NAME).criteria();
        List rootThesaurus = this.proxy.findAllByCriteria(TreeNode.class, criteria).getAll();
        log.debug((Object)("Thesaurus find " + rootThesaurus));
        if (rootThesaurus.isEmpty()) {
            TreeNodeImpl thesaurusImpl = new TreeNodeImpl();
            thesaurusImpl.setName(ROOT_THESAURUS_NAME);
            this.updateEntity((BusinessEntity)thesaurusImpl);
            return thesaurusImpl;
        }
        return (TreeNode)rootThesaurus.get(0);
    }

    @Override
    public List<TreeNode> getAllThesaurus() throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getAllThesaurus");
        }
        ArrayList<TreeNode> result = new ArrayList<TreeNode>();
        for (BusinessEntity entity : this.getAllEntities(TreeNode.class, "TreeNode")) {
            result.add((TreeNode)entity);
            log.debug((Object)(((TreeNode)entity).getName() + " " + ((TreeNode)entity).getChildren()));
        }
        return result;
    }

    @Override
    public TreeNode getThesaurus(String thesaurusId) throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getThesaurus");
        }
        return (TreeNode)this.getEntity(thesaurusId, TreeNode.class);
    }

    @Override
    public List<TreeNode> getChildrenThesaurus(String thesaurusId) throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getChildrenThesaurus");
        }
        ArrayList<TreeNode> result = new ArrayList<TreeNode>();
        for (BusinessEntity entity : this.getAllEntities(TreeNode.class, "TreeNode")) {
            TreeNode node = (TreeNode)entity;
            if (node.getParent() == null || !node.getParent().equals(thesaurusId)) continue;
            result.add(node);
        }
        return result;
    }

    @Override
    public XmlStream getXmlStream(String xmlStreamId) throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getXmlStream");
        }
        return (XmlStream)this.getEntity(xmlStreamId, XmlStream.class);
    }

    @Override
    public XmlFieldBinding getXmlFieldBinding(String xmlFieldBindingId) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getXmlFieldBinding");
        }
        XmlFieldBinding result = null;
        if (xmlFieldBindingId != null) {
            result = (XmlFieldBinding)this.proxy.restore(XmlFieldBinding.class, xmlFieldBindingId);
        }
        return result;
    }

    @Override
    public List<XmlFieldBinding> getXmlFieldBindings(XmlStream xmlStream) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getXmlFieldBindings");
            log.debug((Object)xmlStream.getXmlFieldBinding());
        }
        if (xmlStream != null && xmlStream.getXmlFieldBinding() != null) {
            ArrayList bindings = new ArrayList();
            bindings.addAll(xmlStream.getXmlFieldBinding());
            return this.proxy.restore(XmlFieldBinding.class, bindings);
        }
        return null;
    }

    @Override
    public void bindFormsToClients() {
        block10: {
            ArrayList<SendingImpl> toSend = new ArrayList<SendingImpl>();
            try {
                ArrayList<Object> queryMakers = new ArrayList<Object>();
                List<Client> clients = this.getAllClients();
                for (Client client : clients) {
                    Criteria criteria = Search.query().eq(Element.ELT_EXTENSION, "Sending").eq("Sending.client", client.getWikittyId()).criteria();
                    List sendings = this.proxy.findAllByCriteria(Sending.class, criteria).getAll();
                    ArrayList<String> alreadyBoundFormIds = new ArrayList<String>();
                    for (Sending sending : sendings) {
                        if (sending.getForm() == null) continue;
                        alreadyBoundFormIds.addAll(sending.getForm());
                    }
                    queryMakers.add(client);
                    List<User> users = this.getClientUsers(client.getWikittyId());
                    queryMakers.addAll(users);
                    ArrayList<String> formsToBindIds = new ArrayList<String>();
                    for (QueryMaker queryMaker : queryMakers) {
                        if (queryMaker.getQueries() == null) continue;
                        for (String query : queryMaker.getQueries()) {
                            VradiFormPageDTO vradiFormPageDTO = new VradiFormPageDTO();
                            this.findForms(query, vradiFormPageDTO);
                            List<Form> forms = vradiFormPageDTO.getFormsToShow();
                            for (Form form : forms) {
                                if (alreadyBoundFormIds.contains(form.getWikittyId())) continue;
                                formsToBindIds.add(form.getWikittyId());
                            }
                        }
                    }
                    SendingImpl newSending = new SendingImpl();
                    for (Sending sending : sendings) {
                        if (sending.getStatus() != 0) continue;
                        newSending = sending;
                        break;
                    }
                    if (!formsToBindIds.isEmpty()) {
                        newSending.setClient(client.getWikittyId());
                        for (String formsToSendId : formsToBindIds) {
                            newSending.addForm(formsToSendId);
                            alreadyBoundFormIds.add(formsToSendId);
                        }
                        newSending.setSentDate(null);
                        newSending.setReceptionDate(null);
                        newSending.setParagraph(DEFAULT_SENDING_PARAGRAPH);
                        newSending.setReceptionProof(false);
                        newSending.setStatus(0);
                        toSend.add(newSending);
                    }
                    queryMakers.clear();
                }
                this.proxy.store(toSend);
            }
            catch (TechnicalException eee) {
                if (!log.isErrorEnabled()) break block10;
                log.error((Object)eee);
            }
        }
    }

    @Override
    public List<VradiSendingDTO> getFormsByClients(String dateType, Date beginDate, Date endDate, WikittyExtension extension, Boolean receptionProof, Boolean paragraph, int status) throws TechnicalException {
        ArrayList<VradiSendingDTO> result = new ArrayList<VradiSendingDTO>();
        List<Client> clients = this.getAllClients();
        for (Client client : clients) {
            Search search = Search.query().eq(Element.ELT_EXTENSION, "Sending").eq("Sending.client", client.getWikittyId());
            if (receptionProof != null) {
                search.eq("Sending.receptionProof", receptionProof.toString());
            }
            if (paragraph != null) {
                if (paragraph.booleanValue()) {
                    search.neq("Sending.paragraph", DEFAULT_SENDING_PARAGRAPH);
                } else {
                    search.eq("Sending.paragraph", DEFAULT_SENDING_PARAGRAPH);
                }
            }
            if (status >= 0) {
                search.eq("Sending.status", String.valueOf(status));
            }
            Criteria criteria = search.criteria();
            List sendings = this.proxy.findAllByCriteria(Sending.class, criteria).getAll();
            for (Sending sending : sendings) {
                int dot;
                List<Form> forms = this.getForms(sending.getForm() != null ? new ArrayList(sending.getForm()) : new ArrayList());
                String dateExtension = null;
                String dateTypeName = null;
                if (dateType != null && (dot = dateType.indexOf(46)) > 0) {
                    dateExtension = dateType.substring(0, dot);
                    dateTypeName = dateType.substring(dot + 1);
                }
                ArrayList<Form> formsToSend = new ArrayList<Form>();
                for (Form form : forms) {
                    if (extension != null && !form.getExtensions().contains(extension) || dateType != null && beginDate != null && beginDate.after((Date)form.getField(dateExtension, dateTypeName)) || dateType != null && endDate != null && endDate.before((Date)form.getField(dateExtension, dateTypeName))) continue;
                    formsToSend.add(form);
                }
                if (formsToSend == null || formsToSend.isEmpty()) continue;
                VradiSendingDTO formsByClientDTO = new VradiSendingDTO(sending);
                formsByClientDTO.setFormDTOs(formsToSend);
                result.add(formsByClientDTO);
            }
        }
        return result;
    }

    @Override
    public Map<Form, List<Client>> getClientsByForms(String dateType, Date beginDate, Date endDate, WikittyExtension extension) {
        HashMap<Form, List<Client>> result = new HashMap<Form, List<Client>>();
        List<Form> forms = this.getAllForms();
        for (Form form : forms) {
            int dot;
            String dateExtension = null;
            String dateTypeName = null;
            if (dateType != null && (dot = dateType.indexOf(46)) > 0) {
                dateExtension = dateType.substring(0, dot);
                dateTypeName = dateType.substring(dot + 1);
            }
            if (extension != null && !form.getExtensions().contains(extension) || dateType != null && beginDate != null && beginDate.after((Date)form.getField(dateExtension, dateTypeName)) || dateType != null && endDate != null && endDate.before((Date)form.getField(dateExtension, dateTypeName))) continue;
            ArrayList<String> clientIds = new ArrayList<String>();
            Criteria criteria = Search.query().eq(Element.ELT_EXTENSION, "Sending").eq("Sending.form", form.getWikittyId()).criteria();
            List sendings = this.proxy.findAllByCriteria(Sending.class, criteria).getAll();
            for (Sending sending : sendings) {
                clientIds.add(sending.getClient());
            }
            if (clientIds == null || clientIds.isEmpty()) continue;
            result.put(form, this.proxy.restore(Client.class, clientIds));
        }
        return result;
    }

    @Override
    public String getFormsFromXmlStream(XmlStream xmlStream, String lastItemRecorded, VradiUser vradiUser) {
        block25: {
            HashMap<String, Set> streamBinding = new HashMap<String, Set>();
            WikittyExtension formType = null;
            ArrayList<Form> forms = new ArrayList<Form>();
            List bindings = this.proxy.restore(XmlFieldBinding.class, new ArrayList(xmlStream.getXmlFieldBinding()));
            for (XmlFieldBinding binding : bindings) {
                String formTypeName = binding.getFormField().substring(0, binding.getFormField().indexOf(46));
                if (formType == null && !formTypeName.equals("Form")) {
                    formType = this.getFormType(formTypeName);
                }
                streamBinding.put(binding.getFormField(), binding.getXmlField());
            }
            if (formType != null) {
                try {
                    String result = null;
                    SAXBuilder sxb = new SAXBuilder();
                    URL rssUrl = new URL(xmlStream.getUrl());
                    Document document = sxb.build(rssUrl);
                    org.jdom.Element racine = document.getRootElement();
                    List itemElt = null;
                    if (racine.getChild(channel) != null) {
                        itemElt = racine.getChild(channel).getChildren(item);
                    } else if (racine.getChild(item) != null) {
                        itemElt = racine.getChildren(item);
                    } else if (racine.getChild(entry) != null) {
                        itemElt = racine.getChildren(entry);
                    }
                    if (itemElt != null) {
                        for (org.jdom.Element element : itemElt) {
                            StringBuffer sb = new StringBuffer();
                            List fields = element.getChildren();
                            for (org.jdom.Element field : fields) {
                                sb.append(field.getText());
                            }
                            MD5 lastItem = new MD5((Object)sb.toString());
                            if (result == null) {
                                result = MD5.asHex((byte[])lastItem.Final());
                            }
                            if (lastItemRecorded != null && lastItemRecorded.equals(MD5.asHex((byte[])lastItem.Final()))) break;
                            FormImpl form = new FormImpl();
                            form.addExtension(formType);
                            form.addExtension(ModificationTag.MODIFICATION_TAG);
                            block8: for (String field : streamBinding.keySet()) {
                                int dot = field.indexOf(46);
                                String extName = field.substring(0, dot);
                                String fieldName = field.substring(dot + 1);
                                FieldType.TYPE fieldType = null;
                                if (extName.equals("Form")) {
                                    fieldType = FormImpl.extensionForm.getFieldType(fieldName).getType();
                                } else if (formType != null) {
                                    fieldType = formType.getFieldType(fieldName).getType();
                                }
                                if (fieldType == null || streamBinding.get(field) == null) continue;
                                switch (fieldType) {
                                    case DATE: {
                                        for (String xmlField : (Set)streamBinding.get(field)) {
                                            if (element.getChild(xmlField) == null) continue;
                                            form.setField(extName, fieldName, (Object)WikittyUtil.solrDateFormat.format(RSS_DATE_FORMAT.parse(element.getChild(xmlField).getText())));
                                        }
                                        continue block8;
                                    }
                                    default: {
                                        for (String xmlField : (Set)streamBinding.get(field)) {
                                            if (element.getChild(xmlField) == null) continue;
                                            form.setField(extName, fieldName, (Object)((form.getField(extName, fieldName) != null ? form.getField(extName, fieldName) + "\n" : "") + element.getChild(xmlField).getText()));
                                        }
                                        continue block8;
                                    }
                                }
                            }
                            if (form.getId() == null) {
                                form.setId(new FormIdDateFormat().format(new GregorianCalendar().getTime()));
                            }
                            if (vradiUser != null) {
                                form.setField("ModificationTag", "lastModifier", (Object)vradiUser.getName());
                            }
                            forms.add((Form)form);
                        }
                    }
                    this.updateForms(forms);
                    return result;
                }
                catch (Exception eee) {
                    if (!log.isErrorEnabled()) break block25;
                    log.error((Object)eee);
                }
            }
        }
        return null;
    }

    @Override
    public VradiUser updateVradiUser(VradiUser vradiUser) throws TechnicalException {
        Criteria criteria = Search.query().eq("VradiUser.name", vradiUser.getName()).criteria();
        List result = this.proxy.findAllByCriteria(VradiUser.class, criteria).getAll();
        if (result.size() > 0) {
            log.debug((Object)("user " + vradiUser + " already exists"));
            return null;
        }
        return (VradiUser)this.proxy.store((BusinessEntity)vradiUser);
    }

    @Override
    public VradiUser logVradiUser(String vradiUserName, String vradiUserPassword) {
        Criteria criteria = Search.query().eq("VradiUser.name", vradiUserName).eq("VradiUser.password", vradiUserPassword).criteria();
        List result = this.proxy.findAllByCriteria(VradiUser.class, criteria).getAll();
        if (result.size() > 0) {
            return (VradiUser)result.get(0);
        }
        return null;
    }

    @Override
    public void updateSendings(List<Sending> sendings) {
        this.proxy.store(sendings);
    }

    @Override
    public void importData(File file) throws TechnicalException {
        this.proxy.syncImportFromUri(file.toURI().toString());
    }

    @Override
    public String exportData() throws TechnicalException {
        Search search = Search.query();
        search.keyword("*");
        Criteria criteria = search.criteria();
        String result = this.proxy.syncExportAllByCriteria(criteria);
        return result;
    }

    @Override
    public void reindexData() {
        UpdateResponse response = this.proxy.getWikittyService().syncEngin();
        if (log.isDebugEnabled()) {
            log.debug((Object)response.toString());
        }
    }

    @Override
    public void changeDataDir(String newDataDir, String oldDataDir) {
        this.proxy.changeDataDir(newDataDir, oldDataDir);
    }

    @Override
    public Map<TreeNode, Integer> getNbFormsByThesaurus() throws TechnicalException {
        HashMap<TreeNode, Integer> result = new HashMap<TreeNode, Integer>();
        Iterator<TreeNode> i$ = this.getAllThesaurus().iterator();
        while (i$.hasNext()) {
            TreeNode node;
            Map.Entry entry = this.proxy.restoreNode(TreeNode.class, (node = i$.next()).getWikittyId());
            result.put(node, entry == null ? 0 : (Integer)entry.getValue());
        }
        return result;
    }

    @Override
    public int getNbFormsForThesaurus(String thesaurusId) throws TechnicalException {
        Map.Entry entry = this.proxy.restoreNode(TreeNode.class, thesaurusId);
        return entry == null ? 0 : (Integer)entry.getValue();
    }

    public static class FormIdDateFormat
    extends SimpleDateFormat {
        public FormIdDateFormat() {
            super("yyyy-MM-dd");
        }
    }
}

