/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;

public class TransparenteWeakReference<T>
extends WeakReference<T> {
    protected int hash = 0;
    protected String toString = null;
    protected boolean objectToStringUsed = true;

    public TransparenteWeakReference(T o) {
        this(o, true);
    }

    public TransparenteWeakReference(T o, ReferenceQueue<? super T> queue) {
        this((T)o, queue, true);
    }

    public TransparenteWeakReference(T o, boolean objectToStringUsed) {
        super(o);
        this.init(o, objectToStringUsed);
    }

    public TransparenteWeakReference(T o, ReferenceQueue<? super T> queue, boolean objectToStringUsed) {
        super(o, queue);
        this.init(o, objectToStringUsed);
    }

    protected void init(T o, boolean objectToStringUsed) {
        if (o == null) {
            this.hash = 0;
        } else {
            this.hash = o.hashCode();
            if (objectToStringUsed) {
                this.toString = o.toString();
            }
            if (this.toString == null) {
                this.toString = o.getClass().getName() + '@' + Integer.toHexString(this.hash);
            }
            if (this.toString.length() > 100) {
                this.toString = this.toString.substring(0, 100) + "...";
            }
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        Object local = this.get();
        Object other = o;
        if (o instanceof Reference && (other = ((Reference)o).get()) == null) {
            return o.hashCode() == this.hashCode();
        }
        return other == null && local == null || other != null && other.equals(local);
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        return this.toString;
    }
}

