/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;

public class TransparenteSoftReference<T>
extends SoftReference<T> {
    protected int hash = 0;
    protected String toString = null;

    public TransparenteSoftReference(T o) {
        this(o, true);
    }

    public TransparenteSoftReference(T o, ReferenceQueue<? super T> queue) {
        this((T)o, queue, true);
    }

    public TransparenteSoftReference(T o, boolean objectToStringUsed) {
        super(o);
        this.init(o, objectToStringUsed);
    }

    public TransparenteSoftReference(T o, ReferenceQueue<? super T> queue, boolean objectToStringUsed) {
        super(o, queue);
        this.init(o, objectToStringUsed);
    }

    protected void init(T o, boolean objectToStringUsed) {
        if (o == null) {
            this.hash = 0;
        } else {
            this.hash = o.hashCode();
            if (objectToStringUsed) {
                this.toString = o.toString();
            }
            if (this.toString == null) {
                this.toString = o.getClass().getName() + '@' + Integer.toHexString(this.hash);
            }
            if (this.toString.length() > 100) {
                this.toString = this.toString.substring(0, 100) + "...";
            }
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        Object local = this.get();
        if (o instanceof Reference) {
            o = ((Reference)o).get();
        }
        boolean result = o == null && local == null || o != null && o.equals(local);
        return result;
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        return this.toString;
    }
}

