/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.i18n.bundle.I18nBundleEntry;
import org.nuiton.util.RecursiveProperties;

public class Language {
    private static final Log log = LogFactory.getLog(Language.class);
    protected Properties resource;
    protected Locale locale;

    public static URLClassLoader getLoader() {
        ClassLoader loader = Language.class.getClassLoader();
        if (loader instanceof URLClassLoader) {
            return (URLClassLoader)loader;
        }
        log.warn((Object)("could not find the URLClassLoader : " + loader));
        return null;
    }

    public Language(Locale l) {
        this.locale = l;
    }

    public void load(I18nBundleEntry[] bundleEntries) {
        this.resource = new RecursiveProperties();
        try {
            for (I18nBundleEntry e : bundleEntries) {
                e.load(this.resource);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String translate(String sentence) {
        if (this.resource == null) {
            this.recordNotFound(sentence);
            return sentence;
        }
        try {
            String result = this.resource.getProperty(sentence);
            if (null != result && !"".equals(result)) {
                return result;
            }
            this.recordNotFound(sentence);
            return sentence;
        }
        catch (MissingResourceException eee) {
            log.warn((Object)("Resource " + sentence + " unavailable"), (Throwable)eee);
            return sentence;
        }
        catch (Exception eee) {
            log.error((Object)"Unexpected error while translating : ", (Throwable)eee);
            return sentence;
        }
    }

    private void recordNotFound(String key) {
        if (I18n.recordFilePath != null && key != null && !"".equals(key)) {
            File f = new File(I18n.recordFilePath);
            Properties recordProps = new Properties();
            try {
                if (f.exists()) {
                    FileInputStream fis = new FileInputStream(f);
                    recordProps.load(fis);
                    fis.close();
                }
                recordProps.put(key, "");
                FileOutputStream fos = new FileOutputStream(f);
                recordProps.store(fos, "Adding the key : " + key);
                fos.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public String untranslate(String sentence) {
        if (this.resource == null) {
            return sentence;
        }
        try {
            Enumeration<?> e = this.resource.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String translation = this.resource.getProperty(key);
                if (!sentence.equals(translation)) continue;
                return key;
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return sentence;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public int size() {
        return this.resource == null ? 0 : this.resource.size();
    }

    public void close() {
        if (this.resource != null) {
            log.info((Object)this);
            this.resource.clear();
            this.resource = null;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    public boolean equals(Object o) {
        return this == o || o instanceof Language && this.locale.equals(((Language)o).locale);
    }

    public int hashCode() {
        return this.locale.hashCode();
    }

    public String toString() {
        return "Language <locale: " + this.locale + ",nbStences:" + this.size() + ">";
    }
}

