/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ru;

import java.io.IOException;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.ru.RussianCharsets;

public final class RussianLowerCaseFilter
extends TokenFilter {
    char[] charset;

    public RussianLowerCaseFilter(TokenStream in, char[] charset) {
        super(in);
        this.charset = charset;
    }

    public final Token next(Token reusableToken) throws IOException {
        assert (reusableToken != null);
        Token nextToken = this.input.next(reusableToken);
        if (nextToken == null) {
            return null;
        }
        char[] chArray = nextToken.termBuffer();
        int chLen = nextToken.termLength();
        for (int i = 0; i < chLen; ++i) {
            chArray[i] = RussianCharsets.toLowerCase(chArray[i], this.charset);
        }
        return nextToken;
    }
}

