/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.el;

import java.io.IOException;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.el.GreekCharsets;

public final class GreekLowerCaseFilter
extends TokenFilter {
    char[] charset;

    public GreekLowerCaseFilter(TokenStream in, char[] charset) {
        super(in);
        this.charset = charset;
    }

    public final Token next(Token reusableToken) throws IOException {
        assert (reusableToken != null);
        Token nextToken = this.input.next(reusableToken);
        if (nextToken == null) {
            return null;
        }
        char[] chArray = nextToken.termBuffer();
        int chLen = nextToken.termLength();
        for (int i = 0; i < chLen; ++i) {
            chArray[i] = GreekCharsets.toLowerCase(chArray[i], this.charset);
        }
        return nextToken;
    }
}

