/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.editor.config;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.JTextComponent;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.Util;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.editor.config.ConfigTableEditor;
import jaxx.runtime.swing.editor.config.ConfigTableRenderer;
import jaxx.runtime.swing.editor.config.model.CategoryModel;
import jaxx.runtime.swing.editor.config.model.ConfigTableModel;
import jaxx.runtime.swing.editor.config.model.ConfigUIModel;
import jaxx.runtime.swing.editor.config.model.OptionModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ConfigCategoryUI
extends JPanel
implements JAXXObject {
    public static final String PROPERTY_CATEGORY_MODEL = "categoryModel";
    public static final String PROPERTY_SELECTION_MODEL = "selectionModel";
    public static final String BINDING_RESET_ENABLED = "reset.enabled";
    public static final String BINDING_SAVE_ENABLED = "save.enabled";
    public static final String BINDING_TABLE_PANE_COLUMN_HEADER_VIEW = "tablePane.columnHeaderView";
    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVWz28bRRSeuHF+uUlKrCYplMo1JUpEu04AqYcgWsckiqtNXNlO2iaHMPZOnCnjnWV2HDu1ivgDQOJPgDsXJG6cEAfOHLgg/gWEOHBFvJld73rjLU6ED+v1zHvf+96b977xt3+gpCvQ7ee40zFEy5a0SYxH+adPS7XnpC4/Im5dUEdygbzPSAIlDlHKCtZdid46NJV7znfPFXjT4Tax+7zXTTTlyjNG3BNCpERvRj3qrpurBNvrHacleqgBqTjUr//6M/GV9fk3CYQ6DrCbhVQyw7zCTEZNlKCWRHMQ6RTnGLYbQENQuwF8p9VagWHX3cVN8in6DI2baMzBAsAkyl48ZY2h/TuORBN3Hj3GNmGrEq1FmLptiGsQi4KvUef2MW0Ae/VVwJI0uDjbKzqOBhqTKNnkFmESvT8UQxv6SHvFHfUrhJmu+9g7l4TrdwvhpiSuMeJj3b8UtWrgGcLNuIRBE1Ju+5C31Jl0fCyTurISMQg953p5mbhGmC44LPZ7e6egzCcHq6G9zjvoRWW5GDhM6nwVkkQLEeNKXXCmA0dDJLXHeWidvLK4FRj2+mRN/X49CjLbGz9IvBciox53ApNUn4lE16PRSEfmBcHKdGkg4LtBwBAtKYirxjYdwdloScltZfJOYDnq4lPNJ+evC/RGpA9g1I1w1MNZHDmEKC1YlmjxcFAdyrDl6cLiOV1QgHr3n/n0rz/8/v1WTwxSEPt6rGmflsGQOoI7REiqQs96StCSlOV2sLN+iCa9HtRCdzOGWMXfBnIQ7zXlbih3Yxu7JwCRHP/tx5/mP/7lCkpsoSnGsbWFlX0RmucEynrCmdVxHjzUjK62J+B5TXGDYarh+icNwVs2SNR0t8AZTM6T7WJ182UH6nAzpg4Bmdrkz3+nK9897NViBLjdeKV5WI/kARqjNqM20dLoq16sFKYcl7QsHqpbnN6h2FF0/EG9r5/rcclfq3PWatrbBFtE7FPSluhZ1ybtjDeGy0fLWV9EvEZXfZ5duZupqNbcU/VvEAlyh23cICKvNaIIHstZah9z0cQ9h7XVFSin4vFA10m95dHgjA3jnAQ1OOb1luvNd/IYMxgZNCph2CTKdEPCNje4hjW81iJWduWl9rblPZe+AK/EGlwPE0osz6EJ3oY+HHkvjnH/yA9jeyW2wotdHU+VTiuSt7es2C2cqhGpY+YJ2wYWjzmj9TOJct1Q60DKXYlt6Rr7m+VqsZA3jyqFcsk0N/Llo7z5JP+sAlg3TrigLyDbGLTVWLTtUrl4UNqtRvB2NyFI7NmFsnyBOszgluRlogqvLhF1Vp4eG/m9aumovFkpHmwCefOoUDL3dnZVBmk4h+DqyTPG28QKTymtEAsgsJKUwY4LCbWDThAtEsfWuxKGMR2VaJzYyhIi3e7CEUXu4OUVg7rwRo8psfSJ+Z2X9rsOa66GL+RTOJgIia56Jvf8vZTknFWpU9X+CzH+hqRObCZ691KZ5IdlkllaysSa7GNGI5nORZmqi+hcoik/UW8rmuf8oPer0tR33AU0bIzhMw53JJr5wMISZ2rUtkCdPhzAHFHPqQsgnvtDpOy+jEfLDkVTy1/8B8Lb/xvhLiD8C+z5g41gDAAA";
    protected static final Log log = LogFactory.getLog(ConfigCategoryUI.class);
    private static final long serialVersionUID = 1L;
    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();
    protected JLabel categoryLabel;
    protected JPanel categoryLabelPanel;
    protected CategoryModel categoryModel;
    protected JTextArea description;
    protected JScrollPane descriptionPane;
    protected ConfigUIModel model;
    protected JButton reset;
    protected JButton save;
    protected ListSelectionModel selectionModel;
    protected JTable table;
    protected ConfigTableModel tableModel;
    protected JScrollPane tablePane;
    private ConfigCategoryUI $JPanel0 = this;
    private JPanel $JPanel1;
    private JPanel $JPanel2;

    void $afterCompleteSetup() {
        SwingUtil.setI18nTableHeaderRenderer((JTable)this.table, (String[])new String[]{I18n.n_((String)"config.key"), I18n.n_((String)"config.key.tip"), I18n.n_((String)"config.value"), I18n.n_((String)"config.value.tip"), I18n.n_((String)"config.defaultValue"), I18n.n_((String)"config.defaultValue.tip")});
        ConfigTableRenderer renderer = new ConfigTableRenderer();
        SwingUtil.setTableColumnRenderer((JTable)this.table, (int)0, (TableCellRenderer)renderer);
        SwingUtil.setTableColumnRenderer((JTable)this.table, (int)1, (TableCellRenderer)renderer);
        SwingUtil.setTableColumnRenderer((JTable)this.table, (int)2, (TableCellRenderer)renderer);
        Font f = this.table.getFont().deriveFont(3);
        int width = SwingUtil.computeTableColumnWidth((JTable)this.table, (Font)f, (int)0, (String)"___*");
        SwingUtil.fixTableColumnWidth((JTable)this.table, (int)0, (int)width);
        SwingUtil.setTableColumnEditor((JTable)this.table, (int)1, (TableCellEditor)new ConfigTableEditor((ConfigTableModel)this.table.getModel()));
    }

    protected void updateDescriptionText() {
        OptionModel option;
        if (this.selectionModel.isSelectionEmpty()) {
            option = null;
        } else {
            int row = this.selectionModel.getAnchorSelectionIndex();
            ConfigTableModel m = (ConfigTableModel)this.table.getModel();
            option = m.getEntry(row);
            if (log.isDebugEnabled()) {
                log.debug((Object)(row + " : " + option));
            }
        }
        StringBuilder buffer = new StringBuilder();
        if (option == null) {
            buffer.append(I18n._((String)"config.no.option.selected"));
        } else {
            buffer.append(I18n._((String)"config.option.label", (Object[])new Object[]{option.getKey(), I18n._((String)option.getDescription())})).append('\n');
            if (option.isModified()) {
                buffer.append(I18n._((String)"config.option.modified", (Object[])new Object[]{option.getOriginalValue(), option.getValue()})).append('\n');
            }
            if (option.isFinal()) {
                buffer.append(I18n._((String)"config.option.final")).append('\n');
            }
        }
        this.description.setText(buffer.toString());
    }

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return Util.decodeCompressedJAXXObjectDescriptor((String)$jaxxObjectDescriptor);
    }

    public ConfigCategoryUI() {
        this.$initialize();
    }

    public ConfigCategoryUI(JAXXContext parentContext) {
        Util.initContext((JAXXObject)this, (JAXXContext)parentContext);
        this.$initialize();
    }

    public void applyDataBinding(String $binding) {
        if (this.allComponentsCreated && this.$bindings.containsKey($binding)) {
            this.$bindings.get($binding).applyDataBinding();
        }
        this.processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    public Map<String, Object> get$objectMap() {
        return this.$objectMap;
    }

    public JAXXBinding[] getDataBindings() {
        return this.$bindings.values().toArray(new JAXXBinding[this.$bindings.size()]);
    }

    public Object getObjectById(String id) {
        return this.$objectMap.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && this.$activeBindings.contains($binding)) {
            return;
        }
        this.$activeBindings.add($binding);
        try {
            if (this.allComponentsCreated && this.$bindings.containsKey($binding)) {
                this.$bindings.get($binding).processDataBinding();
            }
        }
        finally {
            this.$activeBindings.remove($binding);
        }
    }

    public void processDataBinding(String $binding) {
        this.processDataBinding($binding, false);
    }

    public void registerDataBinding(JAXXBinding binding) {
        this.$bindings.put(binding.getId(), binding);
    }

    public void removeDataBinding(String $binding) {
        if (this.allComponentsCreated && this.$bindings.containsKey($binding)) {
            this.$bindings.get($binding).removeDataBinding();
        }
    }

    public <T> T getContextValue(Class<T> clazz) {
        return (T)this.delegateContext.getContextValue(clazz, null);
    }

    public <T> T getContextValue(Class<T> clazz, String name) {
        return (T)this.delegateContext.getContextValue(clazz, name);
    }

    public JAXXContext getDelegateContext() {
        return this.delegateContext;
    }

    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return (O)SwingUtil.getParentContainer((Object)this, clazz);
    }

    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return (O)SwingUtil.getParentContainer((Object)source, clazz);
    }

    public <T> void removeContextValue(Class<T> clazz) {
        this.delegateContext.removeContextValue(clazz, null);
    }

    public <T> void removeContextValue(Class<T> clazz, String name) {
        this.delegateContext.removeContextValue(clazz, name);
    }

    public <T> void setContextValue(T o) {
        this.delegateContext.setContextValue(o, null);
    }

    public <T> void setContextValue(T o, String name) {
        this.delegateContext.setContextValue(o, name);
    }

    public void doActionPerformed__on__reset(ActionEvent event) {
        this.model.reset();
    }

    public void doActionPerformed__on__save(ActionEvent event) {
        this.model.saveModified();
    }

    public void doTableChanged__on__tableModel(TableModelEvent event) {
        this.updateDescriptionText();
    }

    public void doValueChanged__on__selectionModel(ListSelectionEvent event) {
        if (!event.getValueIsAdjusting()) {
            this.updateDescriptionText();
        }
    }

    public JLabel getCategoryLabel() {
        return this.categoryLabel;
    }

    public JPanel getCategoryLabelPanel() {
        return this.categoryLabelPanel;
    }

    public CategoryModel getCategoryModel() {
        return this.categoryModel;
    }

    public JTextArea getDescription() {
        return this.description;
    }

    public JScrollPane getDescriptionPane() {
        return this.descriptionPane;
    }

    public ConfigUIModel getModel() {
        return this.model;
    }

    public JButton getReset() {
        return this.reset;
    }

    public JButton getSave() {
        return this.save;
    }

    public ListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public JTable getTable() {
        return this.table;
    }

    public ConfigTableModel getTableModel() {
        return this.tableModel;
    }

    public JScrollPane getTablePane() {
        return this.tablePane;
    }

    public void setCategoryModel(CategoryModel newValue) {
        CategoryModel oldValue = this.categoryModel;
        this.categoryModel = newValue;
        this.firePropertyChange(PROPERTY_CATEGORY_MODEL, oldValue, newValue);
    }

    public void setSelectionModel(ListSelectionModel newValue) {
        ListSelectionModel oldValue = this.selectionModel;
        this.selectionModel = newValue;
        this.firePropertyChange(PROPERTY_SELECTION_MODEL, oldValue, newValue);
    }

    protected JPanel get$JPanel1() {
        return this.$JPanel1;
    }

    protected JPanel get$JPanel2() {
        return this.$JPanel2;
    }

    protected void addChildrenToCategoryLabelPanel() {
        if (!this.allComponentsCreated) {
            return;
        }
        this.categoryLabelPanel.add(this.categoryLabel);
    }

    protected void addChildrenToDescriptionPane() {
        if (!this.allComponentsCreated) {
            return;
        }
        this.descriptionPane.getViewport().add(this.description);
    }

    protected void addChildrenToTablePane() {
        if (!this.allComponentsCreated) {
            return;
        }
        this.tablePane.getViewport().add(this.table);
    }

    protected void createCategoryLabel() {
        this.categoryLabel = new JLabel();
        this.$objectMap.put("categoryLabel", this.categoryLabel);
        this.categoryLabel.setName("categoryLabel");
    }

    protected void createCategoryLabelPanel() {
        this.categoryLabelPanel = new JPanel();
        this.$objectMap.put("categoryLabelPanel", this.categoryLabelPanel);
        this.categoryLabelPanel.setName("categoryLabelPanel");
    }

    protected void createCategoryModel() {
        this.categoryModel = this.getContextValue(CategoryModel.class);
        this.$objectMap.put(PROPERTY_CATEGORY_MODEL, this.categoryModel);
    }

    protected void createDescription() {
        this.description = new JTextArea();
        this.$objectMap.put("description", this.description);
        this.description.setName("description");
        this.description.setColumns(15);
        this.description.setLineWrap(true);
        this.description.setWrapStyleWord(true);
        this.description.setFocusable(false);
        if (this.description.getFont() != null) {
            this.description.setFont(this.description.getFont().deriveFont(10.0f));
        }
        this.description.setEditable(false);
        this.description.setRows(3);
    }

    protected void createDescriptionPane() {
        this.descriptionPane = new JScrollPane();
        this.$objectMap.put("descriptionPane", this.descriptionPane);
        this.descriptionPane.setName("descriptionPane");
    }

    protected void createModel() {
        this.model = this.getContextValue(ConfigUIModel.class);
        this.$objectMap.put("model", this.model);
    }

    protected void createReset() {
        this.reset = new JButton();
        this.$objectMap.put("reset", this.reset);
        this.reset.setName("reset");
        this.reset.setText(I18n._((String)"config.action.reset"));
        this.reset.setToolTipText(I18n._((String)"config.action.reset.tip"));
        this.reset.addActionListener((ActionListener)Util.getEventListener(ActionListener.class, (String)"actionPerformed", (Object)this, (String)"doActionPerformed__on__reset"));
    }

    protected void createSave() {
        this.save = new JButton();
        this.$objectMap.put("save", this.save);
        this.save.setName("save");
        this.save.setText(I18n._((String)"config.action.save"));
        this.save.setToolTipText(I18n._((String)"config.action.save.tip"));
        this.save.addActionListener((ActionListener)Util.getEventListener(ActionListener.class, (String)"actionPerformed", (Object)this, (String)"doActionPerformed__on__save"));
    }

    protected void createSelectionModel() {
        this.selectionModel = new DefaultListSelectionModel();
        this.$objectMap.put(PROPERTY_SELECTION_MODEL, this.selectionModel);
        this.selectionModel.addListSelectionListener((ListSelectionListener)Util.getEventListener(ListSelectionListener.class, (String)"valueChanged", (Object)this, (String)"doValueChanged__on__selectionModel"));
    }

    protected void createTable() {
        this.table = new JTable(this.tableModel);
        this.$objectMap.put("table", this.table);
        this.table.setName("table");
        this.table.setRowSelectionAllowed(false);
        this.table.setAutoCreateRowSorter(true);
    }

    protected void createTableModel() {
        this.tableModel = new ConfigTableModel(this.categoryModel);
        this.$objectMap.put("tableModel", this.tableModel);
        this.tableModel.addTableModelListener((TableModelListener)Util.getEventListener(TableModelListener.class, (String)"tableChanged", (Object)this, (String)"doTableChanged__on__tableModel"));
    }

    protected void createTablePane() {
        this.tablePane = new JScrollPane();
        this.$objectMap.put("tablePane", this.tablePane);
        this.tablePane.setName("tablePane");
    }

    private void $completeSetup() {
        this.allComponentsCreated = true;
        this.add((Component)this.categoryLabelPanel, "North");
        this.add((Component)this.tablePane, "Center");
        this.add((Component)this.$JPanel1, "South");
        this.addChildrenToCategoryLabelPanel();
        this.addChildrenToTablePane();
        this.$JPanel1.add((Component)this.descriptionPane, "Center");
        this.$JPanel1.add((Component)this.$JPanel2, "South");
        this.addChildrenToDescriptionPane();
        this.$JPanel2.add(this.reset);
        this.$JPanel2.add(this.save);
        Util.applyDataBinding((JAXXObject)this, this.$bindings.keySet());
        this.table.setSelectionModel(this.selectionModel);
        this.categoryLabelPanel.setBackground(Color.WHITE);
        this.tablePane.setVerticalScrollBarPolicy(22);
        this.tablePane.setHorizontalScrollBarPolicy(31);
        this.table.setAutoResizeMode(4);
        this.descriptionPane.setColumnHeaderView(new JLabel(I18n._((String)"config.descrition"), SwingUtil.getUIManagerActionIcon((String)"information"), 10));
        SwingUtil.setText((JTextComponent)this.description, (String)I18n._((String)"config.no.option.selected"));
        this.reset.setIcon(SwingUtil.createActionIcon((String)"config-reset"));
        this.save.setIcon(SwingUtil.createActionIcon((String)"config-save"));
        this.$afterCompleteSetup();
    }

    private void $initialize() {
        if (this.allComponentsCreated || !this.contextInitialized) {
            return;
        }
        this.$registerDefaultBindings();
        this.$objectMap.put("$JPanel0", this);
        this.createModel();
        this.createCategoryModel();
        this.createTableModel();
        this.createSelectionModel();
        this.createCategoryLabelPanel();
        this.createCategoryLabel();
        this.createTablePane();
        this.createTable();
        this.$JPanel1 = new JPanel();
        this.$objectMap.put("$JPanel1", this.$JPanel1);
        this.$JPanel1.setName("$JPanel1");
        this.$JPanel1.setLayout(new BorderLayout());
        this.createDescriptionPane();
        this.createDescription();
        this.$JPanel2 = new JPanel();
        this.$objectMap.put("$JPanel2", this.$JPanel2);
        this.$JPanel2.setName("$JPanel2");
        this.$JPanel2.setLayout(new GridLayout(1, 0));
        this.createReset();
        this.createSave();
        this.setName("$JPanel0");
        this.setLayout(new BorderLayout());
        this.$completeSetup();
    }

    private void $registerDefaultBindings() {
        this.registerDataBinding((JAXXBinding)new DefaultJAXXBinding(this, BINDING_TABLE_PANE_COLUMN_HEADER_VIEW, true){

            public void applyDataBinding() {
                if (ConfigCategoryUI.this.table != null) {
                    ConfigCategoryUI.this.table.addPropertyChangeListener("tableHeader", (PropertyChangeListener)((Object)this));
                }
            }

            public void processDataBinding() {
                if (ConfigCategoryUI.this.table != null) {
                    ConfigCategoryUI.this.tablePane.setColumnHeaderView(ConfigCategoryUI.this.table.getTableHeader());
                }
            }

            public void removeDataBinding() {
                if (ConfigCategoryUI.this.table != null) {
                    ConfigCategoryUI.this.table.removePropertyChangeListener("tableHeader", (PropertyChangeListener)((Object)this));
                }
            }
        });
        this.registerDataBinding((JAXXBinding)new DefaultJAXXBinding(this, BINDING_RESET_ENABLED, true){

            public void applyDataBinding() {
                ConfigCategoryUI.this.addPropertyChangeListener(ConfigCategoryUI.PROPERTY_CATEGORY_MODEL, (PropertyChangeListener)((Object)this));
                if (ConfigCategoryUI.this.getCategoryModel() != null) {
                    ConfigCategoryUI.this.getCategoryModel().addPropertyChangeListener("modified", (PropertyChangeListener)((Object)this));
                }
            }

            public void processDataBinding() {
                if (ConfigCategoryUI.this.getCategoryModel() != null) {
                    ConfigCategoryUI.this.reset.setEnabled(ConfigCategoryUI.this.getCategoryModel().isModified());
                }
            }

            public void removeDataBinding() {
                ConfigCategoryUI.this.removePropertyChangeListener(ConfigCategoryUI.PROPERTY_CATEGORY_MODEL, (PropertyChangeListener)((Object)this));
                if (ConfigCategoryUI.this.getCategoryModel() != null) {
                    ConfigCategoryUI.this.getCategoryModel().removePropertyChangeListener("modified", (PropertyChangeListener)((Object)this));
                }
            }
        });
        this.registerDataBinding((JAXXBinding)new DefaultJAXXBinding(this, BINDING_SAVE_ENABLED, true){

            public void applyDataBinding() {
                ConfigCategoryUI.this.addPropertyChangeListener(ConfigCategoryUI.PROPERTY_CATEGORY_MODEL, (PropertyChangeListener)((Object)this));
                if (ConfigCategoryUI.this.getCategoryModel() != null) {
                    ConfigCategoryUI.this.getCategoryModel().addPropertyChangeListener("modified", (PropertyChangeListener)((Object)this));
                }
                if (ConfigCategoryUI.this.getCategoryModel() != null) {
                    ConfigCategoryUI.this.getCategoryModel().addPropertyChangeListener("valid", (PropertyChangeListener)((Object)this));
                }
            }

            public void processDataBinding() {
                if (ConfigCategoryUI.this.getCategoryModel() != null) {
                    ConfigCategoryUI.this.save.setEnabled(ConfigCategoryUI.this.getCategoryModel().isModified() && ConfigCategoryUI.this.getCategoryModel().isValid());
                }
            }

            public void removeDataBinding() {
                ConfigCategoryUI.this.removePropertyChangeListener(ConfigCategoryUI.PROPERTY_CATEGORY_MODEL, (PropertyChangeListener)((Object)this));
                if (ConfigCategoryUI.this.getCategoryModel() != null) {
                    ConfigCategoryUI.this.getCategoryModel().removePropertyChangeListener("modified", (PropertyChangeListener)((Object)this));
                }
                if (ConfigCategoryUI.this.getCategoryModel() != null) {
                    ConfigCategoryUI.this.getCategoryModel().removePropertyChangeListener("valid", (PropertyChangeListener)((Object)this));
                }
            }
        });
    }
}

