/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.admin.content;

import com.jurismarches.vradi.entities.Client;
import com.jurismarches.vradi.ui.admin.VradiNavigationTreeHelper;
import com.jurismarches.vradi.ui.admin.content.AdminClientUI;
import java.util.List;
import java.util.Set;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.navigation.NavigationTreeModel;
import jaxx.runtime.swing.navigation.NavigationTreeNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ClientNavigationTreeHelper
extends VradiNavigationTreeHelper {
    private static final Log log = LogFactory.getLog(ClientNavigationTreeHelper.class);

    public ClientNavigationTreeHelper(JAXXContext context) {
        super(CLIENTS.getName(), context);
    }

    @Override
    public NavigationTreeModel createTreeModel() {
        JAXXContext context = this.getContext();
        List clients = (List)CLIENTS.getContextValue(context);
        NavigationTreeNode rootNode = this.builder.buildEmptyRoot(null, "$root");
        NavigationTreeNode clientsNode = this.builder.build(rootNode, I18n._((String)CLIENTS.getName()), CLIENTS, "clients", AdminClientUI.class, null);
        for (Client c : clients) {
            NavigationTreeNode clientNode = this.builder.addClient(context, clientsNode, c);
            Set<String> usersId = c.getUser();
            if (usersId == null) continue;
            for (String userId : usersId) {
                this.builder.addUser(clientNode.getChildAt(0), userId);
            }
        }
        NavigationTreeModel model = this.builder.getModel();
        if (log.isDebugEnabled()) {
            this.builder.printModel(model.getRoot());
        }
        this.setTreeModel(context, model);
        this.setSelectedNode(context, clientsNode);
        return model;
    }
}

