/*
 * Decompiled with CFR 0.152.
 */
package org.sharengo.wikitty.solr;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.SolrParams;
import org.sharengo.wikitty.WikittyException;
import org.sharengo.wikitty.search.And;
import org.sharengo.wikitty.search.AssociatedRestriction;
import org.sharengo.wikitty.search.Between;
import org.sharengo.wikitty.search.Contains;
import org.sharengo.wikitty.search.Element;
import org.sharengo.wikitty.search.EndsWith;
import org.sharengo.wikitty.search.Equals;
import org.sharengo.wikitty.search.Greater;
import org.sharengo.wikitty.search.GreaterOrEqual;
import org.sharengo.wikitty.search.In;
import org.sharengo.wikitty.search.Keyword;
import org.sharengo.wikitty.search.Less;
import org.sharengo.wikitty.search.LessOrEqual;
import org.sharengo.wikitty.search.Not;
import org.sharengo.wikitty.search.NotEquals;
import org.sharengo.wikitty.search.Or;
import org.sharengo.wikitty.search.Restriction;
import org.sharengo.wikitty.search.RestrictionHelper;
import org.sharengo.wikitty.search.StartsWith;
import org.sharengo.wikitty.solr.WikittySearchEngineSolr;

public class Restriction2Solr {
    private static final int MAX_SUBQUERY_RESULT = 100;
    protected static final WikittySearchEngineSolr.FieldModifier dummyFieldModifier = new WikittySearchEngineSolr.FieldModifier(){

        @Override
        public String convertToSolr(String fieldname) {
            return fieldname;
        }

        @Override
        public String convertToField(String solrName) {
            return solrName;
        }
    };
    protected WikittySearchEngineSolr.FieldModifier fieldModifer;

    public Restriction2Solr() {
        this(dummyFieldModifier);
    }

    public Restriction2Solr(WikittySearchEngineSolr.FieldModifier fieldModifer) {
        this.fieldModifer = fieldModifer;
    }

    public String toSolr(Restriction restriction) {
        return this.toSolr(restriction, null);
    }

    public String toSolr(Restriction restriction, SolrServer solr) throws WikittyException {
        switch (restriction.getName()) {
            case TRUE: {
                return this.true2solr();
            }
            case FALSE: {
                return this.false2solr();
            }
            case NOT: {
                Not not = (Not)restriction;
                return this.not2solr(not);
            }
            case AND: {
                And and = (And)restriction;
                return this.and2solr(and);
            }
            case OR: {
                Or or = (Or)restriction;
                return this.or2solr(or);
            }
            case EQUALS: {
                Equals eq = (Equals)restriction;
                return this.eq2solr(eq);
            }
            case NOT_EQUALS: {
                NotEquals neq = (NotEquals)restriction;
                return this.neq2solr(neq);
            }
            case LESS: {
                Less less = (Less)restriction;
                return this.less2solr(less);
            }
            case LESS_OR_EQUAL: {
                LessOrEqual lessEq = (LessOrEqual)restriction;
                return this.lessEq2solr(lessEq);
            }
            case GREATER: {
                Greater great = (Greater)restriction;
                return this.great2solr(great);
            }
            case GREATER_OR_EQUAL: {
                GreaterOrEqual greatEq = (GreaterOrEqual)restriction;
                return this.greatEq2solr(greatEq);
            }
            case BETWEEN: {
                Between between = (Between)restriction;
                return this.between2solr(between);
            }
            case CONTAINS: {
                Contains contains = (Contains)restriction;
                return this.contains2solr(contains);
            }
            case IN: {
                In in = (In)restriction;
                return this.in2solr(in);
            }
            case STARTS_WITH: {
                StartsWith start = (StartsWith)restriction;
                return this.start2solr(start);
            }
            case ENDS_WITH: {
                EndsWith end = (EndsWith)restriction;
                return this.end2solr(end);
            }
            case ASSOCIATED: {
                AssociatedRestriction associated = (AssociatedRestriction)restriction;
                return this.associated2solr(associated, solr);
            }
            case KEYWORD: {
                Keyword keyword = (Keyword)restriction;
                return this.keyword2solr(keyword);
            }
        }
        throw new WikittyException("this kind of restriction is not supported : " + restriction.getName().toString());
    }

    private String in2solr(In in) {
        boolean first = true;
        String result = in.getElement().getName() + ":[";
        for (String value : in.getValue()) {
            if (!first) {
                result = result + ", ";
                first = false;
            }
            result = result + value;
        }
        result = result + "]";
        return result;
    }

    private String associated2solr(AssociatedRestriction associated, SolrServer solr) throws WikittyException {
        And and;
        String subQuery = this.toSolr(associated.getRestriction());
        SolrQuery query = new SolrQuery("{!wikitty}" + subQuery);
        query.setRows(Integer.valueOf(100));
        QueryResponse resp = null;
        try {
            resp = solr.query((SolrParams)query);
        }
        catch (SolrServerException e) {
            throw new WikittyException("Unable to execute associative query on " + associated.getElement().getName(), (Exception)((Object)e));
        }
        SolrDocumentList solrResults = resp.getResults();
        Restriction generatedRestriction = null;
        long size = solrResults.size();
        if (size == 0L) {
            throw new WikittyException("Associated " + associated.getElement().getName() + " do not retrieved any result");
        }
        if (size == 1L) {
            generatedRestriction = RestrictionHelper.eq((Element)associated.getElement(), (String)((String)((SolrDocument)solrResults.get(0)).getFieldValue("id")));
        } else {
            ArrayList<String> ids = new ArrayList<String>(solrResults.size());
            for (SolrDocument doc : solrResults) {
                String id = (String)doc.getFieldValue("id");
                ids.add(id);
            }
            generatedRestriction = new In(associated.getElement(), ids);
        }
        Restriction parent = associated.getParentRestrictionDto();
        if (parent instanceof And) {
            and = (And)parent;
            and.getRestrictions().add(generatedRestriction);
        } else {
            and = RestrictionHelper.and(Arrays.asList(associated.getParentRestrictionDto(), generatedRestriction));
        }
        return this.toSolr((Restriction)and);
    }

    private String not2solr(Not not) throws WikittyException {
        if (not.getRestriction() == null) {
            throw new WikittyException("not.restriction");
        }
        return "( *:* - " + this.toSolr(not.getRestriction()) + " )";
    }

    private String and2solr(And and) throws WikittyException {
        if (and.getRestrictions() == null) {
            throw new WikittyException("and.restrictions is null");
        }
        if (and.getRestrictions().size() < 2) {
            throw new WikittyException("AND is an operator that handle 2 operand at least");
        }
        boolean first = true;
        StringBuffer result = new StringBuffer();
        for (Restriction restriction : and.getRestrictions()) {
            if (first) {
                result.append("( ").append(this.toSolr(restriction));
                first = false;
                continue;
            }
            result.append(" AND ").append(this.toSolr(restriction));
        }
        return result.append(" )").toString();
    }

    private String or2solr(Or or) throws WikittyException {
        if (or.getRestrictions() == null) {
            throw new WikittyException("or.restrictions is null");
        }
        if (or.getRestrictions().size() < 2) {
            throw new WikittyException("OR is an operator that handle 2 operand at least");
        }
        boolean first = true;
        StringBuffer result = new StringBuffer();
        for (Restriction restriction : or.getRestrictions()) {
            if (first) {
                result.append("( ");
                first = false;
            } else {
                result.append(" OR ");
            }
            result.append(this.toSolr(restriction));
        }
        return result.append(" )").toString();
    }

    private String eq2solr(Equals eq) throws WikittyException {
        return this.element2solr(eq.getElement()) + ":" + this.value2solr(eq.getValue());
    }

    private String neq2solr(NotEquals neq) throws WikittyException {
        return "-" + this.element2solr(neq.getElement()) + ":" + this.value2solr(neq.getValue());
    }

    private String less2solr(Less less) throws WikittyException {
        return this.element2solr(less.getElement()) + ":{* TO " + this.value2solr(less.getValue()) + "}";
    }

    private String lessEq2solr(LessOrEqual lessEq) throws WikittyException {
        return this.element2solr(lessEq.getElement()) + ":[* TO " + this.value2solr(lessEq.getValue()) + "]";
    }

    private String great2solr(Greater great) throws WikittyException {
        return this.element2solr(great.getElement()) + ":{" + this.value2solr(great.getValue()) + " TO *}";
    }

    private String greatEq2solr(GreaterOrEqual greatEq) throws WikittyException {
        return this.element2solr(greatEq.getElement()) + ":[" + this.value2solr(greatEq.getValue()) + " TO *]";
    }

    private String between2solr(Between between) throws WikittyException {
        if (between.getElement() == null) {
            throw new WikittyException("contains.element");
        }
        if (between.getMin() == null) {
            throw new WikittyException("contains.min");
        }
        if (between.getMax() == null) {
            throw new WikittyException("contains.max");
        }
        return this.element2solr(between.getElement()) + ":[" + this.value2solr(between.getMin()) + " TO " + this.value2solr(between.getMax()) + "]";
    }

    private String contains2solr(Contains contains) throws WikittyException {
        if (contains.getElement() == null) {
            throw new WikittyException("contains.element");
        }
        if (contains.getValue() == null) {
            throw new WikittyException("contains.values");
        }
        if (contains.getValue().size() < 1) {
            throw new WikittyException("CONTAINS is an operator that handle 1 operand at least");
        }
        String operand = "";
        StringBuffer result = new StringBuffer();
        result.append("(");
        for (String value : contains.getValue()) {
            result.append(operand);
            result.append(this.element2solr(contains.getElement())).append(":").append(this.value2solr(value));
            operand = " OR ";
        }
        result.append(")");
        return result.toString();
    }

    private String start2solr(StartsWith start) throws WikittyException {
        return this.element2solr(start.getElement()) + ":" + this.value2solr(start.getValue(), true, false);
    }

    private String end2solr(EndsWith end) {
        return this.element2solr(end.getElement()) + ":" + this.value2solr(end.getValue());
    }

    private String true2solr() {
        return "( *:* )";
    }

    private String false2solr() {
        return "( *:* - *:* )";
    }

    private String keyword2solr(Keyword keyword) {
        return this.value2solr(keyword.getValue());
    }

    private String value2solr(String value) {
        return this.value2solr(value, false, false);
    }

    private String value2solr(String value, boolean starOnEnd, boolean revert) {
        String result;
        if (value != null) {
            if (value.equals("*")) {
                return "*";
            }
            result = revert ? Restriction2Solr.escapeValue(this.reverse(value)) : Restriction2Solr.escapeValue(value);
        } else {
            result = "";
        }
        if (starOnEnd) {
            result = result + "*";
        }
        if (result.contains(" ")) {
            result = "\"" + result + "\"";
        }
        return result;
    }

    private String element2solr(Element element) throws WikittyException {
        String result = element.getName();
        result = this.fieldModifer.convertToSolr(result);
        return result;
    }

    private static String escapeValue(String value) {
        String LUCENE_REPLACE_PATTERN = "\\+|-|&&|\\||!|\\(|\\)|\\[|\\]|\\{|\\}|\"|:";
        return value.replaceAll("\\+|-|&&|\\||!|\\(|\\)|\\[|\\]|\\{|\\}|\"|:", "\\\\$0");
    }

    private String reverse(String source) {
        int len = source.length();
        StringBuffer dest = new StringBuffer(len);
        for (int i = len - 1; i >= 0; --i) {
            dest.append(source.charAt(i));
        }
        return dest.toString();
    }
}

