/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.highlight.Formatter;
import org.apache.lucene.search.highlight.Fragmenter;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.NullFragmenter;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.search.highlight.SimpleHTMLFormatter;
import org.apache.lucene.search.highlight.TextFragment;
import org.apache.lucene.search.highlight.TokenSources;
import org.apache.solr.common.params.DefaultSolrParams;
import org.apache.solr.common.params.HighlightParams;
import org.apache.solr.common.params.MapSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocList;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.util.GapFragmenter;
import org.apache.solr.util.MultiValueTokenStream;
import org.apache.solr.util.SolrPluginUtils;
import org.apache.solr.util.TokenOrderingFilter;

public class HighlightingUtils
implements HighlightParams {
    private static SolrParams DEFAULTS = null;

    private static SolrParams getParams(SolrQueryRequest request) {
        return new DefaultSolrParams(request.getParams(), DEFAULTS);
    }

    public static boolean isHighlightingEnabled(SolrQueryRequest request) {
        return HighlightingUtils.getParams(request).getBool("hl", false);
    }

    public static Highlighter getHighlighter(Query query, String fieldName, SolrQueryRequest request) {
        Highlighter highlighter = new Highlighter(HighlightingUtils.getFormatter(fieldName, request), (Scorer)HighlightingUtils.getQueryScorer(query, fieldName, request));
        highlighter.setTextFragmenter(HighlightingUtils.getFragmenter(fieldName, request));
        return highlighter;
    }

    public static QueryScorer getQueryScorer(Query query, String fieldName, SolrQueryRequest request) {
        boolean reqFieldMatch = HighlightingUtils.getParams(request).getFieldBool(fieldName, "hl.requireFieldMatch", false);
        if (reqFieldMatch) {
            return new QueryScorer(query, request.getSearcher().getReader(), fieldName);
        }
        return new QueryScorer(query);
    }

    public static String[] getHighlightFields(Query query, SolrQueryRequest request, String[] defaultFields) {
        String[] fields = HighlightingUtils.getParams(request).getParams("hl.fl");
        if (HighlightingUtils.emptyArray(fields)) {
            fields = HighlightingUtils.emptyArray(defaultFields) ? new String[]{request.getSchema().getDefaultSearchFieldName()} : defaultFields;
        } else if (fields.length == 1) {
            fields = SolrPluginUtils.split(fields[0]);
        }
        return fields;
    }

    private static boolean emptyArray(String[] arr) {
        return arr == null || arr.length == 0 || arr.length == 1 && (arr[0] == null || arr[0].trim().length() == 0);
    }

    public static int getMaxSnippets(String fieldName, SolrQueryRequest request) {
        return Integer.parseInt(HighlightingUtils.getParams(request).getFieldParam(fieldName, "hl.snippets"));
    }

    public static Formatter getFormatter(String fieldName, SolrQueryRequest request) {
        SolrParams p = HighlightingUtils.getParams(request);
        return new SimpleHTMLFormatter(p.getFieldParam(fieldName, "hl.simple.pre"), p.getFieldParam(fieldName, "hl.simple.post"));
    }

    public static Fragmenter getFragmenter(String fieldName, SolrQueryRequest request) {
        int fragsize = Integer.parseInt(HighlightingUtils.getParams(request).getFieldParam(fieldName, "hl.fragsize"));
        return fragsize <= 0 ? new NullFragmenter() : new GapFragmenter(fragsize);
    }

    public static NamedList doHighlighting(DocList docs, Query query, SolrQueryRequest req, String[] defaultFields) throws IOException {
        if (!HighlightingUtils.isHighlightingEnabled(req)) {
            return null;
        }
        SolrIndexSearcher searcher = req.getSearcher();
        SimpleOrderedMap fragments = new SimpleOrderedMap();
        String[] fieldNames = HighlightingUtils.getHighlightFields(query, req, defaultFields);
        Document[] readDocs = new Document[docs.size()];
        HashSet<String> fset = new HashSet<String>();
        for (String f : fieldNames) {
            fset.add(f);
        }
        SchemaField keyField = req.getSearcher().getSchema().getUniqueKeyField();
        if (null != keyField) {
            fset.add(keyField.getName());
        }
        searcher.readDocs(readDocs, docs, fset);
        DocIterator iterator = docs.iterator();
        for (int i = 0; i < docs.size(); ++i) {
            int docId = iterator.nextDoc();
            Document doc = readDocs[i];
            SimpleOrderedMap docSummaries = new SimpleOrderedMap();
            for (String fieldName : fieldNames) {
                TextFragment[] frag;
                Object tstream;
                String[] docTexts = doc.getValues(fieldName = fieldName.trim());
                if (docTexts == null) continue;
                Highlighter highlighter = HighlightingUtils.getHighlighter(query, fieldName, req);
                int numFragments = HighlightingUtils.getMaxSnippets(fieldName, req);
                if (docTexts.length == 1) {
                    try {
                        tstream = TokenSources.getTokenStream((IndexReader)searcher.getReader(), (int)docId, (String)fieldName);
                    }
                    catch (IllegalArgumentException e) {
                        tstream = new TokenOrderingFilter(searcher.getSchema().getAnalyzer().tokenStream(fieldName, (Reader)new StringReader(docTexts[0])), 10);
                    }
                    frag = highlighter.getBestTextFragments(tstream, docTexts[0], false, numFragments);
                } else {
                    tstream = new MultiValueTokenStream(fieldName, docTexts, searcher.getSchema().getAnalyzer(), true);
                    frag = highlighter.getBestTextFragments(tstream, tstream.asSingleValue(), false, numFragments);
                }
                if (frag.length <= 0) continue;
                ArrayList<String> fragTexts = new ArrayList<String>();
                for (int j = 0; j < frag.length; ++j) {
                    if (frag[j] == null || !(frag[j].getScore() > 0.0f)) continue;
                    fragTexts.add(frag[j].toString());
                }
                String[] summaries = fragTexts.toArray(new String[0]);
                if (summaries.length <= 0) continue;
                docSummaries.add(fieldName, (Object)summaries);
            }
            String printId = searcher.getSchema().printableUniqueKey(doc);
            fragments.add(printId == null ? null : printId, (Object)docSummaries);
        }
        return fragments;
    }

    static {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("hl.snippets", "1");
        map.put("hl.fragsize", "100");
        map.put("hl.formatter", "simple");
        map.put("hl.simple.pre", "<em>");
        map.put("hl.simple.post", "</em>");
        DEFAULTS = new MapSolrParams(map);
    }
}

