/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldCache;
import org.apache.solr.search.function.DocValues;
import org.apache.solr.search.function.FieldCacheSource;
import org.apache.solr.util.NumberUtils;

class SortableIntFieldSource
extends FieldCacheSource {
    protected int defVal;
    private static int hcode = SortableIntFieldSource.class.hashCode();

    public SortableIntFieldSource(String field) {
        this(field, 0);
    }

    public SortableIntFieldSource(String field, int defVal) {
        super(field);
        this.defVal = defVal;
    }

    public String description() {
        return "sint(" + this.field + ')';
    }

    public DocValues getValues(IndexReader reader) throws IOException {
        FieldCache.StringIndex index = this.cache.getStringIndex(reader, this.field);
        final int[] order = index.order;
        final String[] lookup = index.lookup;
        final int def = this.defVal;
        return new DocValues(){

            public float floatVal(int doc) {
                return this.intVal(doc);
            }

            public int intVal(int doc) {
                int ord = order[doc];
                return ord == 0 ? def : NumberUtils.SortableStr2int(lookup[ord], 0, 3);
            }

            public long longVal(int doc) {
                return this.intVal(doc);
            }

            public double doubleVal(int doc) {
                return this.intVal(doc);
            }

            public String strVal(int doc) {
                return Integer.toString(this.intVal(doc));
            }

            public String toString(int doc) {
                return SortableIntFieldSource.this.description() + '=' + this.intVal(doc);
            }
        };
    }

    public boolean equals(Object o) {
        return o instanceof SortableIntFieldSource && super.equals(o) && this.defVal == ((SortableIntFieldSource)o).defVal;
    }

    public int hashCode() {
        return hcode + super.hashCode() + this.defVal;
    }
}

