/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.util.Map;
import org.apache.lucene.document.Field;
import org.apache.solr.common.params.MapSolrParams;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CompressableField
extends FieldType {
    public static int DEFAULT_COMPRESS_THRESHOLD = 0;
    int compressThreshold;
    private static String CT = "compressThreshold";

    @Override
    protected void init(IndexSchema schema, Map<String, String> args) {
        MapSolrParams p = new MapSolrParams(args);
        this.compressThreshold = p.getInt(CT, DEFAULT_COMPRESS_THRESHOLD);
        args.remove(CT);
        super.init(schema, args);
    }

    @Override
    protected Field.Store getFieldStore(SchemaField field, String internalVal) {
        if (field.isCompressed()) {
            return internalVal.length() >= this.compressThreshold ? Field.Store.COMPRESS : Field.Store.YES;
        }
        return super.getFieldStore(field, internalVal);
    }
}

