/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.highlight;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.lucene.search.Query;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.Config;
import org.apache.solr.highlight.SolrFormatter;
import org.apache.solr.highlight.SolrFragmenter;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.DocList;
import org.apache.solr.util.SolrPluginUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SolrHighlighter {
    public static Logger log = Logger.getLogger(SolrHighlighter.class.getName());
    protected final Map<String, SolrFormatter> formatters = Collections.synchronizedMap(new HashMap());
    protected final Map<String, SolrFragmenter> fragmenters = Collections.synchronizedMap(new HashMap());

    public abstract void initalize(Config var1);

    public boolean isHighlightingEnabled(SolrParams params) {
        return params.getBool("hl", false);
    }

    public String[] getHighlightFields(Query query, SolrQueryRequest request, String[] defaultFields) {
        String[] fields = request.getParams().getParams("hl.fl");
        if (this.emptyArray(fields)) {
            if (this.emptyArray(defaultFields)) {
                String[] stringArray;
                String defaultSearchField = request.getSchema().getSolrQueryParser(null).getField();
                if (null == defaultSearchField) {
                    stringArray = new String[]{};
                } else {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = defaultSearchField;
                }
                fields = stringArray;
            } else {
                fields = defaultFields;
            }
        } else if (fields.length == 1) {
            fields = SolrPluginUtils.split(fields[0]);
        }
        return fields;
    }

    protected boolean emptyArray(String[] arr) {
        return arr == null || arr.length == 0 || arr[0] == null || arr[0].trim().length() == 0;
    }

    public abstract NamedList<Object> doHighlighting(DocList var1, Query var2, SolrQueryRequest var3, String[] var4) throws IOException;
}

