/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.solr.analysis.BaseTokenFilterFactory;
import org.apache.solr.analysis.WordDelimiterFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WordDelimiterFilterFactory
extends BaseTokenFilterFactory {
    int generateWordParts = 0;
    int generateNumberParts = 0;
    int catenateWords = 0;
    int catenateNumbers = 0;
    int catenateAll = 0;
    int splitOnCaseChange = 0;
    int preserveOriginal = 0;

    @Override
    public void init(Map<String, String> args) {
        super.init(args);
        this.generateWordParts = this.getInt("generateWordParts", 1);
        this.generateNumberParts = this.getInt("generateNumberParts", 1);
        this.catenateWords = this.getInt("catenateWords", 0);
        this.catenateNumbers = this.getInt("catenateNumbers", 0);
        this.catenateAll = this.getInt("catenateAll", 0);
        this.splitOnCaseChange = this.getInt("splitOnCaseChange", 1);
        this.preserveOriginal = this.getInt("preserveOriginal", 0);
    }

    public WordDelimiterFilter create(TokenStream input) {
        return new WordDelimiterFilter(input, this.generateWordParts, this.generateNumberParts, this.catenateWords, this.catenateNumbers, this.catenateAll, this.splitOnCaseChange, this.preserveOriginal);
    }
}

