/*
 * #%L
 * Vradi :: Entities
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserImpl;


public  class XmlFieldBindingHelper {

    /**
     * XmlFieldBindingHelper :
     * utility class all provided methods are accessible the static way
     */

    private XmlFieldBindingHelper() {// empty
}

    /**
     * getXmlField :
     * @param wikitty 
     * @return Set<String> 
     */

    public static Set<String> getXmlField(Wikitty wikitty) {
        Set<String> result = wikitty.getFieldAsSet(XmlFieldBinding.EXT_XMLFIELDBINDING, XmlFieldBinding.FIELD_XMLFIELDBINDING_XMLFIELD, String.class);
        return result;
}

    /**
     * setXmlField :
     * @param wikitty 
     * @param xmlField 
     */

    public static void setXmlField(Wikitty wikitty, Set<String> xmlField) {
        clearXmlField(wikitty);
        addAllXmlField(wikitty, xmlField);
}

    /**
     * addAllXmlField :
     * @param wikitty 
     * @param xmlField 
     */

    public static void addAllXmlField(Wikitty wikitty, Set<String> xmlField) {
        if(xmlField != null){
            for (String id:xmlField){
                addXmlField(wikitty, id);
            }
        }
}

    /**
     * addXmlField :
     * @param wikitty 
     * @param element 
     */

    public static void addXmlField(Wikitty wikitty, String element) {
        wikitty.addToField(XmlFieldBinding.EXT_XMLFIELDBINDING, XmlFieldBinding.FIELD_XMLFIELDBINDING_XMLFIELD, element);
}

    /**
     * removeXmlField :
     * @param wikitty 
     * @param element 
     */

    public static void removeXmlField(Wikitty wikitty, String element) {
        wikitty.removeFromField(XmlFieldBinding.EXT_XMLFIELDBINDING, XmlFieldBinding.FIELD_XMLFIELDBINDING_XMLFIELD, element);
}

    /**
     * clearXmlField :
     * @param wikitty 
     */

    public static void clearXmlField(Wikitty wikitty) {
        wikitty.clearField(XmlFieldBinding.EXT_XMLFIELDBINDING, XmlFieldBinding.FIELD_XMLFIELDBINDING_XMLFIELD);
}

    /**
     * getFormField :
     * @param wikitty 
     * @return String 
     */

    public static String getFormField(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(XmlFieldBinding.EXT_XMLFIELDBINDING, XmlFieldBinding.FIELD_XMLFIELDBINDING_FORMFIELD);
        return value;
}

    /**
     * setFormField :
     * @param wikitty 
     * @param formField 
     * @return String 
     */

    public static String setFormField(Wikitty wikitty, String formField) {
        String oldValue = getFormField(wikitty);
        wikitty.setField(XmlFieldBinding.EXT_XMLFIELDBINDING, XmlFieldBinding.FIELD_XMLFIELDBINDING_FORMFIELD, formField);
        return oldValue;
}

    /**
     * getDefaultValue :
     * @param wikitty 
     * @return String 
     */

    public static String getDefaultValue(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(XmlFieldBinding.EXT_XMLFIELDBINDING, XmlFieldBinding.FIELD_XMLFIELDBINDING_DEFAULTVALUE);
        return value;
}

    /**
     * setDefaultValue :
     * @param wikitty 
     * @param defaultValue 
     * @return String 
     */

    public static String setDefaultValue(Wikitty wikitty, String defaultValue) {
        String oldValue = getDefaultValue(wikitty);
        wikitty.setField(XmlFieldBinding.EXT_XMLFIELDBINDING, XmlFieldBinding.FIELD_XMLFIELDBINDING_DEFAULTVALUE, defaultValue);
        return oldValue;
}

    /**
     * equals :
     * @param w1 
     * @param w2 
     * @return boolean 
     */

    public static boolean equals(Wikitty w1, Wikitty w2) {
    boolean result = true;

        if (result) {
            Object f1 = w1.getFieldAsObject(XmlFieldBinding.EXT_XMLFIELDBINDING, XmlFieldBinding.FIELD_XMLFIELDBINDING_XMLFIELD);
            Object f2 = w2.getFieldAsObject(XmlFieldBinding.EXT_XMLFIELDBINDING, XmlFieldBinding.FIELD_XMLFIELDBINDING_XMLFIELD);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(XmlFieldBinding.EXT_XMLFIELDBINDING, XmlFieldBinding.FIELD_XMLFIELDBINDING_FORMFIELD);
            Object f2 = w2.getFieldAsObject(XmlFieldBinding.EXT_XMLFIELDBINDING, XmlFieldBinding.FIELD_XMLFIELDBINDING_FORMFIELD);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(XmlFieldBinding.EXT_XMLFIELDBINDING, XmlFieldBinding.FIELD_XMLFIELDBINDING_DEFAULTVALUE);
            Object f2 = w2.getFieldAsObject(XmlFieldBinding.EXT_XMLFIELDBINDING, XmlFieldBinding.FIELD_XMLFIELDBINDING_DEFAULTVALUE);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

    return result;
}

    /**
     * isExtension :
     * @deprecated renamed to keep consistency, use hasExtension instead
     * @param wikitty 
     * @return boolean 
     */

    @Deprecated
    public static boolean isExtension(Wikitty wikitty) {
        return hasExtension(wikitty);
}

    /**
     * hasExtension :
     * check if wikitty has current extension
     * @param wikitty 
     * @return boolean 
     */

    public static boolean hasExtension(Wikitty wikitty) {
        return wikitty.hasExtension(XmlFieldBinding.EXT_XMLFIELDBINDING);
}

    /**
     * addExtension :
     * ajout les extensions static de cette classe au wikitty en argument
     * @param wikitty 
     */

    public static void addExtension(Wikitty wikitty) {
        for (WikittyExtension ext : XmlFieldBindingAbstract.extensions) {
            wikitty.addExtension(ext);
        }
}


} //XmlFieldBindingHelper
