/*
 * #%L
 * Vradi :: Entities
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.BusinessEntity;
import org.nuiton.wikitty.BusinessEntityWikitty;
import org.nuiton.wikitty.TreeNode;
import org.nuiton.wikitty.TreeNodeAbstract;
import org.nuiton.wikitty.TreeNodeImpl;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyUser;
import org.nuiton.wikitty.WikittyUserAbstract;
import org.nuiton.wikitty.WikittyUserImpl;
import org.nuiton.wikitty.WikittyUtil;


public  class ThesaurusHelper {

    /**
     * ThesaurusHelper :
     * utility class all provided methods are accessible the static way
     */

    private ThesaurusHelper() {// empty
}

    /**
     * getTags :
     * @param wikitty 
     * @return Set<String> 
     */

    public static Set<String> getTags(Wikitty wikitty) {
        Set<String> result = wikitty.getFieldAsSet(Thesaurus.EXT_THESAURUS, Thesaurus.FIELD_THESAURUS_TAGS, String.class);
        return result;
}

    /**
     * addTags :
     * @param wikitty 
     * @param element 
     */

    public static void addTags(Wikitty wikitty, String element) {
        wikitty.addToField(Thesaurus.EXT_THESAURUS, Thesaurus.FIELD_THESAURUS_TAGS, element);
}

    /**
     * removeTags :
     * @param wikitty 
     * @param element 
     */

    public static void removeTags(Wikitty wikitty, String element) {
        wikitty.removeFromField(Thesaurus.EXT_THESAURUS, Thesaurus.FIELD_THESAURUS_TAGS, element);
}

    /**
     * clearTags :
     * @param wikitty 
     */

    public static void clearTags(Wikitty wikitty) {
        wikitty.clearField(Thesaurus.EXT_THESAURUS, Thesaurus.FIELD_THESAURUS_TAGS);
}

    /**
     * getOrder :
     * @param wikitty 
     * @return int 
     */

    public static int getOrder(Wikitty wikitty) {
        int value = wikitty.getFieldAsInt(Thesaurus.EXT_THESAURUS, Thesaurus.FIELD_THESAURUS_ORDER);
        return value;
}

    /**
     * setOrder :
     * @param wikitty 
     * @param order 
     * @return int 
     */

    public static int setOrder(Wikitty wikitty, int order) {
        int oldValue = getOrder(wikitty);
        wikitty.setField(Thesaurus.EXT_THESAURUS, Thesaurus.FIELD_THESAURUS_ORDER, order);
        return oldValue;
}

    /**
     * getComment :
     * @param wikitty 
     * @return String 
     */

    public static String getComment(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(Thesaurus.EXT_THESAURUS, Thesaurus.FIELD_THESAURUS_COMMENT);
        return value;
}

    /**
     * setComment :
     * @param wikitty 
     * @param comment 
     * @return String 
     */

    public static String setComment(Wikitty wikitty, String comment) {
        String oldValue = getComment(wikitty);
        wikitty.setField(Thesaurus.EXT_THESAURUS, Thesaurus.FIELD_THESAURUS_COMMENT, comment);
        return oldValue;
}

    /**
     * getRootThesaurus :
     * @param wikitty 
     * @return String 
     */

    public static String getRootThesaurus(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(Thesaurus.EXT_THESAURUS, Thesaurus.FIELD_THESAURUS_ROOTTHESAURUS);
        return value;
}

    /**
     * setRootThesaurus :
     * @param wikitty 
     * @param rootThesaurus 
     * @return String 
     */

    public static String setRootThesaurus(Wikitty wikitty, String rootThesaurus) {
        String oldValue = getRootThesaurus(wikitty);
        wikitty.setField(Thesaurus.EXT_THESAURUS, Thesaurus.FIELD_THESAURUS_ROOTTHESAURUS, rootThesaurus);
        return oldValue;
}

    /**
     * equals :
     * @param w1 
     * @param w2 
     * @return boolean 
     */

    public static boolean equals(Wikitty w1, Wikitty w2) {
    boolean result = true;

        if (result) {
            Object f1 = w1.getFieldAsObject(Thesaurus.EXT_THESAURUS, Thesaurus.FIELD_THESAURUS_TAGS);
            Object f2 = w2.getFieldAsObject(Thesaurus.EXT_THESAURUS, Thesaurus.FIELD_THESAURUS_TAGS);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Thesaurus.EXT_THESAURUS, Thesaurus.FIELD_THESAURUS_ORDER);
            Object f2 = w2.getFieldAsObject(Thesaurus.EXT_THESAURUS, Thesaurus.FIELD_THESAURUS_ORDER);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Thesaurus.EXT_THESAURUS, Thesaurus.FIELD_THESAURUS_COMMENT);
            Object f2 = w2.getFieldAsObject(Thesaurus.EXT_THESAURUS, Thesaurus.FIELD_THESAURUS_COMMENT);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Thesaurus.EXT_THESAURUS, Thesaurus.FIELD_THESAURUS_ROOTTHESAURUS);
            Object f2 = w2.getFieldAsObject(Thesaurus.EXT_THESAURUS, Thesaurus.FIELD_THESAURUS_ROOTTHESAURUS);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

    return result;
}

    /**
     * isExtension :
     * @deprecated renamed to keep consistency, use hasExtension instead
     * @param wikitty 
     * @return boolean 
     */

    @Deprecated
    public static boolean isExtension(Wikitty wikitty) {
        return hasExtension(wikitty);
}

    /**
     * hasExtension :
     * check if wikitty has current extension
     * @param wikitty 
     * @return boolean 
     */

    public static boolean hasExtension(Wikitty wikitty) {
        return wikitty.hasExtension(Thesaurus.EXT_THESAURUS);
}

    /**
     * addExtension :
     * ajout les extensions static de cette classe au wikitty en argument
     * @param wikitty 
     */

    public static void addExtension(Wikitty wikitty) {
        for (WikittyExtension ext : ThesaurusAbstract.extensions) {
            wikitty.addExtension(ext);
        }
}


} //ThesaurusHelper
