package com.jurismarches.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.BusinessEntityWikitty;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyUtil;

public class XmlStreamHelper extends XmlStreamImpl {

    private static final long serialVersionUID = 565430114L;


    /**
     * This class is not instanciable, it's just helper
     */
    private XmlStreamHelper() {
    }


    static public void setUrl(Wikitty w, String url) {
        w.setField(EXT_XMLSTREAM, XmlStream.FIELD_XMLSTREAM_URL, url);
    }

    static public String getUrl(Wikitty w) {
        String result = w.getFieldAsString(EXT_XMLSTREAM, XmlStream.FIELD_XMLSTREAM_URL);
        return result;
    }


    static public void setName(Wikitty w, String name) {
        w.setField(EXT_XMLSTREAM, XmlStream.FIELD_XMLSTREAM_NAME, name);
    }

    static public String getName(Wikitty w) {
        String result = w.getFieldAsString(EXT_XMLSTREAM, XmlStream.FIELD_XMLSTREAM_NAME);
        return result;
    }


    static public void setFormTypeName(Wikitty w, String formTypeName) {
        w.setField(EXT_XMLSTREAM, XmlStream.FIELD_XMLSTREAM_FORMTYPENAME, formTypeName);
    }

    static public String getFormTypeName(Wikitty w) {
        String result = w.getFieldAsString(EXT_XMLSTREAM, XmlStream.FIELD_XMLSTREAM_FORMTYPENAME);
        return result;
    }

    static public Set<String> getXmlFieldBinding(Wikitty w) {
        Set<String> result = w.getFieldAsSet(EXT_XMLSTREAM, XmlStream.FIELD_XMLSTREAM_XMLFIELDBINDING, String.class);
        return result;
    }

    static public void addXmlFieldBinding(Wikitty w, String element) {
        w.addToField(EXT_XMLSTREAM, XmlStream.FIELD_XMLSTREAM_XMLFIELDBINDING, element);
    }
    
    static public void removeXmlFieldBinding(Wikitty w, String element) {
        w.removeFromField(EXT_XMLSTREAM, XmlStream.FIELD_XMLSTREAM_XMLFIELDBINDING, element);
    }
    
    static public void clearXmlFieldBinding(Wikitty w) {
        w.clearField(EXT_XMLSTREAM, XmlStream.FIELD_XMLSTREAM_XMLFIELDBINDING);
    }


    static public void setForm(Wikitty w, String form) {
        w.setField(EXT_XMLSTREAM, XmlStream.FIELD_XMLSTREAM_FORM, form);
    }

    static public String getForm(Wikitty w) {
        String result = w.getFieldAsString(EXT_XMLSTREAM, XmlStream.FIELD_XMLSTREAM_FORM);
        return result;
    }


    /**
     * Check if wikitty has current extension
     */
    static public boolean isExtension(Wikitty w) {
        boolean result = w.hasExtension(EXT_XMLSTREAM);
        return result;
    }

    /**
     * ajout les extensions static de cette classe au wikitty en argument
     */
    static public void addExtension(Wikitty w) {
        for (WikittyExtension ext : extensions) {
            w.addExtension(ext);
        }
    }

    /**
     * Check equality on all field of this extension, and only those.
     */
    static public boolean equals(Wikitty w1, Wikitty w2) {
        boolean result = true;
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_XMLSTREAM, XmlStream.FIELD_XMLSTREAM_URL);
            Object f2 = w2.getFieldAsObject(EXT_XMLSTREAM, XmlStream.FIELD_XMLSTREAM_URL);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_XMLSTREAM, XmlStream.FIELD_XMLSTREAM_NAME);
            Object f2 = w2.getFieldAsObject(EXT_XMLSTREAM, XmlStream.FIELD_XMLSTREAM_NAME);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_XMLSTREAM, XmlStream.FIELD_XMLSTREAM_FORMTYPENAME);
            Object f2 = w2.getFieldAsObject(EXT_XMLSTREAM, XmlStream.FIELD_XMLSTREAM_FORMTYPENAME);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_XMLSTREAM, XmlStream.FIELD_XMLSTREAM_XMLFIELDBINDING);
            Object f2 = w2.getFieldAsObject(EXT_XMLSTREAM, XmlStream.FIELD_XMLSTREAM_XMLFIELDBINDING);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_XMLSTREAM, XmlStream.FIELD_XMLSTREAM_FORM);
            Object f2 = w2.getFieldAsObject(EXT_XMLSTREAM, XmlStream.FIELD_XMLSTREAM_FORM);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }

        return result;
    }

} //XmlStreamHelper
