package com.jurismarches.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.nuiton.wikitty.BusinessEntityWikitty;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyUtil;

public class UserHelper extends UserImpl {

    private static final long serialVersionUID = 341999971L;


    /**
     * This class is not instanciable, it's just helper
     */
    private UserHelper() {
    }


    static public void setName(Wikitty w, String name) {
        w.setField(EXT_USER, User.FIELD_USER_NAME, name);
    }

    static public String getName(Wikitty w) {
        String result = w.getFieldAsString(EXT_USER, User.FIELD_USER_NAME);
        return result;
    }


    static public void setService(Wikitty w, String service) {
        w.setField(EXT_USER, User.FIELD_USER_SERVICE, service);
    }

    static public String getService(Wikitty w) {
        String result = w.getFieldAsString(EXT_USER, User.FIELD_USER_SERVICE);
        return result;
    }


    static public void setEmail(Wikitty w, String email) {
        w.setField(EXT_USER, User.FIELD_USER_EMAIL, email);
    }

    static public String getEmail(Wikitty w) {
        String result = w.getFieldAsString(EXT_USER, User.FIELD_USER_EMAIL);
        return result;
    }


    static public void setCreationDate(Wikitty w, Date creationDate) {
        w.setField(EXT_USER, User.FIELD_USER_CREATIONDATE, creationDate);
    }

    static public Date getCreationDate(Wikitty w) {
        Date result = w.getFieldAsDate(EXT_USER, User.FIELD_USER_CREATIONDATE);
        return result;
    }


    static public void setValidEmail(Wikitty w, boolean validEmail) {
        w.setField(EXT_USER, User.FIELD_USER_VALIDEMAIL, validEmail);
    }

    static public boolean getValidEmail(Wikitty w) {
        boolean result = w.getFieldAsBoolean(EXT_USER, User.FIELD_USER_VALIDEMAIL);
        return result;
    }


    static public void setAddress(Wikitty w, String address) {
        w.setField(EXT_USER, User.FIELD_USER_ADDRESS, address);
    }

    static public String getAddress(Wikitty w) {
        String result = w.getFieldAsString(EXT_USER, User.FIELD_USER_ADDRESS);
        return result;
    }


    static public void setPhone(Wikitty w, String phone) {
        w.setField(EXT_USER, User.FIELD_USER_PHONE, phone);
    }

    static public String getPhone(Wikitty w) {
        String result = w.getFieldAsString(EXT_USER, User.FIELD_USER_PHONE);
        return result;
    }


    static public void setInscriptionDate(Wikitty w, Date inscriptionDate) {
        w.setField(EXT_USER, User.FIELD_USER_INSCRIPTIONDATE, inscriptionDate);
    }

    static public Date getInscriptionDate(Wikitty w) {
        Date result = w.getFieldAsDate(EXT_USER, User.FIELD_USER_INSCRIPTIONDATE);
        return result;
    }


    static public void setEnable(Wikitty w, boolean enable) {
        w.setField(EXT_USER, User.FIELD_USER_ENABLE, enable);
    }

    static public boolean getEnable(Wikitty w) {
        boolean result = w.getFieldAsBoolean(EXT_USER, User.FIELD_USER_ENABLE);
        return result;
    }


    static public void setClient(Wikitty w, String client) {
        w.setField(EXT_USER, User.FIELD_USER_CLIENT, client);
    }

    static public String getClient(Wikitty w) {
        String result = w.getFieldAsString(EXT_USER, User.FIELD_USER_CLIENT);
        return result;
    }

    static public java.util.Set<String> getQueries(Wikitty w) {
        java.util.Set<String> result = w.getFieldAsSet(EXT_QUERYMAKER, QueryMaker.FIELD_QUERYMAKER_QUERIES, String.class);
        return result;
    }

    static public void addQueries(Wikitty w, String element) {
        w.addToField(EXT_QUERYMAKER, QueryMaker.FIELD_QUERYMAKER_QUERIES, element);
    }
    
    static public void removeQueries(Wikitty w, String element) {
        w.removeFromField(EXT_QUERYMAKER, QueryMaker.FIELD_QUERYMAKER_QUERIES, element);
    }
    
    static public void clearQueries(Wikitty w) {
        w.clearField(EXT_QUERYMAKER, QueryMaker.FIELD_QUERYMAKER_QUERIES);
    }


    /**
     * Check if wikitty has current extension
     */
    static public boolean isExtension(Wikitty w) {
        boolean result = w.hasExtension(EXT_QUERYMAKER);
        return result;
    }

    /**
     * ajout les extensions static de cette classe au wikitty en argument
     */
    static public void addExtension(Wikitty w) {
        for (WikittyExtension ext : extensions) {
            w.addExtension(ext);
        }
    }

    /**
     * Check equality on all field of this extension, and only those.
     */
    static public boolean equals(Wikitty w1, Wikitty w2) {
        boolean result = true;
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_QUERYMAKER, User.FIELD_USER_NAME);
            Object f2 = w2.getFieldAsObject(EXT_QUERYMAKER, User.FIELD_USER_NAME);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_QUERYMAKER, User.FIELD_USER_SERVICE);
            Object f2 = w2.getFieldAsObject(EXT_QUERYMAKER, User.FIELD_USER_SERVICE);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_QUERYMAKER, User.FIELD_USER_EMAIL);
            Object f2 = w2.getFieldAsObject(EXT_QUERYMAKER, User.FIELD_USER_EMAIL);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_QUERYMAKER, User.FIELD_USER_CREATIONDATE);
            Object f2 = w2.getFieldAsObject(EXT_QUERYMAKER, User.FIELD_USER_CREATIONDATE);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_QUERYMAKER, User.FIELD_USER_VALIDEMAIL);
            Object f2 = w2.getFieldAsObject(EXT_QUERYMAKER, User.FIELD_USER_VALIDEMAIL);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_QUERYMAKER, User.FIELD_USER_ADDRESS);
            Object f2 = w2.getFieldAsObject(EXT_QUERYMAKER, User.FIELD_USER_ADDRESS);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_QUERYMAKER, User.FIELD_USER_PHONE);
            Object f2 = w2.getFieldAsObject(EXT_QUERYMAKER, User.FIELD_USER_PHONE);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_QUERYMAKER, User.FIELD_USER_INSCRIPTIONDATE);
            Object f2 = w2.getFieldAsObject(EXT_QUERYMAKER, User.FIELD_USER_INSCRIPTIONDATE);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_QUERYMAKER, User.FIELD_USER_ENABLE);
            Object f2 = w2.getFieldAsObject(EXT_QUERYMAKER, User.FIELD_USER_ENABLE);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_QUERYMAKER, User.FIELD_USER_CLIENT);
            Object f2 = w2.getFieldAsObject(EXT_QUERYMAKER, User.FIELD_USER_CLIENT);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }

        return result;
    }

} //UserHelper
