package com.jurismarches.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.BusinessEntityWikitty;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyUtil;

public abstract class SendingAbstract extends BusinessEntityWikitty implements Sending {

    private static final long serialVersionUID = 471432792L;

    static final public List<WikittyExtension> extensions;
    static final public WikittyExtension extensionSending =
        new WikittyExtension(EXT_SENDING, "", null,
		    WikittyUtil.buildFieldMapExtension(
				"Date sentDate",
				"Date receptionDate",
				"String paragraph",
				"boolean receptionProof",
				"Numeric status",
				"String messageId",
				"Wikitty form[0-*] unique=true",
				"Wikitty group",
				"Wikitty user",
				"Wikitty client",
				"Wikitty queryMaker",
				"Wikitty deletedForms[0-*] unique=true"));
    static {
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();
        // current after requires ones
        exts.add(extensionSending);

        extensions = Collections.unmodifiableList(exts);
    }

	public SendingAbstract() {
		super();
	}

    public SendingAbstract(BusinessEntityWikitty wi) {
		super(wi.getWikitty());
	}

 	public SendingAbstract(Wikitty wi) {
		super(wi);
	}


    public void setSentDate(Date sentDate) {
        Object oldValue = getField(EXT_SENDING, FIELD_SENDING_SENTDATE);
        getWikitty().setField(EXT_SENDING, FIELD_SENDING_SENTDATE, sentDate);
        getPropertyChangeSupport().firePropertyChange(FIELD_SENDING_SENTDATE, oldValue, sentDate);
    }

    public Date getSentDate() {
        Date result = getWikitty().getFieldAsDate(EXT_SENDING, FIELD_SENDING_SENTDATE);
        return result;
    }


    public void setReceptionDate(Date receptionDate) {
        Object oldValue = getField(EXT_SENDING, FIELD_SENDING_RECEPTIONDATE);
        getWikitty().setField(EXT_SENDING, FIELD_SENDING_RECEPTIONDATE, receptionDate);
        getPropertyChangeSupport().firePropertyChange(FIELD_SENDING_RECEPTIONDATE, oldValue, receptionDate);
    }

    public Date getReceptionDate() {
        Date result = getWikitty().getFieldAsDate(EXT_SENDING, FIELD_SENDING_RECEPTIONDATE);
        return result;
    }


    public void setParagraph(String paragraph) {
        Object oldValue = getField(EXT_SENDING, FIELD_SENDING_PARAGRAPH);
        getWikitty().setField(EXT_SENDING, FIELD_SENDING_PARAGRAPH, paragraph);
        getPropertyChangeSupport().firePropertyChange(FIELD_SENDING_PARAGRAPH, oldValue, paragraph);
    }

    public String getParagraph() {
        String result = getWikitty().getFieldAsString(EXT_SENDING, FIELD_SENDING_PARAGRAPH);
        return result;
    }


    public void setReceptionProof(boolean receptionProof) {
        Object oldValue = getField(EXT_SENDING, FIELD_SENDING_RECEPTIONPROOF);
        getWikitty().setField(EXT_SENDING, FIELD_SENDING_RECEPTIONPROOF, receptionProof);
        getPropertyChangeSupport().firePropertyChange(FIELD_SENDING_RECEPTIONPROOF, oldValue, receptionProof);
    }

    public boolean getReceptionProof() {
        boolean result = getWikitty().getFieldAsBoolean(EXT_SENDING, FIELD_SENDING_RECEPTIONPROOF);
        return result;
    }


    public void setStatus(int status) {
        Object oldValue = getField(EXT_SENDING, FIELD_SENDING_STATUS);
        getWikitty().setField(EXT_SENDING, FIELD_SENDING_STATUS, status);
        getPropertyChangeSupport().firePropertyChange(FIELD_SENDING_STATUS, oldValue, status);
    }

    public int getStatus() {
        int result = getWikitty().getFieldAsInt(EXT_SENDING, FIELD_SENDING_STATUS);
        return result;
    }


    public void setMessageId(String messageId) {
        Object oldValue = getField(EXT_SENDING, FIELD_SENDING_MESSAGEID);
        getWikitty().setField(EXT_SENDING, FIELD_SENDING_MESSAGEID, messageId);
        getPropertyChangeSupport().firePropertyChange(FIELD_SENDING_MESSAGEID, oldValue, messageId);
    }

    public String getMessageId() {
        String result = getWikitty().getFieldAsString(EXT_SENDING, FIELD_SENDING_MESSAGEID);
        return result;
    }

    public Set<String> getForm() {
        Set<String> result = getWikitty().getFieldAsSet(EXT_SENDING, FIELD_SENDING_FORM, String.class);
        return result;
    }

    public void addForm(String element) {
        getWikitty().addToField(EXT_SENDING, FIELD_SENDING_FORM, element);
        getPropertyChangeSupport().firePropertyChange(FIELD_SENDING_FORM, null, getForm());
    }
    
    public void removeForm(String element) {
        getWikitty().removeFromField(EXT_SENDING, FIELD_SENDING_FORM, element);
        getPropertyChangeSupport().firePropertyChange(FIELD_SENDING_FORM, null, getForm());
    }
    
    public void clearForm() {
        getWikitty().clearField(EXT_SENDING, FIELD_SENDING_FORM);
        getPropertyChangeSupport().firePropertyChange(FIELD_SENDING_FORM, null, getForm());
    }


    public void setGroup(String group) {
        Object oldValue = getField(EXT_SENDING, FIELD_SENDING_GROUP);
        getWikitty().setField(EXT_SENDING, FIELD_SENDING_GROUP, group);
        getPropertyChangeSupport().firePropertyChange(FIELD_SENDING_GROUP, oldValue, group);
    }

    public String getGroup() {
        String result = getWikitty().getFieldAsString(EXT_SENDING, FIELD_SENDING_GROUP);
        return result;
    }


    public void setUser(String user) {
        Object oldValue = getField(EXT_SENDING, FIELD_SENDING_USER);
        getWikitty().setField(EXT_SENDING, FIELD_SENDING_USER, user);
        getPropertyChangeSupport().firePropertyChange(FIELD_SENDING_USER, oldValue, user);
    }

    public String getUser() {
        String result = getWikitty().getFieldAsString(EXT_SENDING, FIELD_SENDING_USER);
        return result;
    }


    public void setClient(String client) {
        Object oldValue = getField(EXT_SENDING, FIELD_SENDING_CLIENT);
        getWikitty().setField(EXT_SENDING, FIELD_SENDING_CLIENT, client);
        getPropertyChangeSupport().firePropertyChange(FIELD_SENDING_CLIENT, oldValue, client);
    }

    public String getClient() {
        String result = getWikitty().getFieldAsString(EXT_SENDING, FIELD_SENDING_CLIENT);
        return result;
    }


    public void setQueryMaker(String queryMaker) {
        Object oldValue = getField(EXT_SENDING, FIELD_SENDING_QUERYMAKER);
        getWikitty().setField(EXT_SENDING, FIELD_SENDING_QUERYMAKER, queryMaker);
        getPropertyChangeSupport().firePropertyChange(FIELD_SENDING_QUERYMAKER, oldValue, queryMaker);
    }

    public String getQueryMaker() {
        String result = getWikitty().getFieldAsString(EXT_SENDING, FIELD_SENDING_QUERYMAKER);
        return result;
    }

    public Set<String> getDeletedForms() {
        Set<String> result = getWikitty().getFieldAsSet(EXT_SENDING, FIELD_SENDING_DELETEDFORMS, String.class);
        return result;
    }

    public void addDeletedForms(String element) {
        getWikitty().addToField(EXT_SENDING, FIELD_SENDING_DELETEDFORMS, element);
        getPropertyChangeSupport().firePropertyChange(FIELD_SENDING_DELETEDFORMS, null, getDeletedForms());
    }
    
    public void removeDeletedForms(String element) {
        getWikitty().removeFromField(EXT_SENDING, FIELD_SENDING_DELETEDFORMS, element);
        getPropertyChangeSupport().firePropertyChange(FIELD_SENDING_DELETEDFORMS, null, getDeletedForms());
    }
    
    public void clearDeletedForms() {
        getWikitty().clearField(EXT_SENDING, FIELD_SENDING_DELETEDFORMS);
        getPropertyChangeSupport().firePropertyChange(FIELD_SENDING_DELETEDFORMS, null, getDeletedForms());
    }

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
    }

    /**
     * Check equality on all field of this extension, and only those.
     */
    static public boolean equals(Wikitty w1, Wikitty w2) {
        boolean result = true;
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_SENDING, FIELD_SENDING_SENTDATE);
            Object f2 = w2.getFieldAsObject(EXT_SENDING, FIELD_SENDING_SENTDATE);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_SENDING, FIELD_SENDING_RECEPTIONDATE);
            Object f2 = w2.getFieldAsObject(EXT_SENDING, FIELD_SENDING_RECEPTIONDATE);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_SENDING, FIELD_SENDING_PARAGRAPH);
            Object f2 = w2.getFieldAsObject(EXT_SENDING, FIELD_SENDING_PARAGRAPH);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_SENDING, FIELD_SENDING_RECEPTIONPROOF);
            Object f2 = w2.getFieldAsObject(EXT_SENDING, FIELD_SENDING_RECEPTIONPROOF);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_SENDING, FIELD_SENDING_STATUS);
            Object f2 = w2.getFieldAsObject(EXT_SENDING, FIELD_SENDING_STATUS);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_SENDING, FIELD_SENDING_MESSAGEID);
            Object f2 = w2.getFieldAsObject(EXT_SENDING, FIELD_SENDING_MESSAGEID);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_SENDING, FIELD_SENDING_FORM);
            Object f2 = w2.getFieldAsObject(EXT_SENDING, FIELD_SENDING_FORM);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_SENDING, FIELD_SENDING_GROUP);
            Object f2 = w2.getFieldAsObject(EXT_SENDING, FIELD_SENDING_GROUP);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_SENDING, FIELD_SENDING_USER);
            Object f2 = w2.getFieldAsObject(EXT_SENDING, FIELD_SENDING_USER);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_SENDING, FIELD_SENDING_CLIENT);
            Object f2 = w2.getFieldAsObject(EXT_SENDING, FIELD_SENDING_CLIENT);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_SENDING, FIELD_SENDING_QUERYMAKER);
            Object f2 = w2.getFieldAsObject(EXT_SENDING, FIELD_SENDING_QUERYMAKER);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_SENDING, FIELD_SENDING_DELETEDFORMS);
            Object f2 = w2.getFieldAsObject(EXT_SENDING, FIELD_SENDING_DELETEDFORMS);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }

        return result;
    }

} //SendingAbstract
