package com.jurismarches.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.nuiton.wikitty.BusinessEntityWikitty;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyUtil;

public class ClientHelper extends ClientImpl {

    private static final long serialVersionUID = 1709427468L;


    /**
     * This class is not instanciable, it's just helper
     */
    private ClientHelper() {
    }


    static public void setName(Wikitty w, String name) {
        w.setField(EXT_CLIENT, Client.FIELD_CLIENT_NAME, name);
    }

    static public String getName(Wikitty w) {
        String result = w.getFieldAsString(EXT_CLIENT, Client.FIELD_CLIENT_NAME);
        return result;
    }


    static public void setCreationDate(Wikitty w, Date creationDate) {
        w.setField(EXT_CLIENT, Client.FIELD_CLIENT_CREATIONDATE, creationDate);
    }

    static public Date getCreationDate(Wikitty w) {
        Date result = w.getFieldAsDate(EXT_CLIENT, Client.FIELD_CLIENT_CREATIONDATE);
        return result;
    }


    static public void setAddress(Wikitty w, String address) {
        w.setField(EXT_CLIENT, Client.FIELD_CLIENT_ADDRESS, address);
    }

    static public String getAddress(Wikitty w) {
        String result = w.getFieldAsString(EXT_CLIENT, Client.FIELD_CLIENT_ADDRESS);
        return result;
    }


    static public void setPhone(Wikitty w, String phone) {
        w.setField(EXT_CLIENT, Client.FIELD_CLIENT_PHONE, phone);
    }

    static public String getPhone(Wikitty w) {
        String result = w.getFieldAsString(EXT_CLIENT, Client.FIELD_CLIENT_PHONE);
        return result;
    }


    static public void setContact(Wikitty w, String contact) {
        w.setField(EXT_CLIENT, Client.FIELD_CLIENT_CONTACT, contact);
    }

    static public String getContact(Wikitty w) {
        String result = w.getFieldAsString(EXT_CLIENT, Client.FIELD_CLIENT_CONTACT);
        return result;
    }

    static public java.util.Set<String> getQueries(Wikitty w) {
        java.util.Set<String> result = w.getFieldAsSet(EXT_QUERYMAKER, QueryMaker.FIELD_QUERYMAKER_QUERIES, String.class);
        return result;
    }

    static public void addQueries(Wikitty w, String element) {
        w.addToField(EXT_QUERYMAKER, QueryMaker.FIELD_QUERYMAKER_QUERIES, element);
    }
    
    static public void removeQueries(Wikitty w, String element) {
        w.removeFromField(EXT_QUERYMAKER, QueryMaker.FIELD_QUERYMAKER_QUERIES, element);
    }
    
    static public void clearQueries(Wikitty w) {
        w.clearField(EXT_QUERYMAKER, QueryMaker.FIELD_QUERYMAKER_QUERIES);
    }


    /**
     * Check if wikitty has current extension
     */
    static public boolean isExtension(Wikitty w) {
        boolean result = w.hasExtension(EXT_QUERYMAKER);
        return result;
    }

    /**
     * ajout les extensions static de cette classe au wikitty en argument
     */
    static public void addExtension(Wikitty w) {
        for (WikittyExtension ext : extensions) {
            w.addExtension(ext);
        }
    }

    /**
     * Check equality on all field of this extension, and only those.
     */
    static public boolean equals(Wikitty w1, Wikitty w2) {
        boolean result = true;
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_QUERYMAKER, Client.FIELD_CLIENT_NAME);
            Object f2 = w2.getFieldAsObject(EXT_QUERYMAKER, Client.FIELD_CLIENT_NAME);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_QUERYMAKER, Client.FIELD_CLIENT_CREATIONDATE);
            Object f2 = w2.getFieldAsObject(EXT_QUERYMAKER, Client.FIELD_CLIENT_CREATIONDATE);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_QUERYMAKER, Client.FIELD_CLIENT_ADDRESS);
            Object f2 = w2.getFieldAsObject(EXT_QUERYMAKER, Client.FIELD_CLIENT_ADDRESS);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_QUERYMAKER, Client.FIELD_CLIENT_PHONE);
            Object f2 = w2.getFieldAsObject(EXT_QUERYMAKER, Client.FIELD_CLIENT_PHONE);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_QUERYMAKER, Client.FIELD_CLIENT_CONTACT);
            Object f2 = w2.getFieldAsObject(EXT_QUERYMAKER, Client.FIELD_CLIENT_CONTACT);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }

        return result;
    }

} //ClientHelper
