package com.jurismarches.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.nuiton.wikitty.BusinessEntityWikitty;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyUtil;

public abstract class ClientAbstract extends QueryMakerImpl implements Client, QueryMaker {

    private static final long serialVersionUID = 1709427468L;

    static final public List<WikittyExtension> extensions;
    static final public WikittyExtension extensionClient =
        new WikittyExtension(EXT_CLIENT, "3.0", QueryMaker.EXT_QUERYMAKER,
		    WikittyUtil.buildFieldMapExtension(
				"String name",
				"Date creationDate",
				"String address",
				"String phone",
				"String contact"));
    static {
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.addAll(QueryMakerAbstract.extensions);
        // current after requires ones
        exts.add(extensionClient);

        extensions = Collections.unmodifiableList(exts);
    }

	public ClientAbstract() {
		super();
	}

    public ClientAbstract(BusinessEntityWikitty wi) {
		super(wi.getWikitty());
	}

 	public ClientAbstract(Wikitty wi) {
		super(wi);
	}


    public void setName(String name) {
        Object oldValue = getField(EXT_CLIENT, FIELD_CLIENT_NAME);
        getWikitty().setField(EXT_CLIENT, FIELD_CLIENT_NAME, name);
        getPropertyChangeSupport().firePropertyChange(FIELD_CLIENT_NAME, oldValue, name);
    }

    public String getName() {
        String result = getWikitty().getFieldAsString(EXT_CLIENT, FIELD_CLIENT_NAME);
        return result;
    }


    public void setCreationDate(Date creationDate) {
        Object oldValue = getField(EXT_CLIENT, FIELD_CLIENT_CREATIONDATE);
        getWikitty().setField(EXT_CLIENT, FIELD_CLIENT_CREATIONDATE, creationDate);
        getPropertyChangeSupport().firePropertyChange(FIELD_CLIENT_CREATIONDATE, oldValue, creationDate);
    }

    public Date getCreationDate() {
        Date result = getWikitty().getFieldAsDate(EXT_CLIENT, FIELD_CLIENT_CREATIONDATE);
        return result;
    }


    public void setAddress(String address) {
        Object oldValue = getField(EXT_CLIENT, FIELD_CLIENT_ADDRESS);
        getWikitty().setField(EXT_CLIENT, FIELD_CLIENT_ADDRESS, address);
        getPropertyChangeSupport().firePropertyChange(FIELD_CLIENT_ADDRESS, oldValue, address);
    }

    public String getAddress() {
        String result = getWikitty().getFieldAsString(EXT_CLIENT, FIELD_CLIENT_ADDRESS);
        return result;
    }


    public void setPhone(String phone) {
        Object oldValue = getField(EXT_CLIENT, FIELD_CLIENT_PHONE);
        getWikitty().setField(EXT_CLIENT, FIELD_CLIENT_PHONE, phone);
        getPropertyChangeSupport().firePropertyChange(FIELD_CLIENT_PHONE, oldValue, phone);
    }

    public String getPhone() {
        String result = getWikitty().getFieldAsString(EXT_CLIENT, FIELD_CLIENT_PHONE);
        return result;
    }


    public void setContact(String contact) {
        Object oldValue = getField(EXT_CLIENT, FIELD_CLIENT_CONTACT);
        getWikitty().setField(EXT_CLIENT, FIELD_CLIENT_CONTACT, contact);
        getPropertyChangeSupport().firePropertyChange(FIELD_CLIENT_CONTACT, oldValue, contact);
    }

    public String getContact() {
        String result = getWikitty().getFieldAsString(EXT_CLIENT, FIELD_CLIENT_CONTACT);
        return result;
    }

    public java.util.Set<String> getQueries() {
        java.util.Set<String> result = getWikitty().getFieldAsSet(EXT_QUERYMAKER, FIELD_QUERYMAKER_QUERIES, String.class);
        return result;
    }

    public void addQueries(String element) {
        getWikitty().addToField(EXT_QUERYMAKER, FIELD_QUERYMAKER_QUERIES, element);
        getPropertyChangeSupport().firePropertyChange(FIELD_QUERYMAKER_QUERIES, null, getQueries());
    }
    
    public void removeQueries(String element) {
        getWikitty().removeFromField(EXT_QUERYMAKER, FIELD_QUERYMAKER_QUERIES, element);
        getPropertyChangeSupport().firePropertyChange(FIELD_QUERYMAKER_QUERIES, null, getQueries());
    }
    
    public void clearQueries() {
        getWikitty().clearField(EXT_QUERYMAKER, FIELD_QUERYMAKER_QUERIES);
        getPropertyChangeSupport().firePropertyChange(FIELD_QUERYMAKER_QUERIES, null, getQueries());
    }

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
    }

    /**
     * Check equality on all field of this extension, and only those.
     */
    static public boolean equals(Wikitty w1, Wikitty w2) {
        boolean result = true;
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_QUERYMAKER, FIELD_CLIENT_NAME);
            Object f2 = w2.getFieldAsObject(EXT_QUERYMAKER, FIELD_CLIENT_NAME);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_QUERYMAKER, FIELD_CLIENT_CREATIONDATE);
            Object f2 = w2.getFieldAsObject(EXT_QUERYMAKER, FIELD_CLIENT_CREATIONDATE);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_QUERYMAKER, FIELD_CLIENT_ADDRESS);
            Object f2 = w2.getFieldAsObject(EXT_QUERYMAKER, FIELD_CLIENT_ADDRESS);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_QUERYMAKER, FIELD_CLIENT_PHONE);
            Object f2 = w2.getFieldAsObject(EXT_QUERYMAKER, FIELD_CLIENT_PHONE);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_QUERYMAKER, FIELD_CLIENT_CONTACT);
            Object f2 = w2.getFieldAsObject(EXT_QUERYMAKER, FIELD_CLIENT_CONTACT);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }

        return result;
    }

} //ClientAbstract
