/*
 * Decompiled with CFR 0.152.
 */
package com.herbocailleau.sgq.web.actions.user;

import com.herbocailleau.sgq.business.model.ImportLog;
import com.herbocailleau.sgq.business.services.BatchService;
import com.herbocailleau.sgq.business.services.ConfigurationService;
import com.herbocailleau.sgq.entities.Batch;
import com.herbocailleau.sgq.web.SgqActionSupport;
import java.io.File;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.convention.annotation.Action;

public class BatchReceiveViewAction
extends SgqActionSupport {
    private static final long serialVersionUID = 3074255662512738956L;
    private static final Log log = LogFactory.getLog(BatchReceiveViewAction.class);
    protected long batchsCount;
    protected int nextNonBioBatchNumber;
    protected int nextBioBatchNumber;
    protected File file;
    protected String fileFileName;
    protected List<ImportLog<Batch>> importLogs;

    public String execute() throws Exception {
        ConfigurationService configurationService = (ConfigurationService)this.newService(ConfigurationService.class);
        this.nextNonBioBatchNumber = configurationService.getNextNonBioBatchNumber();
        this.nextBioBatchNumber = configurationService.getNextBioBatchNumber();
        return "success";
    }

    public long getBatchsCount() {
        return this.batchsCount;
    }

    public int getNextNonBioBatchNumber() {
        return this.nextNonBioBatchNumber;
    }

    public int getNextBioBatchNumber() {
        return this.nextBioBatchNumber;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setFileFileName(String fileFileName) {
        this.fileFileName = fileFileName;
    }

    @Action(value="batch-receive-import")
    public String importBatch() throws Exception {
        String result = "success";
        if (this.file == null) {
            result = this.input();
        } else {
            BatchService batchService = (BatchService)this.newService(BatchService.class);
            try {
                this.importLogs = batchService.importBatchFile(this.fileFileName, this.file);
            }
            catch (Exception ex) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Can't import batch file", (Throwable)ex);
                }
                this.addActionError(ex.getMessage());
                result = this.input();
            }
        }
        return result;
    }

    public List<ImportLog<Batch>> getImportLogs() {
        return this.importLogs;
    }
}

