/*
 * #%L
 * SGQ :: Web
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */
/**
 * Duplication du premier element fils de l'element root fourni.
 */
function addFilePart(rootElement) {
	refItem = rootElement.children().first();
	rootElement.append(refItem.clone());
}

/**
 * Configure les champs sgqdatefield sous forme de date picker jquery.
 */
function initDatePickers() {
	$(".sgqdatefield").datepicker($.datepicker.regional["fr"]);
}

/**
 * Hack pour la securité (cache les entrées vide).
 */
function hideEmptySubMenu() {
	$('#sgq-menu .sgq-submenu:not(:has(ul li))').remove();
}

/**
 * Initialize les tooltips du sgq.
 */
function initTooltip() {
	$(document).tooltip({
	    content: function() {
	        return $(this).attr('title').replace(/\n/g, '<br />');
	    }
	});
}

/**
 * Affiche un message de confirmation pour les liens de suppression.
 */
function initConfirmMessages() {
	// pour le sgq
	$('.sgq-confirm-delete').click(function(){
		return confirm('Êtes vous sûr de vouloir supprimer cet élément ?');
	});
	// pour la partie sécurité
	$('.security-div .delete').click(function(){
		return confirm('Êtes vous sûr de vouloir supprimer cet élément ?');
	});
}

/**
 * Modifie le champ date receiptElement des la modification du champ
 * sendElement.
 * 
 * @param sendElement
 * @param receiptElement
 * @param dayCount
 */
function updateReceiptDate(sendElement, receiptElement, dayCount) {
	//var date = $.datepicker.parseDate('dd/MM/yyyy', $(sendElement).val());
	var date = $(sendElement).datepicker('getDate');
	date.setDate(date.getDate() + dayCount);
	$(receiptElement).datepicker('setDate', date);
}

/**
 * Verifie que dans le formulaire de gestion des analyses, les dates de receiption
 * sont bien postérieure aux dates d'envoi.
 * 
 * @param formElement
 */
function checkSendAndReceiptDates(formElement) {
	var result = true;
	$(formElement).find('input[name^="sentDate."]').each(function(index) {
		sentDate = $(this).datepicker('getDate');
		receiptElement = $(this).parent().parent().find('input[name^="receiveDate."]').first();
		receiveDate = $(receiptElement).datepicker('getDate');
		if (sentDate > receiveDate) {
			analyzeElement = $(this).parent().parent().children(".analyze").text();
			batchElement = $(this).parent().parent().children(".batch").text();
			productElement = $(this).parent().parent().children(".product").text();
			alert("Les dates de l'analyse " + analyzeElement + " du lot " +
					batchElement + "(" + productElement + ") ne sont pas coh\u00E9rentes !");
			result = false;
		}
	});
	return result;
}

/**
 * Init jquery.
 */
$(document).ready(function() {
	initDatePickers();
	initConfirmMessages();
	hideEmptySubMenu();
	initTooltip();
});