<%--
  #%L
  SGQ :: Web
  $Id:$
  $HeadURL:$
  %%
  Copyright (C) 2012 Herboristerie Cailleau
  %%
  Herboristerie Cailleau - Tous droits réservés
  #L%
  --%>
<%@ page language="java" contentType="text/html; charset=utf-8" pageEncoding="utf-8"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<%@taglib uri="/struts-tags" prefix="s" %>
<%@taglib uri="http://shiro.apache.org/tags" prefix="shiro" %>
<html xmlns="http://www.w3.org/1999/xhtml">
    <head>
       <title>Gestion étiquettes</title>
    </head>
    <body>
    	<h1>Gestion étiquettes</h1>

		Reprise du fichier gestion étiquette du site à partir de la date du dernier import:
        <ul>
            <li>fabrication (FIF_HIST.txt) :
                <s:if test="productionStartDate != null">
                  <s:text name="sgq.web.common.dateformat">
                    <s:param value="productionStartDate"/>
                  </s:text>
                </s:if>
                <s:else>
                  <em>Aucun import présent en base de données</em>
                </s:else>
            </li>
            <li>expédition (FIC_HIST.txt) :
                <s:if test="expeditionStartDate != null">
                  <s:text name="sgq.web.common.dateformat">
                    <s:param value="expeditionStartDate"/>
                  </s:text>
                </s:if>
                <s:else>
                  <em>Aucun import présent en base de données</em>
                </s:else>
            </li>
        </ul>

    	<h2>Import du fichier gestion étiquettes</h2>

        <div class="notetip">
          <ul>
            <li><em>Nom attendu</em> : <tt>FIF_HIST.txt</tt> pour le fichier fabrication, <tt>FIC_HIST.txt</tt> pour le fichier expédition</li>
            <li><em>Format attendu</em> : fichier <em>TXT</em> encodé en <em>UTF-8</em> (unicode) utilisant le séparateur <tt>,</tt></li>
            <li><em>Contenu attendu</em> : <tt>D,xxxxxxxx,B,xxxxxx,C,xxxxx,P,xxxxxx,L,xxxxx,Q,xx.xxx,R,xxxxx</tt> (la partie <tt>R,xxxxx</tt> est optionnelle)</li>
          </ul>
        </div>

        <form action='<s:url action="label-import" />' method="post" enctype="multipart/form-data">
           <s:actionerror />

           <s:if test="batchMaxEntryDate != null">
           <p>
             <span class="errorMessage">L'import du fichier FIF_REC.DBF est supérieur à 5 jour (<s:text name="sgq.web.common.dateformat">
                    <s:param value="batchMaxEntryDate"/>
                  </s:text>)</span><br />
             <label><input type="checkbox" name="forceImport" value="true" />
             Ignorer cet avertissement et forcer l'importation du fichier</label></p>
           </s:if>

           <p>Fichier : <input type="file" name="file" /></p>
           <p><input type="submit" value="Importer" /></p>
        </form>

        <shiro:hasPermission name="label:error">
          <h2>Gestion des erreurs</h2>
          <ul>
            <s:if test="labelErrorCount > 0">
              <li class="errorMessage">
                <a href="<s:url action="label-error" />">Traiter les <s:property value="labelErrorCount" /> erreurs étiquettes en attentes !</a>
              </li>
            </s:if>
            <s:else>
              <li><em>Aucune erreur en attente</em></li>
            </s:else>
            <li><a href="<s:url action="label-history" />">Consulter l'historique des corrections des erreurs étiquettes</a></li>
          </ul>
        </shiro:hasPermission>
    </body>
</html>
