<%--
  #%L
  SGQ :: Web
  $Id:$
  $HeadURL:$
  %%
  Copyright (C) 2012 Herboristerie Cailleau
  %%
  Herboristerie Cailleau - Tous droits réservés
  #L%
  --%>
<%@ page language="java" contentType="text/html; charset=utf-8" pageEncoding="utf-8"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<%@taglib uri="/struts-tags" prefix="s" %>
<%@taglib uri="http://shiro.apache.org/tags" prefix="shiro" %>
<html xmlns="http://www.w3.org/1999/xhtml">
    <head>
       <title>Référentiel produits</title>
       
       <script type="text/javascript">
         $(document).ready(function() {
           $('.sgq-confirm-archive').click(function(){
      	     return confirm('Êtes vous sûr de vouloir archiver ce produit ?');
      	   });
         });
       </script>
    </head>
    <body>
    	<h1>Référentiel produits</h1>

        <s:set name="advanced" value="true" />
        <s:if test='%{product.topiaId != null}'>
    	   <h2>Modification d'un produit</h2>
           <shiro:lacksPermission name="product:write:refs">
             <s:set name="advanced" value="false" />
           </shiro:lacksPermission>
        </s:if>
        <s:else>
           <h2>Nouveau produit</h2>
        </s:else>
    	
    	<s:form action='product-edit' namespace='/admin' method="post">
           <s:actionerror />

           <s:hidden name="productId" value="%{product.topiaId}" />
           <s:if test="#advanced">
             <s:textfield key="Code" name="product.code" value="%{product.code}" labelposition="left" size="40" />
             <s:textfield key="Nom" name="product.name" value="%{product.name}" labelposition="left" size="40" />
             <tr>
               <td>Catégorie :</td>
               <td>
                 <select name="product.category">
                   <s:iterator value="categories" var="category">
                     <option value="<s:property value="#category" />"
                       <s:if test="#category.equals(product.category)">selected="selected"</s:if>><s:property /></option>
                   </s:iterator>
                 </select>
                 <img src="<s:url value="/img/info.png" />" title="Liste des catégories actuellement utilisées par les autres produits. Pour supprimer un produit de cette liste, il suffit que plus aucun produit ne l'utilise." />
               </td>
             </tr>
             <tr>
               <td />
               <td>
                 <label>Nouvelle catégorie :</label>
                 <input type="text" name="productCategoryName" value="<s:property value="productCategoryName" />" size="40" /></td>
             </tr>
             <s:textfield key="Nom latin" name="product.latinName" value="%{product.latinName}" size="40" labelposition="left" />
           </s:if>
           <s:else>
             <tr>
               <td>Code :</td><td><s:property value="product.code"/></td>
             </tr>
             <tr>
               <td>Nom :</td><td><s:property value="product.name"/></td>
             </tr>
             <tr>
               <td>Catégorie :</td><td><s:property value="product.category"/></td>
             </tr>
             <tr>
               <td>Nom latin :</td><td><s:property value="product.latinName"/></td>
             </tr>
           </s:else>
           <s:textfield key="Famille" name="product.family" value="%{product.family}" labelposition="left" size="40" />

           <s:checkboxlist key="Statuts" name="productStatusIds" list="status"
                listKey="topiaId" listValue="name" value="%{product.productStatus}" labelposition="left" />
           <tr>
             <td />
             <td>
               <label>Nouveau statut :</label>
               <input type="text" name="productStatusName" value="<s:property value="productStatusName" />" size="40" /></td>
           </tr>

           <s:checkboxlist key="Analyses" name="analyzeTypeIds" list="analyzeTypes"
                listKey="topiaId" listValue="name" value="%{product.analyzeType}" labelposition="left" />
           <s:checkbox key="Contrôle botanique" name="product.botanicControl"
                value="%{product.botanicControl}" labelposition="left"/>
           <s:checkbox key="Contrôle identification" name="product.identificationControl"
                value="%{product.identificationControl}" labelposition="left"/>
           <s:textarea key="Commentaire" name="product.comment" value="%{product.comment}"
                rows="10" cols="100" labelposition="left" />
           <s:submit value="Valider" />
        </s:form>
        
        <s:if test='product.topiaId != null'>
          <shiro:hasPermission name="product:write:refs">
            <h2>Divers</h2>
            <ul>
            <s:if test="product.archived">
              <li><a href="<s:url action="product-unarchive">
                <s:param name="productId"><s:property value="product.topiaId" /></s:param>
              </s:url>">Remettre en service ce produit</a></li>
            </s:if>
            <s:elseif test="canBeArchived">
              <li><a href="<s:url action="product-archive">
                <s:param name="productId"><s:property value="product.topiaId" /></s:param>
              </s:url>" class="sgq-confirm-archive">Archiver ce produit</a></li>
            </s:elseif>
            <s:else>
              <li><em>Archivage du produit impossible car il est actuellement utilisé par des lots non expirés.</em></li>
            </s:else>
            <s:if test="canBeDeleted">
              <li><a href="<s:url action="product-delete">
                <s:param name="productId"><s:property value="product.topiaId" /></s:param>
              </s:url>" class="sgq-confirm-delete">Supprimer ce produit</a></li>
            </s:if>
            <s:else>
              <li><em>Suppression du produit impossible car il est actuellement utilisé.</em></li>
            </s:else>
            </ul>
          </shiro:hasPermission>
        </s:if>
    </body>
</html>
