/*
 * Decompiled with CFR 0.152.
 */
package com.herbocailleau.sgq.web.actions.user;

import com.herbocailleau.sgq.business.SgqUtils;
import com.herbocailleau.sgq.business.model.BatchModel;
import com.herbocailleau.sgq.business.model.SearchModel;
import com.herbocailleau.sgq.business.services.BatchService;
import com.herbocailleau.sgq.business.services.ReferentialService;
import com.herbocailleau.sgq.entities.AnalyzeType;
import com.herbocailleau.sgq.entities.ProductStatus;
import com.herbocailleau.sgq.web.SgqActionSupport;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.nuiton.util.PagerBean;

public class SearchResultAction
extends SgqActionSupport {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(SearchResultAction.class);
    protected ReferentialService referentialService;
    protected SearchModel search;
    protected List<BatchModel> batchModels;
    protected List<ProductStatus> productStatuses;
    protected List<String> productCategories;
    protected List<AnalyzeType> analyzeTypes;
    protected PagerBean pager;
    protected int page;

    public SearchModel getSearch() {
        if (this.search == null) {
            this.search = new SearchModel();
        }
        return this.search;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public void parseParameters() throws Exception {
        this.referentialService = (ReferentialService)this.newService(ReferentialService.class);
        String[] productStatusIds = this.getParameters("search_productStatus");
        ArrayList<ProductStatus> productStatus = new ArrayList<ProductStatus>();
        if (productStatusIds != null) {
            for (String productStatusId : productStatusIds) {
                productStatus.add(this.referentialService.getProductStatusById(productStatusId));
            }
        }
        this.getSearch().setProductStatus(productStatus);
        String[] analyzeTypeIds = this.getParameters("search_analyzeType");
        ArrayList<AnalyzeType> types = new ArrayList<AnalyzeType>();
        if (analyzeTypeIds != null) {
            for (String analyzeTypeId : analyzeTypeIds) {
                types.add(this.referentialService.findAnalyzeTypeById(analyzeTypeId));
            }
        }
        this.getSearch().setAnalyzeTypes(types);
        String dateBegin = this.getParameter("search_beginDate");
        try {
            if (StringUtils.isNotBlank((CharSequence)dateBegin)) {
                this.getSearch().setBeginDate(SgqUtils.parseSgqDate((String)dateBegin));
            }
        }
        catch (ParseException ex) {
            this.addActionError("Impossible de parser la date " + dateBegin);
        }
        String dateEnd = this.getParameter("search_endDate");
        try {
            if (StringUtils.isNotBlank((CharSequence)dateEnd)) {
                this.getSearch().setEndDate(SgqUtils.parseSgqDate((String)dateEnd));
            }
        }
        catch (ParseException ex) {
            this.addActionError("Impossible de parser la date " + dateEnd);
        }
    }

    public String execute() throws Exception {
        this.parseParameters();
        this.productStatuses = this.referentialService.findAllProductStatus();
        this.productCategories = this.referentialService.findAllProductCategories();
        this.analyzeTypes = this.referentialService.findAllAnalyzeTypes();
        BatchService batchService = (BatchService)this.newService(BatchService.class);
        Pair searchResult = batchService.searchBatch(this.getSearch(), this.page * 20, 20);
        this.batchModels = (List)searchResult.getKey();
        long totalCount = (Long)searchResult.getValue();
        this.pager = this.getPager(this.page, 20, totalCount);
        return "success";
    }

    public List<BatchModel> getBatchModels() {
        return this.batchModels;
    }

    public List<ProductStatus> getProductStatuses() {
        return this.productStatuses;
    }

    public List<String> getProductCategories() {
        return this.productCategories;
    }

    public List<AnalyzeType> getAnalyzeTypes() {
        return this.analyzeTypes;
    }

    public PagerBean getPager() {
        return this.pager;
    }

    @Action(value="search-export", results={@Result(type="stream", params={"contentType", "text/csv", "inputName", "inputStream", "contentDisposition", "attachment; filename=\"${filename}\""})})
    public String export() throws Exception {
        this.parseParameters();
        return "success";
    }

    public InputStream getInputStream() {
        InputStream result;
        block2: {
            BatchService batchService = (BatchService)this.newService(BatchService.class);
            result = null;
            try {
                result = batchService.searchBatchASCsv(this.search);
            }
            catch (Exception ex) {
                if (!log.isErrorEnabled()) break block2;
                log.error((Object)"Can't get csv stream", (Throwable)ex);
            }
        }
        return result;
    }

    public String getFilename() {
        return "search.csv";
    }
}

