/*
 * Decompiled with CFR 0.152.
 */
package com.herbocailleau.sgq.web.actions.user;

import com.herbocailleau.sgq.business.SgqUtils;
import com.herbocailleau.sgq.business.services.BatchService;
import com.herbocailleau.sgq.business.services.ReferentialService;
import com.herbocailleau.sgq.entities.BatchAnalyze;
import com.herbocailleau.sgq.entities.Supplier;
import com.herbocailleau.sgq.entities.SynthesisMention;
import com.herbocailleau.sgq.web.SgqActionSupport;
import com.opensymphony.xwork2.Preparable;
import java.io.File;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

public class AnalyzeReceiptAction
extends SgqActionSupport
implements Preparable {
    private static final long serialVersionUID = 3074255662512738956L;
    protected ReferentialService referentialService;
    protected BatchService batchService;
    protected String analyzeId;
    protected BatchAnalyze analyze;
    protected List<Supplier> suppliers;
    protected String supplierId;
    protected String receiptDate;
    protected SynthesisMention mention;
    protected String synthesis;
    protected List<File> files;
    protected List<String> filesFileName;

    public void setAnalyzeId(String analyzeId) {
        this.analyzeId = analyzeId;
    }

    public void prepare() throws Exception {
        this.referentialService = (ReferentialService)this.newService(ReferentialService.class);
        this.batchService = (BatchService)this.newService(BatchService.class);
    }

    public String input() throws Exception {
        this.analyze = this.batchService.getAnalyzeById(this.analyzeId);
        this.suppliers = this.referentialService.getAllSupplierOnlyLabs();
        return super.input();
    }

    public BatchAnalyze getAnalyze() {
        return this.analyze;
    }

    public List<Supplier> getSuppliers() {
        return this.suppliers;
    }

    public void setFiles(List<File> files) {
        this.files = files;
    }

    public void setFilesFileName(List<String> filesFileName) {
        this.filesFileName = filesFileName;
    }

    public void setReceiptDate(String receiptDate) {
        this.receiptDate = receiptDate;
    }

    public void setMention(SynthesisMention mention) {
        this.mention = mention;
    }

    public void setSupplierId(String supplierId) {
        this.supplierId = supplierId;
    }

    public void setSynthesis(String synthesis) {
        this.synthesis = synthesis;
    }

    public Date getNow() {
        return new Date();
    }

    @Action(results={@Result(name="success", type="redirectAction", params={"actionName", "analyze-dashboard"}), @Result(name="toAnalyze", type="redirectAction", params={"actionName", "batch-analyze-view", "analyzeId", "${analyze.topiaId}"})})
    public String execute() throws Exception {
        String result = "success";
        try {
            this.analyze = this.batchService.getAnalyzeById(this.analyzeId);
            Date receiptDateDate = SgqUtils.parseSgqDate((String)this.receiptDate);
            if (receiptDateDate.before(this.analyze.getSentDate())) {
                this.addActionError("La date de r\u00e9ception ne peut pas \u00eatre ant\u00e9rieure \u00e0 la date d'envoi de l'analyse !");
                result = this.input();
            } else {
                Supplier supplier = this.referentialService.getSupplierById(this.supplierId);
                this.analyze.setSynthesisMention(this.mention);
                this.analyze.setSynthesis(this.synthesis);
                if (this.analyze.getReceiptDate() != null) {
                    result = "toAnalyze";
                }
                this.analyze.setReceiptDate(receiptDateDate);
                this.batchService.receiveAnalyzeFromSupplier(this.analyze, supplier);
                if (this.files != null) {
                    for (int i = 0; i < this.files.size(); ++i) {
                        File file = (File)this.files.get(i);
                        String fileName = (String)this.filesFileName.get(i);
                        this.batchService.addAnalyzeFile(null, this.analyze, fileName, file);
                    }
                }
            }
        }
        catch (ParseException ex) {
            this.addActionError("Format de date invalide : dd/MM/yyyy !");
            result = this.input();
        }
        return result;
    }
}

