/*
 * Decompiled with CFR 0.152.
 */
package com.herbocailleau.sgq.web.actions.user;

import com.herbocailleau.sgq.business.services.BatchService;
import com.herbocailleau.sgq.business.services.ReferentialService;
import com.herbocailleau.sgq.entities.AnalyzeCategory;
import com.herbocailleau.sgq.entities.AnalyzeType;
import com.herbocailleau.sgq.entities.Batch;
import com.herbocailleau.sgq.web.SgqActionSupport;
import com.opensymphony.xwork2.Preparable;
import java.util.List;
import org.apache.commons.collections.map.MultiKeyMap;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

public class AnalyzePrepareAction
extends SgqActionSupport
implements Preparable {
    private static final long serialVersionUID = 3074255662512738956L;
    protected BatchService batchService;
    protected ReferentialService referentialService;
    protected int startNumber;
    protected int endNumber;
    protected List<Batch> batches;
    protected MultiKeyMap existingAnalyzes;
    protected List<AnalyzeCategory> analyzeCategories;
    protected List<String> batchIds;

    public void setStartNumber(int startNumber) {
        this.startNumber = startNumber;
    }

    public int getStartNumber() {
        return this.startNumber;
    }

    public void setEndNumber(int endNumber) {
        this.endNumber = endNumber;
    }

    public int getEndNumber() {
        return this.endNumber;
    }

    public void prepare() throws Exception {
        this.batchService = (BatchService)this.newService(BatchService.class);
        this.referentialService = (ReferentialService)this.newService(ReferentialService.class);
    }

    public String input() throws Exception {
        if (this.startNumber != 0 && this.endNumber != 0) {
            this.batches = this.batchService.findAllBetweenNumbers(this.startNumber, this.endNumber);
            this.existingAnalyzes = this.batchService.findAllAnalyzesBetweenBatchNumbers(this.startNumber, this.endNumber);
            this.analyzeCategories = this.referentialService.findAllAnalyzeCategories();
        }
        return super.input();
    }

    public List<Batch> getBatches() {
        return this.batches;
    }

    public MultiKeyMap getExistingAnalyzes() {
        return this.existingAnalyzes;
    }

    public List<AnalyzeCategory> getAnalyzeCategories() {
        return this.analyzeCategories;
    }

    public void setBatchIds(List<String> batchIds) {
        this.batchIds = batchIds;
    }

    @Action(results={@Result(type="redirectAction", params={"actionName", "analyze-dashboard"})})
    public String execute() throws Exception {
        String result = null;
        if (this.batchIds == null) {
            result = this.input();
        } else {
            for (String batchId : this.batchIds) {
                Batch batch = this.batchService.getBatchById(batchId);
                String[] analyzeTypeIds = this.getParameters("analyzeType." + batch.getTopiaId());
                if (analyzeTypeIds != null) {
                    for (String analyzeTypeId : analyzeTypeIds) {
                        AnalyzeType analyzeType = this.referentialService.findAnalyzeTypeById(analyzeTypeId);
                        this.batchService.prepareAnalyze(batch, analyzeType);
                    }
                }
                result = "success";
            }
        }
        return result;
    }
}

