/*
 * Decompiled with CFR 0.152.
 */
package com.herbocailleau.sgq.web.actions.admin;

import com.herbocailleau.sgq.business.model.ProductSearchModel;
import com.herbocailleau.sgq.business.services.ReferentialService;
import com.herbocailleau.sgq.entities.AnalyzeType;
import com.herbocailleau.sgq.entities.Product;
import com.herbocailleau.sgq.entities.ProductStatus;
import com.herbocailleau.sgq.web.SgqActionSupport;
import com.opensymphony.xwork2.Preparable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.nuiton.util.PagerBean;

public class ProductListAction
extends SgqActionSupport
implements Preparable {
    private static final long serialVersionUID = 5564446302091087009L;
    private static final Log log = LogFactory.getLog(ProductListAction.class);
    protected ReferentialService referentialService;
    protected ProductSearchModel search;
    protected List<ProductStatus> productStatuses;
    protected List<AnalyzeType> analyzeTypes;
    protected List<String> productCategories;
    protected int page;
    protected PagerBean pager;
    protected List<Product> products;

    public ProductSearchModel getSearch() {
        if (this.search == null) {
            this.search = new ProductSearchModel();
        }
        return this.search;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public void prepare() throws Exception {
        this.referentialService = (ReferentialService)this.newService(ReferentialService.class);
        String[] productStatusIds = this.getParameters("search.productStatusId");
        ArrayList<ProductStatus> productStatus = new ArrayList<ProductStatus>();
        if (productStatusIds != null) {
            for (String productStatusId : productStatusIds) {
                productStatus.add(this.referentialService.getProductStatusById(productStatusId));
            }
        }
        this.getSearch().setProductStatus(productStatus);
        String[] analyzeTypeIds = this.getParameters("search.analyzeTypeId");
        ArrayList<AnalyzeType> analyzeTypes = new ArrayList<AnalyzeType>();
        if (analyzeTypeIds != null) {
            for (String analyzeTypeId : analyzeTypeIds) {
                analyzeTypes.add(this.referentialService.findAnalyzeTypeById(analyzeTypeId));
            }
        }
        this.getSearch().setAnalyzeTypes(analyzeTypes);
    }

    public String execute() throws Exception {
        this.productStatuses = this.referentialService.findAllProductStatus();
        this.analyzeTypes = this.referentialService.findAllAnalyzeTypes();
        this.productCategories = this.referentialService.findAllProductCategories();
        Pair result = this.referentialService.getProducts(this.getSearch(), 20 * this.page, 20);
        this.products = (List)result.getKey();
        long totalCount = (Long)result.getValue();
        this.pager = this.getPager(this.page, 20, totalCount);
        return "success";
    }

    public List<AnalyzeType> getAnalyzeTypes() {
        return this.analyzeTypes;
    }

    public List<ProductStatus> getProductStatuses() {
        return this.productStatuses;
    }

    public List<String> getProductCategories() {
        return this.productCategories;
    }

    public PagerBean getPager() {
        return this.pager;
    }

    public List<Product> getProducts() {
        return this.products;
    }

    @Action(value="product-export", results={@Result(type="stream", params={"contentType", "text/csv", "inputName", "inputStream", "contentDisposition", "attachment; filename=\"${filename}\""})})
    public String export() throws Exception {
        return "success";
    }

    public InputStream getInputStream() {
        InputStream result;
        block2: {
            result = null;
            try {
                result = this.referentialService.getProductsAsCsv(this.getSearch());
            }
            catch (Exception ex) {
                if (!log.isErrorEnabled()) break block2;
                log.error((Object)"Can't get csv stream", (Throwable)ex);
            }
        }
        return result;
    }

    public String getFilename() {
        return "produits.csv";
    }
}

