/*
 * Decompiled with CFR 0.152.
 */
package android.support.wearable.watchface;

import android.annotation.TargetApi;
import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.IBinder;
import android.os.PowerManager;
import android.os.RemoteException;
import android.service.wallpaper.WallpaperService;
import android.support.wearable.watchface.IWatchFaceService;
import android.support.wearable.watchface.WatchFaceStyle;
import android.util.Log;
import android.view.SurfaceHolder;

@TargetApi(value=21)
public abstract class WatchFaceService
extends WallpaperService {
    private static final String TAG = "WatchFaceService";
    public static final String COMMAND_AMBIENT_UPDATE = "com.google.android.wearable.action.AMBIENT_UPDATE";
    public static final String COMMAND_BACKGROUND_ACTION = "com.google.android.wearable.action.BACKGROUND_ACTION";
    public static final String COMMAND_SET_PROPERTIES = "com.google.android.wearable.action.SET_PROPERTIES";
    public static final String COMMAND_SET_BINDER = "com.google.android.wearable.action.SET_BINDER";
    public static final String COMMAND_REQUEST_STYLE = "com.google.android.wearable.action.REQUEST_STYLE";
    public static final String ACTION_REQUEST_STATE = "com.google.android.wearable.watchfaces.action.REQUEST_STATE";
    public static final String EXTRA_CARD_LOCATION = "card_location";
    public static final String EXTRA_AMBIENT_MODE = "ambient_mode";
    public static final String EXTRA_INTERRUPTION_FILTER = "interruption_filter";
    public static final String EXTRA_UNREAD_COUNT = "unread_count";
    public static final String EXTRA_BINDER = "binder";
    public static final String PROPERTY_BURN_IN_PROTECTION = "burn_in_protection";
    public static final String PROPERTY_LOW_BIT_AMBIENT = "low_bit_ambient";
    public static final int INTERRUPTION_FILTER_ALL = 1;
    public static final int INTERRUPTION_FILTER_PRIORITY = 2;
    public static final int INTERRUPTION_FILTER_NONE = 3;
    private static final long SURFACE_DRAW_TIMEOUT_MS = 100L;

    public abstract Engine onCreateEngine();

    public abstract class Engine
    extends WallpaperService.Engine {
        private final IntentFilter mTimeTickFilter;
        private final BroadcastReceiver mTimeTickReceiver;
        private boolean mTimeTickRegistered;
        private IWatchFaceService mWatchFaceService;
        private WatchFaceStyle mWatchFaceStyle;
        private WatchFaceStyle mLastWatchFaceStyle;
        private boolean mInAmbientMode;
        private int mInterruptionFilter;
        private int mUnreadCount;
        private final Rect mPeekCardPosition;
        private PowerManager.WakeLock mWakeLock;

        public Engine() {
            super((WallpaperService)WatchFaceService.this);
            this.mTimeTickFilter = new IntentFilter("android.intent.action.TIME_TICK");
            this.mTimeTickReceiver = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    if (Log.isLoggable((String)WatchFaceService.TAG, (int)3)) {
                        Log.d((String)WatchFaceService.TAG, (String)"Received time tick.");
                    }
                    Engine.this.onTimeTick();
                }
            };
            this.mTimeTickRegistered = false;
            this.mPeekCardPosition = new Rect(0, 0, 0, 0);
        }

        public Bundle onCommand(String action, int x, int y, int z, Bundle extras, boolean resultRequested) {
            if (Log.isLoggable((String)WatchFaceService.TAG, (int)3)) {
                Log.d((String)WatchFaceService.TAG, (String)("received command: " + action));
            }
            if (WatchFaceService.COMMAND_BACKGROUND_ACTION.equals(action)) {
                this.maybeUpdateAmbientMode(extras);
                this.maybeUpdateInterruptionFilter(extras);
                this.maybeUpdatePeekCardPosition(extras);
                this.maybeUpdateUnreadCount(extras);
            } else if (WatchFaceService.COMMAND_AMBIENT_UPDATE.equals(action)) {
                if (this.mInAmbientMode) {
                    if (Log.isLoggable((String)WatchFaceService.TAG, (int)3)) {
                        Log.d((String)WatchFaceService.TAG, (String)"ambient mode update");
                    }
                    this.mWakeLock.acquire();
                    this.onTimeTick();
                    this.mWakeLock.acquire(100L);
                }
            } else if (WatchFaceService.COMMAND_SET_PROPERTIES.equals(action)) {
                this.onPropertiesChanged(extras);
            } else if (WatchFaceService.COMMAND_SET_BINDER.equals(action)) {
                this.onSetBinder(extras);
            } else if (WatchFaceService.COMMAND_REQUEST_STYLE.equals(action)) {
                if (this.mLastWatchFaceStyle != null) {
                    this.setWatchFaceStyle(this.mLastWatchFaceStyle);
                } else if (Log.isLoggable((String)WatchFaceService.TAG, (int)3)) {
                    Log.d((String)WatchFaceService.TAG, (String)"Last watch face style is null.");
                }
            }
            return null;
        }

        private void onSetBinder(Bundle extras) {
            IBinder binder = extras.getBinder(WatchFaceService.EXTRA_BINDER);
            if (binder != null) {
                this.mWatchFaceService = IWatchFaceService.Stub.asInterface(binder);
                if (this.mWatchFaceStyle != null) {
                    try {
                        this.mWatchFaceService.setStyle(this.mWatchFaceStyle);
                        this.mWatchFaceStyle = null;
                    }
                    catch (RemoteException e) {
                        Log.w((String)WatchFaceService.TAG, (String)"Failed to set WatchFaceStyle", (Throwable)e);
                    }
                }
            } else {
                Log.w((String)WatchFaceService.TAG, (String)"Binder is null.");
            }
        }

        public void setWatchFaceStyle(WatchFaceStyle watchFaceStyle) {
            if (Log.isLoggable((String)WatchFaceService.TAG, (int)3)) {
                Log.d((String)WatchFaceService.TAG, (String)("setWatchFaceStyle " + watchFaceStyle));
            }
            this.mWatchFaceStyle = watchFaceStyle;
            this.mLastWatchFaceStyle = watchFaceStyle;
            if (this.mWatchFaceService != null) {
                try {
                    this.mWatchFaceService.setStyle(watchFaceStyle);
                    this.mWatchFaceStyle = null;
                }
                catch (RemoteException e) {
                    Log.e((String)WatchFaceService.TAG, (String)"Failed to set WatchFaceStyle: ", (Throwable)e);
                }
            }
        }

        public void onAmbientModeChanged(boolean inAmbientMode) {
        }

        public void onInterruptionFilterChanged(int interruptionFilter) {
        }

        public void onPeekCardPositionUpdate(Rect rect) {
        }

        public void onUnreadCountChanged(int count) {
        }

        public void onPropertiesChanged(Bundle properties) {
        }

        public void onTimeTick() {
        }

        public void onCreate(SurfaceHolder holder) {
            super.onCreate(holder);
            this.mWatchFaceStyle = new WatchFaceStyle.Builder((Service)WatchFaceService.this).build();
            this.mWakeLock = ((PowerManager)WatchFaceService.this.getSystemService("power")).newWakeLock(1, WatchFaceService.TAG);
            this.mWakeLock.setReferenceCounted(false);
        }

        public void onVisibilityChanged(boolean visible) {
            super.onVisibilityChanged(visible);
            if (Log.isLoggable((String)WatchFaceService.TAG, (int)3)) {
                Log.d((String)WatchFaceService.TAG, (String)("onVisibilityChanged: " + visible));
            }
            Intent intent = new Intent(WatchFaceService.ACTION_REQUEST_STATE);
            WatchFaceService.this.sendBroadcast(intent);
        }

        public final boolean isInAmbientMode() {
            return this.mInAmbientMode;
        }

        public final int getInterruptionFilter() {
            return this.mInterruptionFilter;
        }

        public final int getUnreadCount() {
            return this.mUnreadCount;
        }

        public final Rect getPeekCardPosition() {
            return this.mPeekCardPosition;
        }

        private void maybeUpdateInterruptionFilter(Bundle bundle) {
            int interruptionFilter;
            if (bundle.containsKey(WatchFaceService.EXTRA_INTERRUPTION_FILTER) && (interruptionFilter = bundle.getInt(WatchFaceService.EXTRA_INTERRUPTION_FILTER, 1)) != this.mInterruptionFilter) {
                this.mInterruptionFilter = interruptionFilter;
                this.onInterruptionFilterChanged(interruptionFilter);
            }
        }

        private void maybeUpdatePeekCardPosition(Bundle bundle) {
            Rect rect;
            if (bundle.containsKey(WatchFaceService.EXTRA_CARD_LOCATION) && !(rect = Rect.unflattenFromString((String)bundle.getString(WatchFaceService.EXTRA_CARD_LOCATION))).equals((Object)this.mPeekCardPosition)) {
                this.mPeekCardPosition.set(rect);
                this.onPeekCardPositionUpdate(rect);
            }
        }

        private void maybeUpdateAmbientMode(Bundle bundle) {
            boolean inAmbientMode;
            if (bundle.containsKey(WatchFaceService.EXTRA_AMBIENT_MODE) && this.mInAmbientMode != (inAmbientMode = bundle.getBoolean(WatchFaceService.EXTRA_AMBIENT_MODE, false))) {
                this.mInAmbientMode = inAmbientMode;
                this.dispatchAmbientModeChanged();
            }
        }

        private void dispatchAmbientModeChanged() {
            this.onAmbientModeChanged(this.mInAmbientMode);
            if (!this.mInAmbientMode) {
                if (!this.mTimeTickRegistered) {
                    this.mTimeTickRegistered = true;
                    WatchFaceService.this.registerReceiver(this.mTimeTickReceiver, this.mTimeTickFilter);
                }
                this.onTimeTick();
            } else if (this.mTimeTickRegistered) {
                this.mTimeTickRegistered = false;
                WatchFaceService.this.unregisterReceiver(this.mTimeTickReceiver);
            }
        }

        private void maybeUpdateUnreadCount(Bundle bundle) {
            int unreadCount;
            if (bundle.containsKey(WatchFaceService.EXTRA_UNREAD_COUNT) && (unreadCount = bundle.getInt(WatchFaceService.EXTRA_UNREAD_COUNT, 0)) != this.mUnreadCount) {
                this.mUnreadCount = unreadCount;
                this.onUnreadCountChanged(this.mUnreadCount);
            }
        }
    }
}

