/*
 * Decompiled with CFR 0.152.
 */
package android.support.wearable.watchface;

import android.annotation.TargetApi;
import android.graphics.Rect;
import android.opengl.EGL14;
import android.opengl.EGLConfig;
import android.opengl.EGLContext;
import android.opengl.EGLDisplay;
import android.opengl.EGLSurface;
import android.opengl.GLES20;
import android.os.Handler;
import android.os.Message;
import android.support.wearable.watchface.WatchFaceService;
import android.util.Log;
import android.view.Choreographer;
import android.view.SurfaceHolder;
import android.view.WindowInsets;

@TargetApi(value=21)
public abstract class Gles2WatchFaceService
extends WatchFaceService {
    private static final String TAG = "Gles2WatchFaceService";
    private static final boolean LOG_VERBOSE = false;
    private static final boolean TRACE_DRAW = false;
    private static final int[] EGL_CONFIG_ATTRIB_LIST = new int[]{12352, 4, 12324, 8, 12323, 8, 12322, 8, 12321, 8, 12344};
    private static final int[] EGL_CONTEXT_ATTRIB_LIST = new int[]{12440, 2, 12344};
    private static final int[] EGL_SURFACE_ATTRIB_LIST = new int[]{12344};

    @Override
    public Engine onCreateEngine() {
        return new Engine();
    }

    public class Engine
    extends WatchFaceService.Engine {
        private static final int MSG_INVALIDATE = 0;
        private EGLDisplay mEglDisplay;
        private EGLConfig mEglConfig;
        private EGLContext mEglContext;
        private EGLSurface mEglSurface;
        private boolean mDrawRequested;
        private boolean mDestroyed;
        private boolean mCalledOnGlContextCreated;
        private int mInsetLeft;
        private int mInsetBottom;
        private final Choreographer mChoreographer;
        private final Choreographer.FrameCallback mFrameCallback;
        private final Handler mHandler;

        public Engine() {
            super(Gles2WatchFaceService.this);
            this.mChoreographer = Choreographer.getInstance();
            this.mFrameCallback = new Choreographer.FrameCallback(){

                public void doFrame(long frameTimeNs) {
                    if (Engine.this.mDestroyed) {
                        return;
                    }
                    if (Engine.this.mDrawRequested) {
                        Engine.this.drawFrame();
                    }
                }
            };
            this.mHandler = new Handler(){

                public void handleMessage(Message message) {
                    switch (message.what) {
                        case 0: {
                            Engine.this.invalidate();
                        }
                    }
                }
            };
        }

        private boolean createEglContext() {
            if (this.mEglDisplay == null) {
                this.mEglDisplay = EGL14.eglGetDisplay((int)0);
                if (this.mEglDisplay == EGL14.EGL_NO_DISPLAY) {
                    Log.e((String)Gles2WatchFaceService.TAG, (String)"eglGetDisplay returned EGL_NO_DISPLAY");
                    this.mEglDisplay = null;
                    return false;
                }
                int[] version = new int[2];
                if (!EGL14.eglInitialize((EGLDisplay)this.mEglDisplay, (int[])version, (int)0, (int[])version, (int)1)) {
                    Log.e((String)Gles2WatchFaceService.TAG, (String)"eglInitialize failed");
                    this.mEglDisplay = null;
                    return false;
                }
            }
            if (this.mEglConfig == null) {
                int[] numEglConfigs = new int[1];
                EGLConfig[] eglConfigs = new EGLConfig[1];
                if (!EGL14.eglChooseConfig((EGLDisplay)this.mEglDisplay, (int[])EGL_CONFIG_ATTRIB_LIST, (int)0, (EGLConfig[])eglConfigs, (int)0, (int)eglConfigs.length, (int[])numEglConfigs, (int)0)) {
                    Log.e((String)Gles2WatchFaceService.TAG, (String)"eglChooseConfig failed");
                    return false;
                }
                this.mEglConfig = eglConfigs[0];
            }
            if (this.mEglContext == null) {
                this.mEglContext = EGL14.eglCreateContext((EGLDisplay)this.mEglDisplay, (EGLConfig)this.mEglConfig, (EGLContext)EGL14.EGL_NO_CONTEXT, (int[])EGL_CONTEXT_ATTRIB_LIST, (int)0);
                if (this.mEglContext == null) {
                    Log.e((String)Gles2WatchFaceService.TAG, (String)"eglCreateContext returning null");
                    return false;
                }
            }
            return true;
        }

        private void makeContextCurrent() {
            EGL14.eglMakeCurrent((EGLDisplay)this.mEglDisplay, (EGLSurface)this.mEglSurface, (EGLSurface)this.mEglSurface, (EGLContext)this.mEglContext);
        }

        @Override
        public void onCreate(SurfaceHolder surfaceHolder) {
            if (Log.isLoggable((String)Gles2WatchFaceService.TAG, (int)3)) {
                Log.d((String)Gles2WatchFaceService.TAG, (String)"onCreate");
            }
            super.onCreate(surfaceHolder);
            this.createEglContext();
        }

        public void onDestroy() {
            this.mDestroyed = true;
            this.mHandler.removeMessages(0);
            this.mChoreographer.removeFrameCallback(this.mFrameCallback);
            super.onDestroy();
        }

        public void onGlContextCreated() {
        }

        public void onGlSurfaceCreated(int width, int height) {
        }

        public void onApplyWindowInsets(WindowInsets insets) {
            if (Log.isLoggable((String)Gles2WatchFaceService.TAG, (int)3)) {
                Log.d((String)Gles2WatchFaceService.TAG, (String)("onApplyWindowInsets: " + insets));
            }
            super.onApplyWindowInsets(insets);
            Rect bounds = this.getSurfaceHolder().getSurfaceFrame();
            this.mInsetLeft = insets.getSystemWindowInsetLeft();
            this.mInsetBottom = insets.getSystemWindowInsetBottom();
            this.makeContextCurrent();
            GLES20.glViewport((int)(-this.mInsetLeft), (int)(-this.mInsetBottom), (int)bounds.width(), (int)bounds.height());
        }

        public final void onSurfaceChanged(SurfaceHolder holder, int format, int width, int height) {
            if (Log.isLoggable((String)Gles2WatchFaceService.TAG, (int)3)) {
                Log.d((String)Gles2WatchFaceService.TAG, (String)"onSurfaceChanged");
            }
            super.onSurfaceChanged(holder, format, width, height);
            if (this.mEglSurface != null) {
                EGL14.eglDestroySurface((EGLDisplay)this.mEglDisplay, (EGLSurface)this.mEglSurface);
            }
            this.mEglSurface = EGL14.eglCreateWindowSurface((EGLDisplay)this.mEglDisplay, (EGLConfig)this.mEglConfig, (Object)holder.getSurface(), (int[])EGL_SURFACE_ATTRIB_LIST, (int)0);
            this.makeContextCurrent();
            GLES20.glViewport((int)(-this.mInsetLeft), (int)(-this.mInsetBottom), (int)width, (int)height);
            if (!this.mCalledOnGlContextCreated) {
                this.mCalledOnGlContextCreated = true;
                this.onGlContextCreated();
            }
            this.onGlSurfaceCreated(width, height);
            this.invalidate();
        }

        public final void onSurfaceRedrawNeeded(SurfaceHolder holder) {
            if (Log.isLoggable((String)Gles2WatchFaceService.TAG, (int)3)) {
                Log.d((String)Gles2WatchFaceService.TAG, (String)"onSurfaceRedrawNeeded");
            }
            super.onSurfaceRedrawNeeded(holder);
            this.drawFrame();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void onSurfaceDestroyed(SurfaceHolder holder) {
            if (Log.isLoggable((String)Gles2WatchFaceService.TAG, (int)3)) {
                Log.d((String)Gles2WatchFaceService.TAG, (String)"onSurfaceDestroyed");
            }
            try {
                EGL14.eglDestroySurface((EGLDisplay)this.mEglDisplay, (EGLSurface)this.mEglSurface);
                this.mEglSurface = null;
            }
            finally {
                super.onSurfaceDestroyed(holder);
            }
        }

        public final void invalidate() {
            if (!this.mDrawRequested) {
                this.mDrawRequested = true;
                this.mChoreographer.postFrameCallback(this.mFrameCallback);
            }
        }

        public final void postInvalidate() {
            this.mHandler.sendEmptyMessage(0);
        }

        public void onDraw() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void drawFrame() {
            this.mDrawRequested = false;
            if (this.mEglSurface == null) {
                return;
            }
            this.makeContextCurrent();
            this.onDraw();
            EGL14.eglSwapBuffers((EGLDisplay)this.mEglDisplay, (EGLSurface)this.mEglSurface);
        }
    }
}

